/*
 * Decompiled with CFR 0.152.
 */
package kala.function;

import java.util.function.IntConsumer;
import kala.control.Try;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface CheckedIntConsumer<Ex extends Throwable>
extends IntConsumer {
    @Contract(value="_ -> param1", pure=true)
    public static <Ex extends Throwable> CheckedIntConsumer<Ex> of(CheckedIntConsumer<? extends Ex> consumer) {
        return consumer;
    }

    public void acceptChecked(int var1) throws Ex;

    @Override
    default public void accept(int value) {
        try {
            this.acceptChecked(value);
        }
        catch (Throwable e) {
            Try.sneakyThrow(e);
        }
    }

    @Deprecated
    @NotNull
    default public Try<Void> tryAccept(int value) {
        try {
            this.acceptChecked(value);
            return Try.VOID;
        }
        catch (Throwable e) {
            return Try.failure(e);
        }
    }
}

