/*
 * Decompiled with CFR 0.152.
 */
package kala.function;

import java.io.Serializable;
import kala.function.Hasher;
import org.jetbrains.annotations.ApiStatus;

@FunctionalInterface
public interface DoubleHasher
extends Hasher<Double> {
    @ApiStatus.Internal
    public static final DoubleHasher DEFAULT = new Default();
    @ApiStatus.Internal
    public static final DoubleHasher RAW_BITS = new RawBits();
    @ApiStatus.Internal
    public static final DoubleHasher PRIMITIVE = new Primitive();

    public static DoubleHasher defaultHasher() {
        return DEFAULT;
    }

    public static DoubleHasher rawBitsHasher() {
        return RAW_BITS;
    }

    public static DoubleHasher primitiveHasher() {
        return PRIMITIVE;
    }

    @Override
    public int hash(double var1);

    @Override
    default public boolean equals(double a, double b) {
        return Double.doubleToLongBits(a) == Double.doubleToLongBits(b);
    }

    @Override
    @Deprecated
    default public int hash(Double value) {
        return this.hash((double)value);
    }

    @Override
    @Deprecated
    default public boolean equals(Double a, Double b) {
        return this.equals((double)a, (double)b);
    }

    @ApiStatus.Internal
    public static final class Default
    implements DoubleHasher,
    Serializable {
        private static final long serialVersionUID = 0L;

        @Override
        public int hash(double value) {
            return Double.hashCode(value);
        }

        private Object readResolve() {
            return DEFAULT;
        }

        public String toString() {
            return "DoubleHasher.Default";
        }
    }

    @ApiStatus.Internal
    public static final class RawBits
    implements DoubleHasher,
    Serializable {
        private static final long serialVersionUID = 0L;

        RawBits() {
        }

        @Override
        public int hash(double value) {
            return Long.hashCode(Double.doubleToRawLongBits(value));
        }

        @Override
        public boolean equals(double a, double b) {
            return Double.doubleToRawLongBits(a) == Double.doubleToRawLongBits(b);
        }

        private Object readResolve() {
            return RAW_BITS;
        }

        public String toString() {
            return "DoubleHasher.RawBits";
        }
    }

    @ApiStatus.Internal
    public static final class Primitive
    implements DoubleHasher,
    Serializable {
        private static final long serialVersionUID = 0L;

        Primitive() {
        }

        @Override
        public int hash(double value) {
            return Long.hashCode(Double.doubleToRawLongBits(value));
        }

        @Override
        public boolean equals(double a, double b) {
            return a == b;
        }

        private Object readResolve() {
            return PRIMITIVE;
        }

        public String toString() {
            return "DoubleHasher.Primitive";
        }
    }
}

