/*
 * Decompiled with CFR 0.152.
 */
package kala.function;

import java.io.Serializable;
import kala.function.Hasher;
import org.jetbrains.annotations.ApiStatus;

@FunctionalInterface
public interface IntHasher
extends Hasher<Integer> {
    @ApiStatus.Internal
    public static final IntHasher DEFAULT = new Default();

    public static IntHasher defaultHasher() {
        return DEFAULT;
    }

    @Override
    public int hash(int var1);

    @Override
    default public boolean equals(int a, int b) {
        return a == b;
    }

    @Override
    @Deprecated
    default public int hash(Integer value) {
        return this.hash((int)value);
    }

    @Override
    @Deprecated
    default public boolean equals(Integer a, Integer b) {
        return this.equals((int)a, (int)b);
    }

    @ApiStatus.Internal
    public static final class Default
    implements IntHasher,
    Serializable {
        private static final long serialVersionUID = 0L;

        @Override
        public int hash(int value) {
            return Integer.hashCode(value);
        }

        private Object readResolve() {
            return DEFAULT;
        }

        public String toString() {
            return "IntHasher.Default";
        }
    }
}

