/*
 * Decompiled with CFR 0.152.
 */
package kala.function;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Predicates {
    private Predicates() {
    }

    @Contract(value="_ -> param1", pure=true)
    public static <T> Predicate<T> of(Predicate<? extends T> predicate) {
        return predicate;
    }

    @NotNull
    public static <T> Predicate<T> alwaysTrue() {
        return AlwaysTrue.INSTANCE;
    }

    @NotNull
    public static <T> Predicate<T> alwaysFalse() {
        return AlwaysFalse.INSTANCE;
    }

    @NotNull
    public static <T> Predicate<T> isNull() {
        return IsNull.INSTANCE;
    }

    @NotNull
    public static <T> Predicate<T> isNotNull() {
        return IsNotNull.INSTANCE;
    }

    @NotNull
    public static <T> Predicate<T> isEqual(Object target) {
        return target == null ? Predicates.isNull() : new IsEqual(target);
    }

    @NotNull
    public static <T> Predicate<T> isSame(Object target) {
        return target == null ? Predicates.isNull() : new IsSame(target);
    }

    @NotNull
    public static <T> Predicate<T> instanceOf(@NotNull Class<? extends T> type) {
        Objects.requireNonNull(type);
        return type == Object.class ? Predicates.isNotNull() : new InstanceOf(type);
    }

    @NotNull
    public static <T> Predicate<T> and(Predicate<? super T> ... predicates) {
        if (predicates.length < 2) {
            throw new IllegalArgumentException();
        }
        return new And((Predicate[])predicates.clone());
    }

    @NotNull
    public static <T> Predicate<T> or(Predicate<? super T> ... predicates) {
        if (predicates.length < 2) {
            throw new IllegalArgumentException();
        }
        return new Or((Predicate[])predicates.clone());
    }

    @NotNull
    public static <T, U> Predicate<Tuple2<T, U>> tupled(@NotNull BiPredicate<? super T, ? super U> biPredicate) {
        Objects.requireNonNull(biPredicate);
        return tuple -> biPredicate.test((Object)tuple.component1(), (Object)tuple.component2());
    }

    @NotNull
    public static <T, U> BiPredicate<T, U> untupled(@NotNull Predicate<? super Tuple2<? extends T, ? extends U>> predicate) {
        Objects.requireNonNull(predicate);
        return (t, u) -> predicate.test(Tuple.of(t, u));
    }

    private static enum AlwaysTrue implements Predicate<Object>
    {
        INSTANCE;


        @Override
        public final boolean test(Object o) {
            return true;
        }

        @Override
        @NotNull
        public final Predicate<Object> negate() {
            return AlwaysFalse.INSTANCE;
        }

        @Override
        @NotNull
        public final Predicate<Object> and(@NotNull Predicate<? super Object> other) {
            return other;
        }

        @Override
        @NotNull
        public final Predicate<Object> or(@NotNull Predicate<? super Object> other) {
            return this;
        }

        public final String toString() {
            return "Predicates.AlwaysTrue";
        }
    }

    private static enum AlwaysFalse implements Predicate<Object>
    {
        INSTANCE;


        @Override
        public final boolean test(Object o) {
            return false;
        }

        @Override
        @NotNull
        public final Predicate<Object> negate() {
            return AlwaysTrue.INSTANCE;
        }

        @Override
        @NotNull
        public final Predicate<Object> and(@NotNull Predicate<? super Object> other) {
            return this;
        }

        @Override
        @NotNull
        public final Predicate<Object> or(@NotNull Predicate<? super Object> other) {
            return other;
        }

        public final String toString() {
            return "Predicates.AlwaysFalse";
        }
    }

    private static enum IsNull implements Predicate<Object>
    {
        INSTANCE;


        @Override
        public final boolean test(Object o) {
            return o == null;
        }

        @Override
        @NotNull
        public final Predicate<Object> negate() {
            return IsNotNull.INSTANCE;
        }

        public final String toString() {
            return "Predicates.IsNull";
        }
    }

    private static enum IsNotNull implements Predicate<Object>
    {
        INSTANCE;


        @Override
        public final boolean test(Object o) {
            return o != null;
        }

        @Override
        @NotNull
        public final Predicate<Object> negate() {
            return IsNull.INSTANCE;
        }

        public final String toString() {
            return "Predicates.IsNotNull";
        }
    }

    private static final class IsEqual<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = -9166392848522200720L;
        private static final int HASH_MAGIC = -793051311;
        @NotNull
        private final Object target;

        IsEqual(@NotNull Object target) {
            this.target = target;
        }

        @Override
        public boolean test(T t) {
            return this.target.equals(t);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IsEqual)) {
                return false;
            }
            return this.target.equals(((IsEqual)o).target);
        }

        public int hashCode() {
            return -793051311 + this.target.hashCode();
        }

        public String toString() {
            return "Predicates.IsEqual[" + this.target + ']';
        }
    }

    private static final class IsSame<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = 8158787942500779468L;
        private static final int HASH_MAGIC = 1242821667;
        @NotNull
        private final Object target;

        IsSame(@NotNull Object target) {
            this.target = target;
        }

        @Override
        public boolean test(T t) {
            return this.target == t;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IsEqual)) {
                return false;
            }
            return this.target == ((IsEqual)o).target;
        }

        public int hashCode() {
            return 1242821667 + this.target.hashCode();
        }

        public String toString() {
            return "Predicates.IsSame[" + this.target + ']';
        }
    }

    private static final class InstanceOf<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = -8612667810008827121L;
        private static final int HASH_MAGIC = 990779813;
        @NotNull
        private final Class<?> type;

        InstanceOf(@NotNull Class<?> type) {
            this.type = type;
        }

        @Override
        public boolean test(T t) {
            return this.type.isInstance(t);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InstanceOf)) {
                return false;
            }
            return this.type.equals(((InstanceOf)o).type);
        }

        public int hashCode() {
            return 990779813 + this.type.hashCode();
        }

        public String toString() {
            return "Predicates.InstanceOf[" + this.type + ']';
        }
    }

    private static final class And<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = -5136772671431728242L;
        private static final int HASH_MAGIC = 67623;
        private final Predicate<? super T>[] predicates;

        And(Predicate<? super T>[] predicates) {
            this.predicates = predicates;
        }

        @Override
        public boolean test(T t) {
            for (Predicate<T> predicate : this.predicates) {
                if (predicate.test(t)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof And)) {
                return false;
            }
            And other = (And)o;
            return Arrays.equals(this.predicates, other.predicates);
        }

        public int hashCode() {
            return 67623 + Arrays.hashCode(this.predicates);
        }

        public String toString() {
            return "Predicates.And" + Arrays.toString(this.predicates);
        }
    }

    private static final class Or<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = -3902328690682783689L;
        private static final int HASH_MAGIC = -2329323;
        private final Predicate<? super T>[] predicates;

        Or(Predicate<? super T>[] predicates) {
            this.predicates = predicates;
        }

        @Override
        public boolean test(T t) {
            for (Predicate<T> predicate : this.predicates) {
                if (!predicate.test(t)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Or)) {
                return false;
            }
            Or other = (Or)o;
            return Arrays.equals(this.predicates, other.predicates);
        }

        public int hashCode() {
            return -2329323 + Arrays.hashCode(this.predicates);
        }

        public String toString() {
            return "Predicates.Or" + Arrays.toString(this.predicates);
        }
    }
}

