/*
 * Decompiled with CFR 0.152.
 */
package kala.function;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Supplier;
import kala.function.Memoized;
import kala.value.LazyValue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Suppliers {
    private Suppliers() {
    }

    @Contract(value="_ -> param1", pure=true)
    public static <T> Supplier<T> of(Supplier<? extends T> supplier) {
        return supplier;
    }

    @NotNull
    public static <T> Supplier<T> constant(T value) {
        return new Constant<T>(value);
    }

    @NotNull
    public static <T> Supplier<T> memoized(@NotNull Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier);
        if (supplier instanceof Memoized) {
            return supplier;
        }
        return LazyValue.of(supplier);
    }

    private static final class Constant<T>
    implements Supplier<T>,
    Memoized,
    Serializable {
        private final T value;

        Constant(T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }

        public String toString() {
            return "Suppliers.Constant[value=" + this.value + ']';
        }
    }
}

