/*
 * Decompiled with CFR 0.152.
 */
package kala.internal;

import java.util.Arrays;
import kala.collection.base.primitive.ShortArrays;
import kala.collection.base.primitive.ShortIterator;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class InternalShortArrayBuilder {
    private static final int DEFAULT_CAPACITY = 16;
    private short[] elements = ShortArrays.EMPTY;
    private int size = 0;

    private void grow() {
        short[] newArray;
        int oldCapacity = this.elements.length;
        if (oldCapacity == 0) {
            newArray = new short[Math.max(16, this.size + 1)];
        } else {
            int newCapacity = Math.max(Math.max(oldCapacity, this.size + 1), oldCapacity + (oldCapacity >> 1));
            newArray = new short[newCapacity];
        }
        if (this.elements.length != 0) {
            System.arraycopy(this.elements, 0, newArray, 0, this.size);
        }
        this.elements = newArray;
    }

    public int size() {
        return this.size;
    }

    public short get(int idx) {
        return this.elements[idx];
    }

    public void set(int idx, short newValue) {
        this.elements[idx] = newValue;
    }

    public void append(short value) {
        if (this.size == this.elements.length) {
            this.grow();
        }
        this.elements[this.size++] = value;
    }

    public short[] toArray() {
        return this.elements.length == this.size ? this.elements : Arrays.copyOf(this.elements, this.size);
    }

    public ShortIterator iterator() {
        return ShortArrays.iterator(this.elements, 0, this.size);
    }
}

