/*
 * Decompiled with CFR 0.152.
 */
package kala.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class RecordAccessor {
    static final RecordAccessor accessor;

    abstract boolean isRecord(Object var1);

    abstract ComponentAccessor[] getComponentAccessors(Object var1);

    static {
        RecordAccessor a = null;
        try {
            Class<?> cls = Class.forName("java.lang.Record");
            Class<?> rcCls = Class.forName("java.lang.reflect.RecordComponent");
            a = new Default(cls, Class.class.getMethod("getRecordComponents", new Class[0]), rcCls.getMethod("getName", new Class[0]), rcCls.getMethod("getAccessor", new Class[0]));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (a == null) {
            a = new Fallback();
        }
        accessor = a;
    }

    private static final class Default
    extends RecordAccessor {
        private final Class<?> recordCls;
        private final Method classGetRecordComponentsMethod;
        private final Method recordComponentGetNameMethod;
        private final Method recordComponentGetAccessorMethod;

        private Default(Class<?> recordCls, Method classGetRecordComponentsMethod, Method recordComponentGetNameMethod, Method recordComponentGetAccessorMethod) {
            this.recordCls = recordCls;
            this.classGetRecordComponentsMethod = classGetRecordComponentsMethod;
            this.recordComponentGetNameMethod = recordComponentGetNameMethod;
            this.recordComponentGetAccessorMethod = recordComponentGetAccessorMethod;
        }

        @Override
        boolean isRecord(Object obj) {
            return this.recordCls.isInstance(obj);
        }

        @Override
        ComponentAccessor[] getComponentAccessors(Object obj) {
            try {
                Object[] components = (Object[])this.classGetRecordComponentsMethod.invoke(obj.getClass(), new Object[0]);
                ComponentAccessor[] res = new ComponentAccessor[components.length];
                for (int i = 0; i < components.length; ++i) {
                    Object c = components[i];
                    res[i] = new ComponentAccessor((String)this.recordComponentGetNameMethod.invoke(c, new Object[0]), (Method)this.recordComponentGetAccessorMethod.invoke(c, new Object[0]));
                }
                return res;
            }
            catch (Throwable e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static final class Fallback
    extends RecordAccessor {
        private Fallback() {
        }

        @Override
        boolean isRecord(Object obj) {
            return false;
        }

        @Override
        ComponentAccessor[] getComponentAccessors(Object obj) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class ComponentAccessor {
        private final String name;
        private final Method accessor;

        ComponentAccessor(String name, Method accessor) {
            this.name = name;
            this.accessor = accessor;
        }

        public String getName() {
            return this.name;
        }

        public Object getComponent(Object value) {
            try {
                return this.accessor.invoke(value, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

