/*
 * Decompiled with CFR 0.152.
 */
package kala.io;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.InputMismatchException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StdIn {
    private static final int BUFFER_SIZE = 128;
    private static InputStream in;
    private static BufferedReader reader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedReader reader() {
        InputStream stdin = System.in;
        if (in == stdin) {
            return reader;
        }
        Class<StdIn> clazz = StdIn.class;
        synchronized (StdIn.class) {
            if (in == stdin) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return reader;
            }
            if (stdin == null) {
                in = null;
                reader = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(stdin), 128);
            in = stdin;
            StdIn.reader = reader;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return reader;
        }
    }

    public static InputStream stdin() {
        return System.in;
    }

    public static PrintStream stdout() {
        return System.out;
    }

    public static PrintStream stderr() {
        return System.err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearStdIOCache() {
        PrintStream out = System.out;
        if (out != null) {
            out.flush();
        }
        Class<StdIn> clazz = StdIn.class;
        synchronized (StdIn.class) {
            in = null;
            reader = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @NotNull
    public static String readLine() throws IOException {
        return Objects.requireNonNull(StdIn.reader(), "System.in is null").readLine();
    }

    @NotNull
    public static String readLine(String prompt) throws IOException {
        System.out.print(prompt);
        System.out.flush();
        return StdIn.readLine();
    }

    public static char @NotNull [] readPassword() throws IOException, UnsupportedOperationException {
        Console console = System.console();
        if (console == null) {
            throw new UnsupportedOperationException("System.console() is null");
        }
        return console.readPassword();
    }

    public static char @NotNull [] readPassword(String prompt) throws IOException, UnsupportedOperationException {
        Console console = System.console();
        if (console == null) {
            throw new UnsupportedOperationException("System.console() is null");
        }
        return console.readPassword("%s", prompt);
    }

    public static char readChar() throws IOException, InputMismatchException {
        String s = StdIn.readLine();
        if (s.length() != 1) {
            throw new InputMismatchException("For input string: \"" + s + '\"');
        }
        return s.charAt(0);
    }

    public static char readChar(String prompt) throws IOException, InputMismatchException {
        String s = StdIn.readLine(prompt);
        if (s.length() != 1) {
            throw new InputMismatchException("For input string: \"" + s + '\"');
        }
        return s.charAt(0);
    }

    @Nullable
    public static Character readCharOrNull() throws IOException {
        String s = StdIn.readLine();
        if (s.length() != 1) {
            return null;
        }
        return Character.valueOf(s.charAt(0));
    }

    @Nullable
    public static Character readCharOrNull(String prompt) throws IOException {
        String s = StdIn.readLine(prompt);
        if (s.length() != 1) {
            return null;
        }
        return Character.valueOf(s.charAt(0));
    }

    public static int readInt() throws IOException, InputMismatchException {
        return StdIn.readInt(10);
    }

    public static int readInt(int radix) throws IOException, InputMismatchException {
        try {
            return Integer.parseInt(StdIn.readLine().trim(), radix);
        }
        catch (NumberFormatException e) {
            throw new InputMismatchException(e.getMessage());
        }
    }

    public static int readInt(String prompt) throws IOException, InputMismatchException {
        return StdIn.readInt(prompt, 10);
    }

    public static int readInt(String prompt, int radix) throws IOException, InputMismatchException {
        try {
            return Integer.parseInt(StdIn.readLine(prompt).trim(), radix);
        }
        catch (NumberFormatException e) {
            throw new InputMismatchException(e.getMessage());
        }
    }

    @Nullable
    public static Integer readIntOrNull() throws IOException {
        return StdIn.readIntOrNull(10);
    }

    @Nullable
    public static Integer readIntOrNull(int radix) throws IOException {
        try {
            return Integer.parseInt(StdIn.readLine().trim(), radix);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Integer readIntOrNull(String prompt) throws IOException {
        return StdIn.readIntOrNull(prompt, 10);
    }

    @Nullable
    public static Integer readIntOrNull(String prompt, int radix) throws IOException {
        try {
            return Integer.parseInt(StdIn.readLine(prompt).trim(), radix);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static long readLong() throws IOException, InputMismatchException {
        return StdIn.readLong(10);
    }

    public static long readLong(int radix) throws IOException, InputMismatchException {
        try {
            return Long.parseLong(StdIn.readLine().trim(), radix);
        }
        catch (NumberFormatException e) {
            throw new InputMismatchException(e.getMessage());
        }
    }

    public static long readLong(String prompt) throws IOException, InputMismatchException {
        return StdIn.readLong(prompt, 10);
    }

    public static long readLong(String prompt, int radix) throws IOException, InputMismatchException {
        try {
            return Long.parseLong(StdIn.readLine(prompt).trim(), radix);
        }
        catch (NumberFormatException e) {
            throw new InputMismatchException(e.getMessage());
        }
    }

    @Nullable
    public static Long readLongOrNull() throws IOException {
        return StdIn.readLongOrNull(10);
    }

    @Nullable
    public static Long readLongOrNull(int radix) throws IOException {
        try {
            return Long.parseLong(StdIn.readLine().trim(), radix);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Long readLongOrNull(String prompt) throws IOException {
        return StdIn.readLongOrNull(prompt, 10);
    }

    @Nullable
    public static Long readLongOrNull(String prompt, int radix) throws IOException {
        try {
            return Long.parseLong(StdIn.readLine(prompt).trim(), radix);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    public static BigInteger readBigInteger() throws IOException, InputMismatchException {
        return StdIn.readBigInteger(10);
    }

    @NotNull
    public static BigInteger readBigInteger(int radix) throws IOException, InputMismatchException {
        try {
            return new BigInteger(StdIn.readLine().trim(), radix);
        }
        catch (NumberFormatException e) {
            throw new InputMismatchException(e.getMessage());
        }
    }

    @NotNull
    public static BigInteger readBigInteger(String prompt) throws IOException, InputMismatchException {
        return StdIn.readBigInteger(prompt, 10);
    }

    @NotNull
    public static BigInteger readBigInteger(String prompt, int radix) throws IOException, InputMismatchException {
        try {
            return new BigInteger(StdIn.readLine(prompt).trim(), radix);
        }
        catch (NumberFormatException e) {
            throw new InputMismatchException(e.getMessage());
        }
    }

    @Nullable
    public static BigInteger readBigIntegerOrNull() throws IOException, InputMismatchException {
        return StdIn.readBigIntegerOrNull(10);
    }

    @Nullable
    public static BigInteger readBigIntegerOrNull(int radix) throws IOException, InputMismatchException {
        try {
            return new BigInteger(StdIn.readLine().trim(), radix);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static BigInteger readBigIntegerOrNull(String prompt) throws IOException, InputMismatchException {
        return StdIn.readBigIntegerOrNull(prompt, 10);
    }

    @Nullable
    public static BigInteger readBigIntegerOrNull(String prompt, int radix) throws IOException, InputMismatchException {
        try {
            return new BigInteger(StdIn.readLine(prompt).trim(), radix);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static double readDouble() throws IOException, InputMismatchException {
        try {
            return Double.parseDouble(StdIn.readLine().trim());
        }
        catch (NumberFormatException e) {
            throw new InputMismatchException(e.getMessage());
        }
    }

    public static double readDouble(String prompt) throws IOException, InputMismatchException {
        try {
            return Double.parseDouble(StdIn.readLine(prompt).trim());
        }
        catch (NumberFormatException e) {
            throw new InputMismatchException(e.getMessage());
        }
    }

    @Nullable
    public static Double readDoubleOrNull() throws IOException, InputMismatchException {
        try {
            return Double.parseDouble(StdIn.readLine().trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Double readDoubleOrNull(String prompt) throws IOException, InputMismatchException {
        try {
            return Double.parseDouble(StdIn.readLine(prompt).trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    public static BigDecimal readBigDecimal() throws IOException, InputMismatchException {
        try {
            return new BigDecimal(StdIn.readLine().trim());
        }
        catch (NumberFormatException e) {
            throw new InputMismatchException(e.getMessage());
        }
    }

    @NotNull
    public static BigDecimal readBigDecimal(String prompt) throws IOException, InputMismatchException {
        try {
            return new BigDecimal(StdIn.readLine(prompt).trim());
        }
        catch (NumberFormatException e) {
            throw new InputMismatchException(e.getMessage());
        }
    }

    @NotNull
    public static BigDecimal readBigDecimal(@NotNull MathContext mc) throws IOException, InputMismatchException {
        try {
            return new BigDecimal(StdIn.readLine().trim(), mc);
        }
        catch (NumberFormatException e) {
            throw new InputMismatchException(e.getMessage());
        }
    }

    @NotNull
    public static BigDecimal readBigDecimal(String prompt, @NotNull MathContext mc) throws IOException, InputMismatchException {
        try {
            return new BigDecimal(StdIn.readLine(prompt).trim(), mc);
        }
        catch (NumberFormatException e) {
            throw new InputMismatchException(e.getMessage());
        }
    }

    @Nullable
    public static BigDecimal readBigDecimalOrNull() throws IOException, InputMismatchException {
        try {
            return new BigDecimal(StdIn.readLine().trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static BigDecimal readBigDecimalOrNull(String prompt) throws IOException, InputMismatchException {
        try {
            return new BigDecimal(StdIn.readLine(prompt).trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static BigDecimal readBigDecimalOrNull(@NotNull MathContext mc) throws IOException, InputMismatchException {
        try {
            return new BigDecimal(StdIn.readLine().trim(), mc);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static BigDecimal readBigDecimalOrNull(String prompt, @NotNull MathContext mc) throws IOException, InputMismatchException {
        try {
            return new BigDecimal(StdIn.readLine(prompt).trim(), mc);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private StdIn() {
    }
}

