/*
 * Decompiled with CFR 0.152.
 */
package kala.range.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.base.primitive.AbstractCharIterator;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.function.CharConsumer;
import kala.range.BoundType;
import kala.range.RangeType;
import kala.range.primitive.IntegralRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class CharRange
extends IntegralRange<Character>
implements CharTraversable,
Serializable {
    private static final long serialVersionUID = 441922964163250803L;
    private static final int HASH_MAGIC = 1190494279;
    public static final int DEFAULT_STEP = 1;
    public static final int MAX_STEP = 65535;
    public static final int MAX_REVERSE_STEP = -65535;
    private static final CharRange ALL = new CharRange(RangeType.CLOSED, '\u0000', '\uffff');
    private static final CharRange EMPTY = new CharRange(RangeType.EMPTY, '\u0000', '\u0000');
    @NotNull
    private final RangeType type;
    private final char lowerBound;
    private final char upperBound;

    private CharRange(@NotNull RangeType type, char lowerBound, char upperBound) {
        this.type = type;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @NotNull
    public static CharRange all() {
        return ALL;
    }

    @NotNull
    public static CharRange empty() {
        return EMPTY;
    }

    @NotNull
    public static CharRange is(char value) {
        return new CharRange(RangeType.CLOSED, value, value);
    }

    @NotNull
    public static CharRange open(char lowerBound, char upperBound) {
        if (lowerBound >= upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than upperBound");
        }
        return new CharRange(RangeType.OPEN, lowerBound, upperBound);
    }

    @NotNull
    public static CharRange closed(char lowerBound, char upperBound) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        return new CharRange(RangeType.CLOSED, lowerBound, upperBound);
    }

    @NotNull
    public static CharRange openClosed(char lowerBound, char upperBound) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        return new CharRange(RangeType.OPEN_CLOSED, lowerBound, upperBound);
    }

    @NotNull
    public static CharRange closedOpen(char lowerBound, char upperBound) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        return new CharRange(RangeType.CLOSED_OPEN, lowerBound, upperBound);
    }

    @NotNull
    public static CharRange greaterThan(char lowerBound) {
        return new CharRange(RangeType.OPEN_CLOSED, lowerBound, '\uffff');
    }

    @NotNull
    public static CharRange atLeast(char lowerBound) {
        return new CharRange(RangeType.CLOSED, lowerBound, '\uffff');
    }

    @NotNull
    public static CharRange lessThan(char upperBound) {
        return new CharRange(RangeType.CLOSED_OPEN, '\u0000', upperBound);
    }

    @NotNull
    public static CharRange atMost(char upperBound) {
        return new CharRange(RangeType.CLOSED, '\u0000', upperBound);
    }

    @Override
    @NotNull
    public RangeType getType() {
        return this.type;
    }

    public char getLowerBound() {
        if (!this.hasLowerBound()) {
            throw new UnsupportedOperationException();
        }
        return this.lowerBound;
    }

    public char getUpperBound() {
        if (!this.hasUpperBound()) {
            throw new UnsupportedOperationException();
        }
        return this.upperBound;
    }

    private char strictLowerBound() {
        return this.type.getLowerBoundType() == BoundType.OPEN ? (char)(this.lowerBound + '\u0001') : this.lowerBound;
    }

    private char strictUpperBound() {
        return this.type.getUpperBoundType() == BoundType.OPEN ? (char)(this.upperBound - '\u0001') : this.upperBound;
    }

    public char fit(char value) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("Range is empty");
        }
        char strictLowerBound = this.strictLowerBound();
        char strictUpperBound = this.strictUpperBound();
        if (strictLowerBound >= value) {
            return strictLowerBound;
        }
        if (strictUpperBound <= value) {
            return strictUpperBound;
        }
        return value;
    }

    @Override
    public boolean isEmpty() {
        return this.type == RangeType.EMPTY || this.lowerBound == this.upperBound && this.type.getLowerBoundType() != this.type.getUpperBoundType();
    }

    @Override
    public boolean contains(char value) {
        if (this == ALL) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        return value >= this.strictLowerBound() && value <= this.strictUpperBound();
    }

    @Override
    @NotNull
    public CharIterator iterator() {
        char strictUpperBound;
        if (this.isEmpty()) {
            return CharIterator.empty();
        }
        char strictLowerBound = this.strictLowerBound();
        if (strictLowerBound == (strictUpperBound = this.strictUpperBound())) {
            return CharIterator.of(strictLowerBound);
        }
        return new PositiveItr(strictUpperBound, 1, strictLowerBound);
    }

    @Override
    public void forEach(@NotNull CharConsumer action) {
        this.forEachByStep(1, action);
    }

    void forEachByStep(int step, @NotNull CharConsumer action) {
        Objects.requireNonNull(action);
        if (step == 0) {
            throw new IllegalArgumentException("step mush not be zero");
        }
        if (step > 65535 || step < -65535) {
            throw new IllegalArgumentException("step too large");
        }
        if (this.isEmpty()) {
            return;
        }
        char strictLowerBound = this.strictLowerBound();
        char strictUpperBound = this.strictUpperBound();
        if (step > 0) {
            char value = strictLowerBound;
            while (value <= strictUpperBound) {
                action.accept(value);
                if (65535 - step >= value) {
                    value = (char)(value + step);
                    continue;
                }
                break;
            }
        } else {
            char value = strictUpperBound;
            while (value >= strictLowerBound) {
                action.accept(value);
                if (0 - step <= value) {
                    value = (char)(value + step);
                    continue;
                }
                break;
            }
        }
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + Character.hashCode(this.lowerBound);
        result = result * 31 + Character.hashCode(this.upperBound);
        return result + 1190494279;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CharRange)) {
            return false;
        }
        CharRange CharRange2 = (CharRange)o;
        return this.lowerBound == CharRange2.lowerBound && this.upperBound == CharRange2.upperBound && this.type == CharRange2.type;
    }

    private static String prettyToString(char value) {
        if (value >= ' ' && value <= '~' && value != '\'' && value != '\\') {
            return "'" + value + "'";
        }
        switch (value) {
            case '\u0000': {
                return "'\\0'";
            }
            case '\uffff': {
                return "Character.MAX_VALUE";
            }
            case '\t': {
                return "'\\t'";
            }
            case '\'': {
                return "'\\''";
            }
            case '\r': {
                return "'\\r'";
            }
            case '\\': {
                return "'\\\\'";
            }
            case '\n': {
                return "'\\n'";
            }
            case '\f': {
                return "'\\f'";
            }
            case '\b': {
                return "'\\b'";
            }
        }
        return String.format("'\\u%04X'", value);
    }

    public String toString() {
        if (this == EMPTY) {
            return "CharRange.Empty";
        }
        if (this == ALL) {
            return "CharRange.All";
        }
        BoundType lowerBoundType = this.type.getLowerBoundType();
        BoundType upperBoundType = this.type.getUpperBoundType();
        StringBuilder res = new StringBuilder(32);
        res.append("CharRange");
        switch (lowerBoundType) {
            case OPEN: {
                res.append('(');
                break;
            }
            case CLOSED: {
                res.append('[');
                break;
            }
            case INFINITY: {
                throw new AssertionError();
            }
        }
        res.append(CharRange.prettyToString(this.lowerBound)).append("..").append(CharRange.prettyToString(this.upperBound));
        switch (upperBoundType) {
            case OPEN: {
                res.append(')');
                break;
            }
            case CLOSED: {
                res.append(']');
                break;
            }
            case INFINITY: {
                throw new AssertionError();
            }
        }
        return res.toString();
    }

    private static final class PositiveItr
    extends AbstractCharIterator {
        private char upperBound;
        private final @Range(from=1L, to=65535L) int step;
        private char value;

        PositiveItr(char upperBound, int step, char initialValue) {
            this.upperBound = upperBound;
            this.step = step;
            this.value = initialValue;
        }

        @Override
        public boolean hasNext() {
            return this.value <= this.upperBound;
        }

        @Override
        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            char res = this.value;
            if (65535 - this.step < this.value) {
                this.upperBound = '\u0000';
                this.value = (char)65535;
            } else {
                this.value = (char)(this.value + this.step);
            }
            return res;
        }
    }

    private static final class ReverseItr
    extends AbstractCharIterator {
        private char lowerBound;
        private final @Range(from=-65535L, to=-1L) int step;
        private char value;

        private ReverseItr(char lowerBound, @Range(from=0L, to=-1L) int step, char initialValue) {
            this.lowerBound = lowerBound;
            this.step = step;
            this.value = initialValue;
        }

        @Override
        public boolean hasNext() {
            return this.value >= this.lowerBound;
        }

        @Override
        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            char res = this.value;
            if (0 - this.step > this.value) {
                this.lowerBound = (char)65535;
                this.value = '\u0000';
            } else {
                this.value = (char)(this.value + this.step);
            }
            return res;
        }
    }
}

