/*
 * Decompiled with CFR 0.152.
 */
package kala.range.primitive;

import kala.range.BoundType;
import kala.range.RangeType;
import kala.range.primitive.FloatingRange;
import org.jetbrains.annotations.NotNull;

public final class DoubleRange
extends FloatingRange<Double> {
    private static final long serialVersionUID = -4873709673630243732L;
    private static final int HASH_MAGIC = -253585521;
    private static final DoubleRange ALL = new DoubleRange(RangeType.ALL, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    private static final DoubleRange EMPTY = new DoubleRange(RangeType.EMPTY, Double.NaN, Double.NaN);
    @NotNull
    private final RangeType type;
    private final double lowerBound;
    private final double upperBound;

    private DoubleRange(@NotNull RangeType type, double lowerBound, double upperBound) {
        this.type = type;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @NotNull
    public static DoubleRange all() {
        return ALL;
    }

    @NotNull
    public static DoubleRange empty() {
        return EMPTY;
    }

    @NotNull
    public static DoubleRange is(double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("value should not be NaN");
        }
        if (Double.isInfinite(value)) {
            throw new IllegalArgumentException();
        }
        return new DoubleRange(RangeType.CLOSED, value, value);
    }

    @NotNull
    public static DoubleRange open(double lowerBound, double upperBound) {
        if (Double.isNaN(lowerBound) || Double.isNaN(upperBound)) {
            throw new IllegalArgumentException("bound should not be NaN");
        }
        if (lowerBound >= upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than upperBound");
        }
        if (lowerBound == Double.NEGATIVE_INFINITY) {
            if (upperBound == Double.POSITIVE_INFINITY) {
                return ALL;
            }
            if (upperBound == Double.MIN_VALUE) {
                return EMPTY;
            }
            return new DoubleRange(RangeType.LESS_THAN, Double.NEGATIVE_INFINITY, upperBound);
        }
        if (upperBound == Double.POSITIVE_INFINITY) {
            if (lowerBound == Double.MAX_VALUE) {
                return EMPTY;
            }
            return new DoubleRange(RangeType.GREATER_THAN, lowerBound, Double.POSITIVE_INFINITY);
        }
        return new DoubleRange(RangeType.OPEN, lowerBound, upperBound);
    }

    @NotNull
    public static DoubleRange closed(double lowerBound, double upperBound) {
        if (Double.isNaN(lowerBound) || Double.isNaN(upperBound)) {
            throw new IllegalArgumentException("bound should not be NaN");
        }
        if (Double.isInfinite(lowerBound) || Double.isInfinite(upperBound)) {
            throw new IllegalArgumentException();
        }
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        return new DoubleRange(RangeType.CLOSED, lowerBound, upperBound);
    }

    @NotNull
    public static DoubleRange openClosed(double lowerBound, double upperBound) {
        if (Double.isNaN(lowerBound) || Double.isNaN(upperBound)) {
            throw new IllegalArgumentException("bound should not be NaN");
        }
        if (Double.isInfinite(upperBound)) {
            throw new IllegalArgumentException();
        }
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        if (lowerBound == Double.NEGATIVE_INFINITY) {
            return new DoubleRange(RangeType.AT_MOST, Double.NEGATIVE_INFINITY, upperBound);
        }
        return new DoubleRange(RangeType.OPEN_CLOSED, lowerBound, upperBound);
    }

    @NotNull
    public static DoubleRange closedOpen(double lowerBound, double upperBound) {
        if (Double.isNaN(lowerBound) || Double.isNaN(upperBound)) {
            throw new IllegalArgumentException("bound should not be NaN");
        }
        if (Double.isInfinite(lowerBound)) {
            throw new IllegalArgumentException();
        }
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        if (upperBound == Double.POSITIVE_INFINITY) {
            return new DoubleRange(RangeType.AT_LEAST, lowerBound, Double.POSITIVE_INFINITY);
        }
        return new DoubleRange(RangeType.CLOSED_OPEN, lowerBound, upperBound);
    }

    @NotNull
    public static DoubleRange greaterThan(double lowerBound) {
        if (Double.isNaN(lowerBound)) {
            throw new IllegalArgumentException("lowerBound should not be NaN");
        }
        if (lowerBound == Double.NEGATIVE_INFINITY) {
            return ALL;
        }
        if (lowerBound == Double.POSITIVE_INFINITY) {
            return EMPTY;
        }
        return new DoubleRange(RangeType.GREATER_THAN, lowerBound, Double.POSITIVE_INFINITY);
    }

    @NotNull
    public static DoubleRange atLeast(double lowerBound) {
        if (Double.isNaN(lowerBound)) {
            throw new IllegalArgumentException("lowerBound should not be NaN");
        }
        if (Double.isInfinite(lowerBound)) {
            throw new IllegalArgumentException();
        }
        return new DoubleRange(RangeType.AT_LEAST, lowerBound, Double.POSITIVE_INFINITY);
    }

    @NotNull
    public static DoubleRange lessThan(double upperBound) {
        if (Double.isNaN(upperBound)) {
            throw new IllegalArgumentException("upperBound should not be NaN");
        }
        if (upperBound == Double.POSITIVE_INFINITY) {
            return ALL;
        }
        if (upperBound == Double.NEGATIVE_INFINITY) {
            return EMPTY;
        }
        return new DoubleRange(RangeType.LESS_THAN, Double.NEGATIVE_INFINITY, upperBound);
    }

    @NotNull
    public static DoubleRange atMost(double upperBound) {
        if (Double.isNaN(upperBound)) {
            throw new IllegalArgumentException("upperBound should not be NaN");
        }
        if (Double.isInfinite(upperBound)) {
            throw new IllegalArgumentException();
        }
        return new DoubleRange(RangeType.AT_MOST, Double.NEGATIVE_INFINITY, upperBound);
    }

    @Override
    @NotNull
    public RangeType getType() {
        return this.type;
    }

    public double getLowerBound() {
        if (!this.hasLowerBound()) {
            throw new UnsupportedOperationException();
        }
        return this.lowerBound;
    }

    public double getUpperBound() {
        if (!this.hasUpperBound()) {
            throw new UnsupportedOperationException();
        }
        return this.upperBound;
    }

    boolean contains(double value) {
        if (!Double.isFinite(value) || this.type == RangeType.EMPTY) {
            return false;
        }
        BoundType lowerBoundType = this.type.getLowerBoundType();
        BoundType upperBoundType = this.type.getUpperBoundType();
        switch (lowerBoundType) {
            case OPEN: {
                if (!(this.lowerBound >= value)) break;
                return false;
            }
            case CLOSED: {
                if (!(this.lowerBound > value)) break;
                return false;
            }
        }
        switch (upperBoundType) {
            case OPEN: {
                if (!(this.upperBound <= value)) break;
                return false;
            }
            case CLOSED: {
                if (!(this.upperBound < value)) break;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + Double.hashCode(this.lowerBound);
        result = result * 31 + Double.hashCode(this.upperBound);
        return result + -253585521;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoubleRange)) {
            return false;
        }
        DoubleRange other = (DoubleRange)o;
        return this.type == other.type && Double.doubleToLongBits(this.lowerBound) == Double.doubleToLongBits(other.lowerBound) && Double.doubleToLongBits(this.upperBound) == Double.doubleToLongBits(other.upperBound);
    }

    public String toString() {
        if (this == EMPTY) {
            return "DoubleRange.Empty";
        }
        if (this == ALL) {
            return "DoubleRange.All";
        }
        BoundType lowerBoundType = this.type.getLowerBoundType();
        BoundType upperBoundType = this.type.getUpperBoundType();
        StringBuilder res = new StringBuilder(32);
        res.append("DoubleRange");
        switch (lowerBoundType) {
            case OPEN: {
                res.append('(').append(this.lowerBound);
                break;
            }
            case CLOSED: {
                res.append('[').append(this.lowerBound);
                break;
            }
            case INFINITY: {
                res.append("(-Infinity");
            }
        }
        res.append("..");
        switch (upperBoundType) {
            case OPEN: {
                res.append(this.upperBound).append(')');
                break;
            }
            case CLOSED: {
                res.append(this.upperBound).append(']');
                break;
            }
            case INFINITY: {
                res.append("+Infinity)");
            }
        }
        return res.toString();
    }
}

