/*
 * Decompiled with CFR 0.152.
 */
package kala.range.primitive;

import kala.range.BoundType;
import kala.range.RangeType;
import kala.range.primitive.FloatingRange;
import org.jetbrains.annotations.NotNull;

public final class FloatRange
extends FloatingRange<Float> {
    private static final long serialVersionUID = 5067589681883732607L;
    private static final int HASH_MAGIC = -1554783535;
    private static final FloatRange ALL = new FloatRange(RangeType.ALL, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY);
    private static final FloatRange EMPTY = new FloatRange(RangeType.EMPTY, Float.NaN, Float.NaN);
    @NotNull
    private final RangeType type;
    private final float lowerBound;
    private final float upperBound;

    private FloatRange(@NotNull RangeType type, float lowerBound, float upperBound) {
        this.type = type;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @NotNull
    public static FloatRange all() {
        return ALL;
    }

    @NotNull
    public static FloatRange empty() {
        return EMPTY;
    }

    @NotNull
    public static FloatRange is(float value) {
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException("value should not be NaN");
        }
        if (Float.isInfinite(value)) {
            throw new IllegalArgumentException();
        }
        return new FloatRange(RangeType.CLOSED, value, value);
    }

    @NotNull
    public static FloatRange open(float lowerBound, float upperBound) {
        if (Float.isNaN(lowerBound) || Float.isNaN(upperBound)) {
            throw new IllegalArgumentException("bound should not be NaN");
        }
        if (lowerBound >= upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than upperBound");
        }
        if (lowerBound == Float.NEGATIVE_INFINITY) {
            if (upperBound == Float.POSITIVE_INFINITY) {
                return ALL;
            }
            if (upperBound == Float.MIN_VALUE) {
                return EMPTY;
            }
            return new FloatRange(RangeType.LESS_THAN, Float.NEGATIVE_INFINITY, upperBound);
        }
        if (upperBound == Float.POSITIVE_INFINITY) {
            if (lowerBound == Float.MAX_VALUE) {
                return EMPTY;
            }
            return new FloatRange(RangeType.GREATER_THAN, lowerBound, Float.POSITIVE_INFINITY);
        }
        return new FloatRange(RangeType.OPEN, lowerBound, upperBound);
    }

    @NotNull
    public static FloatRange closed(float lowerBound, float upperBound) {
        if (Float.isNaN(lowerBound) || Float.isNaN(upperBound)) {
            throw new IllegalArgumentException("bound should not be NaN");
        }
        if (Float.isInfinite(lowerBound) || Float.isInfinite(upperBound)) {
            throw new IllegalArgumentException();
        }
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        return new FloatRange(RangeType.CLOSED, lowerBound, upperBound);
    }

    @NotNull
    public static FloatRange openClosed(float lowerBound, float upperBound) {
        if (Float.isNaN(lowerBound) || Float.isNaN(upperBound)) {
            throw new IllegalArgumentException("bound should not be NaN");
        }
        if (Float.isInfinite(upperBound)) {
            throw new IllegalArgumentException();
        }
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        if (lowerBound == Float.NEGATIVE_INFINITY) {
            return new FloatRange(RangeType.AT_MOST, Float.NEGATIVE_INFINITY, upperBound);
        }
        return new FloatRange(RangeType.OPEN_CLOSED, lowerBound, upperBound);
    }

    @NotNull
    public static FloatRange closedOpen(float lowerBound, float upperBound) {
        if (Float.isNaN(lowerBound) || Float.isNaN(upperBound)) {
            throw new IllegalArgumentException("bound should not be NaN");
        }
        if (Float.isInfinite(lowerBound)) {
            throw new IllegalArgumentException();
        }
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        if (upperBound == Float.POSITIVE_INFINITY) {
            return new FloatRange(RangeType.AT_LEAST, lowerBound, Float.POSITIVE_INFINITY);
        }
        return new FloatRange(RangeType.CLOSED_OPEN, lowerBound, upperBound);
    }

    @NotNull
    public static FloatRange greaterThan(float lowerBound) {
        if (Float.isNaN(lowerBound)) {
            throw new IllegalArgumentException("lowerBound should not be NaN");
        }
        if (lowerBound == Float.NEGATIVE_INFINITY) {
            return ALL;
        }
        if (lowerBound == Float.POSITIVE_INFINITY) {
            return EMPTY;
        }
        return new FloatRange(RangeType.GREATER_THAN, lowerBound, Float.POSITIVE_INFINITY);
    }

    @NotNull
    public static FloatRange atLeast(float lowerBound) {
        if (Float.isNaN(lowerBound)) {
            throw new IllegalArgumentException("lowerBound should not be NaN");
        }
        if (Float.isInfinite(lowerBound)) {
            throw new IllegalArgumentException();
        }
        return new FloatRange(RangeType.AT_LEAST, lowerBound, Float.POSITIVE_INFINITY);
    }

    @NotNull
    public static FloatRange lessThan(float upperBound) {
        if (Float.isNaN(upperBound)) {
            throw new IllegalArgumentException("upperBound should not be NaN");
        }
        if (upperBound == Float.POSITIVE_INFINITY) {
            return ALL;
        }
        if (upperBound == Float.NEGATIVE_INFINITY) {
            return EMPTY;
        }
        return new FloatRange(RangeType.LESS_THAN, Float.NEGATIVE_INFINITY, upperBound);
    }

    @NotNull
    public static FloatRange atMost(float upperBound) {
        if (Float.isNaN(upperBound)) {
            throw new IllegalArgumentException("upperBound should not be NaN");
        }
        if (Float.isInfinite(upperBound)) {
            throw new IllegalArgumentException();
        }
        return new FloatRange(RangeType.AT_MOST, Float.NEGATIVE_INFINITY, upperBound);
    }

    @Override
    @NotNull
    public RangeType getType() {
        return this.type;
    }

    public float getLowerBound() {
        if (!this.hasLowerBound()) {
            throw new UnsupportedOperationException();
        }
        return this.lowerBound;
    }

    public float getUpperBound() {
        if (!this.hasUpperBound()) {
            throw new UnsupportedOperationException();
        }
        return this.upperBound;
    }

    boolean contains(float value) {
        if (!Float.isFinite(value) || this.type == RangeType.EMPTY) {
            return false;
        }
        BoundType lowerBoundType = this.type.getLowerBoundType();
        BoundType upperBoundType = this.type.getUpperBoundType();
        switch (lowerBoundType) {
            case OPEN: {
                if (!(this.lowerBound >= value)) break;
                return false;
            }
            case CLOSED: {
                if (!(this.lowerBound > value)) break;
                return false;
            }
        }
        switch (upperBoundType) {
            case OPEN: {
                if (!(this.upperBound <= value)) break;
                return false;
            }
            case CLOSED: {
                if (!(this.upperBound < value)) break;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + Float.hashCode(this.lowerBound);
        result = result * 31 + Float.hashCode(this.upperBound);
        return result + -1554783535;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FloatRange)) {
            return false;
        }
        FloatRange other = (FloatRange)o;
        return this.type == other.type && Float.floatToIntBits(this.lowerBound) == Float.floatToIntBits(other.lowerBound) && Float.floatToIntBits(this.upperBound) == Float.floatToIntBits(other.upperBound);
    }

    public String toString() {
        if (this == EMPTY) {
            return "FloatRange.Empty";
        }
        if (this == ALL) {
            return "FloatRange.All";
        }
        BoundType lowerBoundType = this.type.getLowerBoundType();
        BoundType upperBoundType = this.type.getUpperBoundType();
        StringBuilder res = new StringBuilder(32);
        res.append("FloatRange");
        switch (lowerBoundType) {
            case OPEN: {
                res.append('(').append(this.lowerBound);
                break;
            }
            case CLOSED: {
                res.append('[').append(this.lowerBound);
                break;
            }
            case INFINITY: {
                res.append("(-Infinity");
            }
        }
        res.append("..");
        switch (upperBoundType) {
            case OPEN: {
                res.append(this.upperBound).append(')');
                break;
            }
            case CLOSED: {
                res.append(this.upperBound).append(']');
                break;
            }
            case INFINITY: {
                res.append("+Infinity)");
            }
        }
        return res.toString();
    }
}

