/*
 * Decompiled with CFR 0.152.
 */
package kala.range.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.IntConsumer;
import kala.collection.base.primitive.AbstractIntIterator;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.range.BoundType;
import kala.range.RangeType;
import kala.range.primitive.IntegralRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class IntRange
extends IntegralRange<Integer>
implements IntTraversable,
Serializable {
    private static final long serialVersionUID = -645836619229796856L;
    private static final int HASH_MAGIC = 1721365173;
    public static final long DEFAULT_STEP = 1L;
    public static final long MAX_STEP = 0xFFFFFFFFL;
    public static final long MAX_REVERSE_STEP = -4294967295L;
    private static final IntRange ALL = new IntRange(RangeType.CLOSED, Integer.MIN_VALUE, Integer.MAX_VALUE);
    private static final IntRange EMPTY = new IntRange(RangeType.EMPTY, 0, 0);
    @NotNull
    private final RangeType type;
    private final int lowerBound;
    private final int upperBound;

    private IntRange(@NotNull RangeType type, int lowerBound, int upperBound) {
        this.type = type;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @NotNull
    public static IntRange all() {
        return ALL;
    }

    @NotNull
    public static IntRange empty() {
        return EMPTY;
    }

    @NotNull
    public static IntRange is(int value) {
        return new IntRange(RangeType.CLOSED, value, value);
    }

    @NotNull
    public static IntRange open(int lowerBound, int upperBound) {
        if (lowerBound >= upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than upperBound");
        }
        return new IntRange(RangeType.OPEN, lowerBound, upperBound);
    }

    @NotNull
    public static IntRange closed(int lowerBound, int upperBound) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        return new IntRange(RangeType.CLOSED, lowerBound, upperBound);
    }

    @NotNull
    public static IntRange openClosed(int lowerBound, int upperBound) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        return new IntRange(RangeType.OPEN_CLOSED, lowerBound, upperBound);
    }

    @NotNull
    public static IntRange closedOpen(int lowerBound, int upperBound) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        return new IntRange(RangeType.CLOSED_OPEN, lowerBound, upperBound);
    }

    @NotNull
    public static IntRange greaterThan(int lowerBound) {
        return new IntRange(RangeType.OPEN_CLOSED, lowerBound, Integer.MAX_VALUE);
    }

    @NotNull
    public static IntRange atLeast(int lowerBound) {
        return new IntRange(RangeType.CLOSED, lowerBound, Integer.MAX_VALUE);
    }

    @NotNull
    public static IntRange lessThan(int upperBound) {
        return new IntRange(RangeType.CLOSED_OPEN, Integer.MIN_VALUE, upperBound);
    }

    @NotNull
    public static IntRange atMost(int upperBound) {
        return new IntRange(RangeType.CLOSED, Integer.MIN_VALUE, upperBound);
    }

    @Override
    @NotNull
    public RangeType getType() {
        return this.type;
    }

    public int getLowerBound() {
        if (!this.hasLowerBound()) {
            throw new UnsupportedOperationException();
        }
        return this.lowerBound;
    }

    public int getUpperBound() {
        if (!this.hasUpperBound()) {
            throw new UnsupportedOperationException();
        }
        return this.upperBound;
    }

    private int strictLowerBound() {
        return this.type.getLowerBoundType() == BoundType.OPEN ? this.lowerBound + 1 : this.lowerBound;
    }

    private int strictUpperBound() {
        return this.type.getUpperBoundType() == BoundType.OPEN ? this.upperBound - 1 : this.upperBound;
    }

    public int fit(int value) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("Range is empty");
        }
        int strictLowerBound = this.strictLowerBound();
        int strictUpperBound = this.strictUpperBound();
        if (strictLowerBound >= value) {
            return strictLowerBound;
        }
        if (strictUpperBound <= value) {
            return strictUpperBound;
        }
        return value;
    }

    @Override
    public boolean isEmpty() {
        return this.type == RangeType.EMPTY || this.lowerBound == this.upperBound && this.type.getLowerBoundType() != this.type.getUpperBoundType();
    }

    @Override
    public boolean contains(int value) {
        if (this == ALL) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        return value >= this.strictLowerBound() && value <= this.strictUpperBound();
    }

    @Override
    @NotNull
    public IntIterator iterator() {
        int strictUpperBound;
        if (this.isEmpty()) {
            return IntIterator.empty();
        }
        int strictLowerBound = this.strictLowerBound();
        if (strictLowerBound == (strictUpperBound = this.strictUpperBound())) {
            return IntIterator.of(strictLowerBound);
        }
        return new PositiveItr(strictUpperBound, 1L, strictLowerBound);
    }

    @Override
    public void forEach(@NotNull IntConsumer action) {
        this.forEachByStep(1L, action);
    }

    void forEachByStep(long step, @NotNull IntConsumer action) {
        Objects.requireNonNull(action);
        if (step == 0L) {
            throw new IllegalArgumentException("step mush not be zero");
        }
        if (step > 0xFFFFFFFFL || step < -4294967295L) {
            throw new IllegalArgumentException("step too large");
        }
        if (this.isEmpty()) {
            return;
        }
        int strictLowerBound = this.strictLowerBound();
        int strictUpperBound = this.strictUpperBound();
        if (step > 0L) {
            int value = strictLowerBound;
            while (value <= strictUpperBound) {
                action.accept(value);
                if (Integer.MAX_VALUE - step >= (long)value) {
                    value = (int)((long)value + step);
                    continue;
                }
                break;
            }
        } else {
            int value = strictUpperBound;
            while (value >= strictLowerBound) {
                action.accept(value);
                if (Integer.MIN_VALUE - step <= (long)value) {
                    value = (int)((long)value + step);
                    continue;
                }
                break;
            }
        }
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + Integer.hashCode(this.lowerBound);
        result = result * 31 + Integer.hashCode(this.upperBound);
        return result + 1721365173;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntRange)) {
            return false;
        }
        IntRange IntRange2 = (IntRange)o;
        return this.lowerBound == IntRange2.lowerBound && this.upperBound == IntRange2.upperBound && this.type == IntRange2.type;
    }

    private static String prettyToString(int value) {
        if (value == Integer.MAX_VALUE) {
            return "Integer.MAX_VALUE";
        }
        if (value == Integer.MIN_VALUE) {
            return "Integer.MIN_VALUE";
        }
        return String.valueOf(value);
    }

    public String toString() {
        if (this == EMPTY) {
            return "IntRange.Empty";
        }
        if (this == ALL) {
            return "IntRange.All";
        }
        BoundType lowerBoundType = this.type.getLowerBoundType();
        BoundType upperBoundType = this.type.getUpperBoundType();
        StringBuilder res = new StringBuilder(32);
        res.append("IntRange");
        switch (lowerBoundType) {
            case OPEN: {
                res.append('(');
                break;
            }
            case CLOSED: {
                res.append('[');
                break;
            }
            case INFINITY: {
                throw new AssertionError();
            }
        }
        res.append(IntRange.prettyToString(this.lowerBound)).append("..").append(IntRange.prettyToString(this.upperBound));
        switch (upperBoundType) {
            case OPEN: {
                res.append(')');
                break;
            }
            case CLOSED: {
                res.append(']');
                break;
            }
            case INFINITY: {
                throw new AssertionError();
            }
        }
        return res.toString();
    }

    private static final class PositiveItr
    extends AbstractIntIterator {
        private int upperBound;
        private final @Range(from=1L, to=0xFFFFFFFFL) long step;
        private int value;

        PositiveItr(int upperBound, long step, int initialValue) {
            this.upperBound = upperBound;
            this.step = step;
            this.value = initialValue;
        }

        @Override
        public boolean hasNext() {
            return this.value <= this.upperBound;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int res = this.value;
            if (Integer.MAX_VALUE - this.step < (long)this.value) {
                this.upperBound = Integer.MIN_VALUE;
                this.value = Integer.MAX_VALUE;
            } else {
                this.value = (int)((long)this.value + this.step);
            }
            return res;
        }
    }

    private static final class ReverseItr
    extends AbstractIntIterator {
        private int lowerBound;
        private final @Range(from=-4294967295L, to=-1L) long step;
        private int value;

        private ReverseItr(int lowerBound, @Range(from=-2147483648L, to=-1L) long step, int initialValue) {
            this.lowerBound = lowerBound;
            this.step = step;
            this.value = initialValue;
        }

        @Override
        public boolean hasNext() {
            return this.value >= this.lowerBound;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int res = this.value;
            if (Integer.MIN_VALUE - this.step > (long)this.value) {
                this.lowerBound = Integer.MAX_VALUE;
                this.value = Integer.MIN_VALUE;
            } else {
                this.value = (int)((long)this.value + this.step);
            }
            return res;
        }
    }
}

