/*
 * Decompiled with CFR 0.152.
 */
package kala.range.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.LongConsumer;
import kala.collection.base.primitive.AbstractLongIterator;
import kala.collection.base.primitive.LongIterator;
import kala.collection.base.primitive.LongTraversable;
import kala.range.BoundType;
import kala.range.RangeType;
import kala.range.primitive.IntegralRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class LongRange
extends IntegralRange<Long>
implements LongTraversable,
Serializable {
    private static final long serialVersionUID = -4689744852215083976L;
    private static final int HASH_MAGIC = -544035865;
    public static final long DEFAULT_STEP = 1L;
    public static final long MAX_STEP = Long.MAX_VALUE;
    public static final long MAX_REVERSE_STEP = Long.MIN_VALUE;
    private static final LongRange ALL = new LongRange(RangeType.CLOSED, Long.MIN_VALUE, Long.MAX_VALUE);
    private static final LongRange EMPTY = new LongRange(RangeType.EMPTY, 0L, 0L);
    @NotNull
    private final RangeType type;
    private final long lowerBound;
    private final long upperBound;

    private LongRange(@NotNull RangeType type, long lowerBound, long upperBound) {
        this.type = type;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @NotNull
    public static LongRange all() {
        return ALL;
    }

    @NotNull
    public static LongRange empty() {
        return EMPTY;
    }

    @NotNull
    public static LongRange is(long value) {
        return new LongRange(RangeType.CLOSED, value, value);
    }

    @NotNull
    public static LongRange open(long lowerBound, long upperBound) {
        if (lowerBound >= upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than upperBound");
        }
        return new LongRange(RangeType.OPEN, lowerBound, upperBound);
    }

    @NotNull
    public static LongRange closed(long lowerBound, long upperBound) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        return new LongRange(RangeType.CLOSED, lowerBound, upperBound);
    }

    @NotNull
    public static LongRange openClosed(long lowerBound, long upperBound) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        return new LongRange(RangeType.OPEN_CLOSED, lowerBound, upperBound);
    }

    @NotNull
    public static LongRange closedOpen(long lowerBound, long upperBound) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        return new LongRange(RangeType.CLOSED_OPEN, lowerBound, upperBound);
    }

    @NotNull
    public static LongRange greaterThan(long lowerBound) {
        return new LongRange(RangeType.OPEN_CLOSED, lowerBound, Long.MAX_VALUE);
    }

    @NotNull
    public static LongRange atLeast(long lowerBound) {
        return new LongRange(RangeType.CLOSED, lowerBound, Long.MAX_VALUE);
    }

    @NotNull
    public static LongRange lessThan(long upperBound) {
        return new LongRange(RangeType.CLOSED_OPEN, Long.MIN_VALUE, upperBound);
    }

    @NotNull
    public static LongRange atMost(long upperBound) {
        return new LongRange(RangeType.CLOSED, Long.MIN_VALUE, upperBound);
    }

    @Override
    @NotNull
    public RangeType getType() {
        return this.type;
    }

    public long getLowerBound() {
        if (!this.hasLowerBound()) {
            throw new UnsupportedOperationException();
        }
        return this.lowerBound;
    }

    public long getUpperBound() {
        if (!this.hasUpperBound()) {
            throw new UnsupportedOperationException();
        }
        return this.upperBound;
    }

    private long strictLowerBound() {
        return this.type.getLowerBoundType() == BoundType.OPEN ? this.lowerBound + 1L : this.lowerBound;
    }

    private long strictUpperBound() {
        return this.type.getUpperBoundType() == BoundType.OPEN ? this.upperBound - 1L : this.upperBound;
    }

    public long fit(long value) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("Range is empty");
        }
        long strictLowerBound = this.strictLowerBound();
        long strictUpperBound = this.strictUpperBound();
        if (strictLowerBound >= value) {
            return strictLowerBound;
        }
        if (strictUpperBound <= value) {
            return strictUpperBound;
        }
        return value;
    }

    @Override
    public boolean isEmpty() {
        return this.type == RangeType.EMPTY || this.lowerBound == this.upperBound && this.type.getLowerBoundType() != this.type.getUpperBoundType();
    }

    @Override
    public boolean contains(long value) {
        if (this == ALL) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        return value >= this.strictLowerBound() && value <= this.strictUpperBound();
    }

    @Override
    @NotNull
    public LongIterator iterator() {
        long strictUpperBound;
        if (this.isEmpty()) {
            return LongIterator.empty();
        }
        long strictLowerBound = this.strictLowerBound();
        if (strictLowerBound == (strictUpperBound = this.strictUpperBound())) {
            return LongIterator.of(strictLowerBound);
        }
        return new PositiveItr(strictUpperBound, 1L, strictLowerBound);
    }

    @Override
    public void forEach(@NotNull LongConsumer action) {
        this.forEachByStep(1L, action);
    }

    void forEachByStep(long step, @NotNull LongConsumer action) {
        Objects.requireNonNull(action);
        if (step == 0L) {
            throw new IllegalArgumentException("step mush not be zero");
        }
        if (step > Long.MAX_VALUE || step < Long.MIN_VALUE) {
            throw new IllegalArgumentException("step too large");
        }
        if (this.isEmpty()) {
            return;
        }
        long strictLowerBound = this.strictLowerBound();
        long strictUpperBound = this.strictUpperBound();
        if (step > 0L) {
            for (long value = strictLowerBound; value <= strictUpperBound; value += step) {
                action.accept(value);
                if (Long.MAX_VALUE - step >= value) {
                    continue;
                }
                break;
            }
        } else {
            for (long value = strictUpperBound; value >= strictLowerBound; value += step) {
                action.accept(value);
                if (Long.MIN_VALUE - step <= value) {
                    continue;
                }
                break;
            }
        }
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + Long.hashCode(this.lowerBound);
        result = result * 31 + Long.hashCode(this.upperBound);
        return result + -544035865;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongRange)) {
            return false;
        }
        LongRange LongRange2 = (LongRange)o;
        return this.lowerBound == LongRange2.lowerBound && this.upperBound == LongRange2.upperBound && this.type == LongRange2.type;
    }

    private static String prettyToString(long value) {
        if (value == Long.MAX_VALUE) {
            return "Long.MAX_VALUE";
        }
        if (value == Long.MIN_VALUE) {
            return "Long.MIN_VALUE";
        }
        return String.valueOf(value);
    }

    public String toString() {
        if (this == EMPTY) {
            return "LongRange.Empty";
        }
        if (this == ALL) {
            return "LongRange.All";
        }
        BoundType lowerBoundType = this.type.getLowerBoundType();
        BoundType upperBoundType = this.type.getUpperBoundType();
        StringBuilder res = new StringBuilder(32);
        res.append("LongRange");
        switch (lowerBoundType) {
            case OPEN: {
                res.append('(');
                break;
            }
            case CLOSED: {
                res.append('[');
                break;
            }
            case INFINITY: {
                throw new AssertionError();
            }
        }
        res.append(LongRange.prettyToString(this.lowerBound)).append("..").append(LongRange.prettyToString(this.upperBound));
        switch (upperBoundType) {
            case OPEN: {
                res.append(')');
                break;
            }
            case CLOSED: {
                res.append(']');
                break;
            }
            case INFINITY: {
                throw new AssertionError();
            }
        }
        return res.toString();
    }

    private static final class PositiveItr
    extends AbstractLongIterator {
        private long upperBound;
        private final @Range(from=1L, to=0x7FFFFFFFFFFFFFFFL) long step;
        private long value;

        PositiveItr(long upperBound, long step, long initialValue) {
            this.upperBound = upperBound;
            this.step = step;
            this.value = initialValue;
        }

        @Override
        public boolean hasNext() {
            return this.value <= this.upperBound;
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long res = this.value;
            if (Long.MAX_VALUE - this.step < this.value) {
                this.upperBound = Long.MIN_VALUE;
                this.value = Long.MAX_VALUE;
            } else {
                this.value += this.step;
            }
            return res;
        }
    }

    private static final class ReverseItr
    extends AbstractLongIterator {
        private long lowerBound;
        private final @Range(from=-9223372036854775808L, to=-1L) long step;
        private long value;

        private ReverseItr(long lowerBound, @Range(from=-9223372036854775808L, to=-1L) long step, long initialValue) {
            this.lowerBound = lowerBound;
            this.step = step;
            this.value = initialValue;
        }

        @Override
        public boolean hasNext() {
            return this.value >= this.lowerBound;
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long res = this.value;
            if (Long.MIN_VALUE - this.step > this.value) {
                this.lowerBound = Long.MAX_VALUE;
                this.value = Long.MIN_VALUE;
            } else {
                this.value += this.step;
            }
            return res;
        }
    }
}

