/*
 * Decompiled with CFR 0.152.
 */
package kala.range.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.base.primitive.AbstractShortIterator;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.base.primitive.ShortTraversable;
import kala.function.ShortConsumer;
import kala.range.BoundType;
import kala.range.RangeType;
import kala.range.primitive.IntegralRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class ShortRange
extends IntegralRange<Short>
implements ShortTraversable,
Serializable {
    private static final long serialVersionUID = -1955865399380314980L;
    private static final int HASH_MAGIC = -9167923;
    public static final int DEFAULT_STEP = 1;
    public static final int MAX_STEP = 65535;
    public static final int MAX_REVERSE_STEP = -65535;
    private static final ShortRange ALL = new ShortRange(RangeType.CLOSED, Short.MIN_VALUE, Short.MAX_VALUE);
    private static final ShortRange EMPTY = new ShortRange(RangeType.EMPTY, 0, 0);
    @NotNull
    private final RangeType type;
    private final short lowerBound;
    private final short upperBound;

    private ShortRange(@NotNull RangeType type, short lowerBound, short upperBound) {
        this.type = type;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @NotNull
    public static ShortRange all() {
        return ALL;
    }

    @NotNull
    public static ShortRange empty() {
        return EMPTY;
    }

    @NotNull
    public static ShortRange is(short value) {
        return new ShortRange(RangeType.CLOSED, value, value);
    }

    @NotNull
    public static ShortRange open(short lowerBound, short upperBound) {
        if (lowerBound >= upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than upperBound");
        }
        return new ShortRange(RangeType.OPEN, lowerBound, upperBound);
    }

    @NotNull
    public static ShortRange closed(short lowerBound, short upperBound) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        return new ShortRange(RangeType.CLOSED, lowerBound, upperBound);
    }

    @NotNull
    public static ShortRange openClosed(short lowerBound, short upperBound) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        return new ShortRange(RangeType.OPEN_CLOSED, lowerBound, upperBound);
    }

    @NotNull
    public static ShortRange closedOpen(short lowerBound, short upperBound) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        return new ShortRange(RangeType.CLOSED_OPEN, lowerBound, upperBound);
    }

    @NotNull
    public static ShortRange greaterThan(short lowerBound) {
        return new ShortRange(RangeType.OPEN_CLOSED, lowerBound, Short.MAX_VALUE);
    }

    @NotNull
    public static ShortRange atLeast(short lowerBound) {
        return new ShortRange(RangeType.CLOSED, lowerBound, Short.MAX_VALUE);
    }

    @NotNull
    public static ShortRange lessThan(short upperBound) {
        return new ShortRange(RangeType.CLOSED_OPEN, Short.MIN_VALUE, upperBound);
    }

    @NotNull
    public static ShortRange atMost(short upperBound) {
        return new ShortRange(RangeType.CLOSED, Short.MIN_VALUE, upperBound);
    }

    @Override
    @NotNull
    public RangeType getType() {
        return this.type;
    }

    public short getLowerBound() {
        if (!this.hasLowerBound()) {
            throw new UnsupportedOperationException();
        }
        return this.lowerBound;
    }

    public short getUpperBound() {
        if (!this.hasUpperBound()) {
            throw new UnsupportedOperationException();
        }
        return this.upperBound;
    }

    private short strictLowerBound() {
        return this.type.getLowerBoundType() == BoundType.OPEN ? (short)(this.lowerBound + 1) : this.lowerBound;
    }

    private short strictUpperBound() {
        return this.type.getUpperBoundType() == BoundType.OPEN ? (short)(this.upperBound - 1) : this.upperBound;
    }

    public short fit(short value) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("Range is empty");
        }
        short strictLowerBound = this.strictLowerBound();
        short strictUpperBound = this.strictUpperBound();
        if (strictLowerBound >= value) {
            return strictLowerBound;
        }
        if (strictUpperBound <= value) {
            return strictUpperBound;
        }
        return value;
    }

    @Override
    public boolean isEmpty() {
        return this.type == RangeType.EMPTY || this.lowerBound == this.upperBound && this.type.getLowerBoundType() != this.type.getUpperBoundType();
    }

    @Override
    public boolean contains(short value) {
        if (this == ALL) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        return value >= this.strictLowerBound() && value <= this.strictUpperBound();
    }

    @Override
    @NotNull
    public ShortIterator iterator() {
        short strictUpperBound;
        if (this.isEmpty()) {
            return ShortIterator.empty();
        }
        short strictLowerBound = this.strictLowerBound();
        if (strictLowerBound == (strictUpperBound = this.strictUpperBound())) {
            return ShortIterator.of(strictLowerBound);
        }
        return new PositiveItr(strictUpperBound, 1, strictLowerBound);
    }

    @Override
    public void forEach(@NotNull ShortConsumer action) {
        this.forEachByStep(1, action);
    }

    void forEachByStep(int step, @NotNull ShortConsumer action) {
        Objects.requireNonNull(action);
        if (step == 0) {
            throw new IllegalArgumentException("step mush not be zero");
        }
        if (step > 65535 || step < -65535) {
            throw new IllegalArgumentException("step too large");
        }
        if (this.isEmpty()) {
            return;
        }
        short strictLowerBound = this.strictLowerBound();
        short strictUpperBound = this.strictUpperBound();
        if (step > 0) {
            short value = strictLowerBound;
            while (value <= strictUpperBound) {
                action.accept(value);
                if (Short.MAX_VALUE - step >= value) {
                    value = (short)(value + step);
                    continue;
                }
                break;
            }
        } else {
            short value = strictUpperBound;
            while (value >= strictLowerBound) {
                action.accept(value);
                if (Short.MIN_VALUE - step <= value) {
                    value = (short)(value + step);
                    continue;
                }
                break;
            }
        }
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + Short.hashCode(this.lowerBound);
        result = result * 31 + Short.hashCode(this.upperBound);
        return result + -9167923;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShortRange)) {
            return false;
        }
        ShortRange ShortRange2 = (ShortRange)o;
        return this.lowerBound == ShortRange2.lowerBound && this.upperBound == ShortRange2.upperBound && this.type == ShortRange2.type;
    }

    private static String prettyToString(short value) {
        if (value == Short.MAX_VALUE) {
            return "Short.MAX_VALUE";
        }
        if (value == Short.MIN_VALUE) {
            return "Short.MIN_VALUE";
        }
        return String.valueOf(value);
    }

    public String toString() {
        if (this == EMPTY) {
            return "ShortRange.Empty";
        }
        if (this == ALL) {
            return "ShortRange.All";
        }
        BoundType lowerBoundType = this.type.getLowerBoundType();
        BoundType upperBoundType = this.type.getUpperBoundType();
        StringBuilder res = new StringBuilder(32);
        res.append("ShortRange");
        switch (lowerBoundType) {
            case OPEN: {
                res.append('(');
                break;
            }
            case CLOSED: {
                res.append('[');
                break;
            }
            case INFINITY: {
                throw new AssertionError();
            }
        }
        res.append(ShortRange.prettyToString(this.lowerBound)).append("..").append(ShortRange.prettyToString(this.upperBound));
        switch (upperBoundType) {
            case OPEN: {
                res.append(')');
                break;
            }
            case CLOSED: {
                res.append(']');
                break;
            }
            case INFINITY: {
                throw new AssertionError();
            }
        }
        return res.toString();
    }

    private static final class PositiveItr
    extends AbstractShortIterator {
        private short upperBound;
        private final @Range(from=1L, to=65535L) int step;
        private short value;

        PositiveItr(short upperBound, int step, short initialValue) {
            this.upperBound = upperBound;
            this.step = step;
            this.value = initialValue;
        }

        @Override
        public boolean hasNext() {
            return this.value <= this.upperBound;
        }

        @Override
        public short nextShort() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            short res = this.value;
            if (Short.MAX_VALUE - this.step < this.value) {
                this.upperBound = Short.MIN_VALUE;
                this.value = Short.MAX_VALUE;
            } else {
                this.value = (short)(this.value + this.step);
            }
            return res;
        }
    }

    private static final class ReverseItr
    extends AbstractShortIterator {
        private short lowerBound;
        private final @Range(from=-65535L, to=-1L) int step;
        private short value;

        private ReverseItr(short lowerBound, @Range(from=-32768L, to=-1L) int step, short initialValue) {
            this.lowerBound = lowerBound;
            this.step = step;
            this.value = initialValue;
        }

        @Override
        public boolean hasNext() {
            return this.value >= this.lowerBound;
        }

        @Override
        public short nextShort() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            short res = this.value;
            if (Short.MIN_VALUE - this.step > this.value) {
                this.lowerBound = Short.MAX_VALUE;
                this.value = Short.MIN_VALUE;
            } else {
                this.value = (short)(this.value + this.step);
            }
            return res;
        }
    }
}

