/*
 * Decompiled with CFR 0.152.
 */
package kala.text;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kala.text.StringFormat;
import kala.text.StringFormatException;
import kala.text.StringFormatProcessor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public final class StringFormatFactory {
    private final Map<String, StringFormatProcessor> formatProcessors;
    private final Locale locale;
    private static final StringFormatFactory DEFAULT = StringFormatFactory.builder().registerProcessor("printf", StringFormatProcessor.PRINTF).registerProcessor("array", StringFormatProcessor.ARRAY).registerProcessor("lower", StringFormatProcessor.LOWER).registerProcessor("upper", StringFormatProcessor.UPPER).registerProcessor("substring", StringFormatProcessor.SUBSTRING).registerProcessor("trim", StringFormatProcessor.TRIM).build();

    private StringFormatFactory(Map<String, StringFormatProcessor> formatProcessors, Locale locale) {
        this.formatProcessors = formatProcessors;
        this.locale = locale;
    }

    public static StringFormatFactory getDefault() {
        return DEFAULT;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@NotNull StringFormatFactory base) {
        Builder builder = new Builder();
        builder.formatTypes.putAll(base.formatProcessors);
        builder.locale = base.locale;
        return builder;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public StringFormat parse(String format) {
        return new StringFormat(this, format);
    }

    public String format(String format, Object ... arguments) {
        return this.format(new StringBuilder(), format, arguments).toString();
    }

    public StringBuilder format(StringBuilder out, String format, Object ... arguments) {
        int formatLength = format.length();
        int argsCount = arguments.length;
        int argIndex = 0;
        int lastOffset = 0;
        block0: while (lastOffset < formatLength) {
            int idx;
            int endOffset;
            int offset = format.indexOf(123, lastOffset);
            if (offset < 0) {
                out.append(format, lastOffset, formatLength);
                return out;
            }
            if (offset == formatLength - 1) {
                throw StringFormatFactory.invalidFormatString(format);
            }
            out.append(format, lastOffset, offset);
            int nextOffset = offset + 1;
            char nextChar = format.charAt(nextOffset);
            if (nextChar == '}') {
                this.processArg(out, arguments, argIndex++);
                lastOffset = nextOffset + 1;
                continue;
            }
            if (nextChar == '\'') {
                for (endOffset = nextOffset + 1; endOffset < formatLength; ++endOffset) {
                    if ((endOffset = format.indexOf(125, endOffset)) < 0) {
                        throw StringFormatFactory.invalidFormatString(format);
                    }
                    if (format.charAt(endOffset - 1) != '\'' || endOffset <= nextOffset + 1) continue;
                    out.append(format, nextOffset + 1, endOffset - 1);
                    lastOffset = endOffset + 1;
                    continue block0;
                }
                throw StringFormatFactory.invalidFormatString(format);
            }
            endOffset = format.indexOf(125, nextOffset + 1);
            if (endOffset < 0) {
                throw StringFormatFactory.invalidFormatString(format);
            }
            int firstColonOffset = StringFormatFactory.findColon(format, nextOffset, endOffset);
            if (firstColonOffset < 0) {
                idx = StringFormatFactory.parseInt(format, nextOffset, endOffset);
                if (idx == -1) {
                    throw StringFormatFactory.invalidFormatString(format);
                }
                this.processArg(out, arguments, idx);
            } else {
                int n = idx = firstColonOffset == nextOffset ? argIndex++ : StringFormatFactory.parseInt(format, nextOffset, firstColonOffset);
                if (idx == -1) {
                    throw StringFormatFactory.invalidFormatString(format);
                }
                this.processArgImpl(out, format, firstColonOffset + 1, endOffset, arguments, idx);
            }
            lastOffset = endOffset + 1;
        }
        return out;
    }

    private void processArgImpl(StringBuilder out, String format, int beginIndex, int endIndex, Object[] args, int argIndex) {
        String style;
        String processorName;
        int secondColonOffset = StringFormatFactory.findColon(format, beginIndex, endIndex);
        if (secondColonOffset < 0) {
            processorName = format.substring(beginIndex, endIndex);
            style = "";
        } else {
            processorName = format.substring(beginIndex, secondColonOffset);
            style = format.substring(secondColonOffset + 1, endIndex);
        }
        this.processArg(out, processorName, args, argIndex, style);
    }

    private static void checkArgIndex(int index, int length) {
        if (index < 0 || index >= length) {
            throw new StringFormatException("Invalid argument index: " + index);
        }
    }

    private static StringFormatException invalidFormatString(String format) {
        return new StringFormatException("Invalid format string: " + format);
    }

    private void processArg(StringBuilder out, Object[] args, int index) {
        StringFormatFactory.checkArgIndex(index, args.length);
        out.append(args[index]);
    }

    private void processArg(StringBuilder out, String processorName, Object[] args, int argIndex, String style) {
        StringFormatFactory.checkArgIndex(argIndex, args.length);
        Object arg = args[argIndex];
        if (processorName.isEmpty()) {
            if (!style.isEmpty()) {
                throw new StringFormatException("Unknown style: " + style);
            }
            out.append(arg);
        } else {
            StringFormatProcessor processor = this.formatProcessors.get(processorName);
            if (processor == null) {
                throw new StringFormatException("Unknown format processor: " + processorName);
            }
            if (arg == null && !processor.processNull()) {
                out.append((String)null);
            } else {
                try {
                    processor.accept(this, out, arg, style);
                }
                catch (StringFormatException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new StringFormatException(e);
                }
            }
        }
    }

    private static int findColon(String str, int beginIndex, int endIndex) {
        for (int i = beginIndex; i < endIndex; ++i) {
            if (str.charAt(i) != ':') continue;
            return i;
        }
        return -1;
    }

    private static int parseInt(String source, int beginIndex, int endIndex) {
        if (endIndex - beginIndex > 9) {
            return -1;
        }
        int res = 0;
        for (int i = beginIndex; i < endIndex; ++i) {
            int n = source.charAt(i) - 48;
            if (n < 0 || n > 9) {
                return -1;
            }
            res *= 10;
            res += n;
        }
        return res;
    }

    public static final class Builder {
        private final Map<String, StringFormatProcessor> formatTypes = new LinkedHashMap<String, StringFormatProcessor>();
        private Locale locale = Locale.ROOT;
        private boolean built = false;

        Builder() {
        }

        public <T> Builder registerProcessor(String type, @NotNull StringFormatProcessor processor) {
            Objects.requireNonNull(type);
            Objects.requireNonNull(processor);
            if (this.built) {
                throw new IllegalStateException();
            }
            this.formatTypes.put(type, processor);
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = Objects.requireNonNull(locale);
            return this;
        }

        public StringFormatFactory build() {
            this.built = true;
            return new StringFormatFactory(Collections.unmodifiableMap(this.formatTypes), this.locale);
        }
    }
}

