/*
 * Decompiled with CFR 0.152.
 */
package kala.text;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kala.text.StringAppender;
import kala.text.StringFormatException;
import kala.text.StringFormatFactory;
import org.jetbrains.annotations.ApiStatus;

@FunctionalInterface
@ApiStatus.Experimental
public interface StringFormatProcessor {
    public static final StringFormatProcessor DEFAULT = (factory, out, value, style) -> {
        if (!style.isEmpty()) {
            throw new StringFormatException("Unknown style: " + style);
        }
        out.append(value);
    };
    public static final StringFormatProcessor PRINTF = (factory, out, value, style) -> out.append(String.format(factory.getLocale(), style, value));
    public static final StringFormatProcessor ARRAY = (factory, out, value, style) -> {
        if (!style.isEmpty()) {
            throw new StringFormatException("Unknown style: " + style);
        }
        new StringAppender(out).append(value);
    };
    public static final StringFormatProcessor DATE = (factory, out, value, style) -> {
        DateFormat format;
        if (!(value instanceof Date)) {
            throw new StringFormatException(value + " is not date");
        }
        switch (style) {
            case "": 
            case "medium": {
                format = DateFormat.getDateInstance(2, factory.getLocale());
                break;
            }
            case "short": {
                format = DateFormat.getDateInstance(3, factory.getLocale());
                break;
            }
            case "long": {
                format = DateFormat.getDateInstance(1, factory.getLocale());
                break;
            }
            case "full": {
                format = DateFormat.getDateInstance(0, factory.getLocale());
                break;
            }
            default: {
                format = new SimpleDateFormat(style, factory.getLocale());
            }
        }
        out.append(format.format(value));
    };
    public static final StringFormatProcessor UPPER = (factory, out, value, style) -> {
        Locale locale = style.isEmpty() ? factory.getLocale() : Locale.forLanguageTag(style);
        out.append(value.toString().toUpperCase(locale));
    };
    public static final StringFormatProcessor LOWER = (factory, out, value, style) -> {
        Locale locale = style.isEmpty() ? factory.getLocale() : Locale.forLanguageTag(style);
        out.append(value.toString().toLowerCase(locale));
    };
    public static final StringFormatProcessor SUBSTRING = (factory, out, value, style) -> {
        int endIndex;
        int beginIndex;
        String str = value.toString();
        if (style.isEmpty()) {
            out.append(str);
            return;
        }
        int comma = style.indexOf(44);
        if (comma < 0) {
            beginIndex = Integer.parseInt(style);
            endIndex = str.length();
        } else {
            beginIndex = comma == 0 ? 0 : Integer.parseInt(style.substring(0, comma));
            endIndex = comma == style.length() - 1 ? str.length() : Integer.parseInt(style.substring(comma + 1));
        }
        out.append(str, beginIndex, endIndex);
    };
    public static final StringFormatProcessor TRIM = (factory, out, value, style) -> out.append(value.toString().trim());

    default public boolean processNull() {
        return false;
    }

    public void accept(StringFormatFactory var1, StringBuilder var2, Object var3, String var4) throws StringFormatException;
}

