/*
 * Decompiled with CFR 0.152.
 */
package kala.text;

import kala.text.StringSlice;
import org.jetbrains.annotations.NotNull;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean startsWith(@NotNull String str, @NotNull String prefix) {
        return str.startsWith(prefix);
    }

    public static boolean startsWith(@NotNull String str, @NotNull String prefix, int toIndex) {
        return str.startsWith(prefix, toIndex);
    }

    public static boolean startsWith(@NotNull String str, @NotNull StringSlice prefix) {
        return StringUtils.startsWith(str, prefix, 0);
    }

    public static boolean startsWith(@NotNull String str, @NotNull StringSlice prefix, int toIndex) {
        if (toIndex < 0 || toIndex > str.length() - prefix.length()) {
            return false;
        }
        return str.regionMatches(toIndex, prefix.source(), prefix.sourceOffset(), prefix.length());
    }

    public static boolean startsWith(@NotNull String str, @NotNull CharSequence prefix) {
        return StringUtils.startsWith(str, prefix, 0);
    }

    public static boolean startsWith(@NotNull String str, @NotNull CharSequence prefix, int toIndex) {
        return prefix instanceof StringSlice ? StringUtils.startsWith(str, (StringSlice)prefix, toIndex) : StringUtils.startsWith(str, prefix.toString(), toIndex);
    }

    public static String removePrefix(@NotNull String str, @NotNull String prefix) {
        return str.startsWith(prefix) ? str.substring(prefix.length()) : str;
    }

    public static String removePrefix(@NotNull String str, @NotNull StringSlice prefix) {
        return StringUtils.startsWith(str, prefix) ? str.substring(prefix.length()) : str;
    }

    public static String removePrefix(@NotNull String str, @NotNull CharSequence prefix) {
        return StringUtils.startsWith(str, prefix) ? str.substring(prefix.length()) : str;
    }
}

