/*
 * Decompiled with CFR 0.152.
 */
package kala.text;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import java.util.function.IntConsumer;
import kala.Conditions;
import kala.collection.base.primitive.ByteArrays;
import kala.collection.base.primitive.CharArrays;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.control.primitive.ByteOption;
import kala.control.primitive.DoubleOption;
import kala.control.primitive.FloatOption;
import kala.control.primitive.IntOption;
import kala.control.primitive.LongOption;
import kala.control.primitive.ShortOption;
import kala.function.CharConsumer;
import kala.text.StringFormatFactory;
import kala.text.StringSlice;
import kala.text.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringView
implements Comparable<StringView>,
CharSequence,
CharTraversable,
Serializable {
    private static final long serialVersionUID = 0L;
    private static final StringView EMPTY = new StringView("");
    private final String value;

    private StringView(String value) {
        this.value = value;
    }

    public static StringView of(@NotNull String value) {
        Objects.requireNonNull(value);
        return !value.isEmpty() ? new StringView(value) : EMPTY;
    }

    public static StringView of(@NotNull CharSequence value) {
        return StringView.of(value.toString());
    }

    private StringView updated(String value) {
        return this.value != value ? StringView.of(value) : this;
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    public char[] getChars() {
        return this.value.toCharArray();
    }

    public char[] getChars(int beginIndex, int endIndex) {
        Conditions.checkPositionIndices(beginIndex, endIndex, this.value.length());
        int resLength = endIndex - beginIndex;
        if (resLength == 0) {
            return CharArrays.EMPTY;
        }
        char[] res = new char[resLength];
        this.value.getChars(beginIndex, endIndex, res, 0);
        return res;
    }

    public byte[] getBytes() {
        return this.value.getBytes(StandardCharsets.UTF_8);
    }

    public byte[] getBytes(int beginIndex, int endIndex) {
        return this.getBytes(StandardCharsets.UTF_8, beginIndex, endIndex);
    }

    public byte[] getBytes(Charset charset) {
        return this.value.getBytes(charset);
    }

    public byte[] getBytes(Charset charset, int beginIndex, int endIndex) {
        ByteBuffer result;
        Conditions.checkPositionIndices(beginIndex, endIndex, this.value.length());
        if (beginIndex == endIndex) {
            return ByteArrays.EMPTY;
        }
        if (this.value.length() == endIndex - beginIndex) {
            return this.value.getBytes(charset);
        }
        try {
            result = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).encode(CharBuffer.wrap(this.value, beginIndex, endIndex));
        }
        catch (CharacterCodingException e) {
            throw new AssertionError((Object)e);
        }
        if (result.capacity() == result.limit()) {
            return result.array();
        }
        byte[] res = new byte[result.limit()];
        result.get(res);
        return res;
    }

    public StringView format(Object ... args) {
        return this.format(StringFormatFactory.getDefault(), args);
    }

    public StringView format(StringFormatFactory factory, Object ... args) {
        return StringView.of(factory.format(this.value, args));
    }

    @Deprecated
    public StringView formatted(Object ... args) {
        return this.updated(String.format(this.value, args));
    }

    public StringView repeat(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count is negative: " + count);
        }
        if (count == 1) {
            return this;
        }
        if (this.value.isEmpty() || count == 0) {
            return EMPTY;
        }
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            res.append(this.value);
        }
        return StringView.of(res.toString());
    }

    @Override
    @NotNull
    public StringView subSequence(int start, int end) {
        return this.updated(this.value.substring(start, end));
    }

    @NotNull
    public StringView substring(int beginIndex) {
        return this.updated(this.value.substring(beginIndex));
    }

    @NotNull
    public StringView substring(int beginIndex, int endIndex) {
        return this.updated(this.value.substring(beginIndex, endIndex));
    }

    @NotNull
    public StringView removePrefix(String prefix) {
        return this.startsWith(prefix) ? this.substring(prefix.length()) : this;
    }

    @NotNull
    public StringView removePrefix(StringSlice prefix) {
        return this.startsWith(prefix) ? this.substring(prefix.length()) : this;
    }

    @NotNull
    public StringView removePrefix(CharSequence prefix) {
        return this.startsWith(prefix) ? this.substring(prefix.length()) : this;
    }

    @NotNull
    public StringView removeSuffix(String suffix) {
        return this.endsWith(suffix) ? this.substring(0, this.value.length() - suffix.length()) : this;
    }

    @NotNull
    public StringView removeSuffix(StringSlice suffix) {
        return this.endsWith(suffix) ? this.substring(0, this.value.length() - suffix.length()) : this;
    }

    @NotNull
    public StringView removeSuffix(CharSequence suffix) {
        return this.endsWith(suffix) ? this.substring(0, this.value.length() - suffix.length()) : this;
    }

    @NotNull
    public StringView concat(@NotNull CharSequence other) {
        return this.updated(this.value.concat(other.toString()));
    }

    @NotNull
    public StringView concat(@NotNull String other) {
        if (this.isEmpty()) {
            return StringView.of(other);
        }
        return this.updated(this.value.concat(other));
    }

    @NotNull
    public StringView concat(@NotNull StringSlice other) {
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return StringView.of(other.toString());
        }
        StringBuilder builder = new StringBuilder(this.length() + other.length());
        builder.append(this.value);
        other.appendTo(builder);
        return StringView.of(builder.toString());
    }

    public boolean startsWith(@NotNull String prefix) {
        return this.value.startsWith(prefix);
    }

    public boolean startsWith(@NotNull String prefix, int toIndex) {
        return this.value.startsWith(prefix, toIndex);
    }

    public boolean startsWith(@NotNull StringSlice prefix) {
        return StringUtils.startsWith(this.value, prefix);
    }

    public boolean startsWith(@NotNull StringSlice prefix, int toIndex) {
        return StringUtils.startsWith(this.value, prefix, toIndex);
    }

    public boolean startsWith(@NotNull CharSequence prefix) {
        return StringUtils.startsWith(this.value, prefix);
    }

    public boolean startsWith(@NotNull CharSequence prefix, int toIndex) {
        return StringUtils.startsWith(this.value, prefix, toIndex);
    }

    public boolean endsWith(@NotNull String suffix) {
        return this.value.endsWith(suffix);
    }

    public boolean endsWith(@NotNull StringSlice suffix) {
        return this.startsWith(suffix, this.value.length() - suffix.length());
    }

    public boolean endsWith(@NotNull CharSequence suffix) {
        return suffix instanceof StringSlice ? this.endsWith((StringSlice)suffix) : this.value.endsWith(suffix.toString());
    }

    public int indexOf(char ch) {
        return this.value.indexOf(ch);
    }

    public int indexOf(char ch, int beginIndex) {
        return this.value.indexOf(ch, beginIndex);
    }

    public int indexOf(char ch, int beginIndex, int endIndex) {
        Conditions.checkPositionIndices(beginIndex, endIndex, this.value.length());
        for (int i = beginIndex; i < endIndex; ++i) {
            if (this.value.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char ch) {
        return this.value.lastIndexOf(ch);
    }

    public int lastIndexOf(char ch, int beginIndex) {
        return this.value.lastIndexOf(ch, beginIndex);
    }

    public int lastIndexOf(char ch, int beginIndex, int endIndex) {
        Conditions.checkPositionIndices(beginIndex, endIndex, this.value.length());
        for (int i = endIndex - 1; i >= beginIndex; --i) {
            if (this.value.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(int ch, int fromIndex) {
        return this.value.indexOf(ch, fromIndex);
    }

    public StringView toLowerCase() {
        return this.updated(this.value.toLowerCase(Locale.ROOT));
    }

    public StringView toLowerCase(Locale locale) {
        return this.updated(this.value.toLowerCase(locale));
    }

    public StringView toUpperCase() {
        return this.updated(this.value.toUpperCase(Locale.ROOT));
    }

    public StringView toUpperCase(Locale locale) {
        return this.updated(this.value.toUpperCase(locale));
    }

    public StringView trim() {
        return this.updated(this.value.trim());
    }

    public StringView replace(char oldChar, char newChar) {
        return this.updated(this.value.replace(oldChar, newChar));
    }

    public boolean contentEquals(StringSlice other) {
        return this.value.length() == other.length() && this.value.regionMatches(0, other.source(), other.sourceOffset(), this.value.length());
    }

    public boolean contentEquals(String other) {
        return this.value.equals(other);
    }

    public boolean contentEquals(CharSequence other) {
        if (this.value.length() != other.length()) {
            return false;
        }
        if (other instanceof StringSlice) {
            return this.contentEquals((StringSlice)other);
        }
        if (other instanceof String) {
            return this.contentEquals((String)other);
        }
        for (int i = 0; i < this.value.length(); ++i) {
            if (this.value.charAt(i) == other.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean contentEqualsIgnoreCase(StringSlice other) {
        return this.value.length() == other.length() && this.value.regionMatches(true, 0, other.source(), other.sourceOffset(), this.value.length());
    }

    public boolean contentEqualsIgnoreCase(String other) {
        return this.value.equalsIgnoreCase(other);
    }

    public boolean contentEqualsIgnoreCase(CharSequence other) {
        if (this.value.length() != other.length()) {
            return false;
        }
        if (other instanceof StringSlice) {
            return this.contentEqualsIgnoreCase((StringSlice)other);
        }
        return this.contentEqualsIgnoreCase(other.toString());
    }

    public boolean toBoolean() {
        return this.contentEqualsIgnoreCase("true");
    }

    public byte toByte() throws NumberFormatException {
        return Byte.parseByte(this.value, 10);
    }

    public byte toByte(int radix) throws NumberFormatException {
        return Byte.parseByte(this.value, radix);
    }

    @Nullable
    public Byte toByteOrNull() {
        try {
            return Byte.parseByte(this.value, 10);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public Byte toByteOrNull(int radix) {
        try {
            return Byte.parseByte(this.value, radix);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    public ByteOption toByteOption() {
        try {
            return ByteOption.some(Byte.parseByte(this.value, 10));
        }
        catch (NumberFormatException e) {
            return ByteOption.none();
        }
    }

    @NotNull
    public ByteOption toByteOption(int radix) {
        try {
            return ByteOption.some(Byte.parseByte(this.value, radix));
        }
        catch (NumberFormatException e) {
            return ByteOption.none();
        }
    }

    public short toShort() throws NumberFormatException {
        return Short.parseShort(this.value, 10);
    }

    public short toShort(int radix) throws NumberFormatException {
        return Short.parseShort(this.value, radix);
    }

    @Nullable
    public Short toShortOrNull() {
        try {
            return Short.parseShort(this.value, 10);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public Short toShortOrNull(int radix) {
        try {
            return Short.parseShort(this.value, radix);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    public ShortOption toShortOption() {
        try {
            return ShortOption.some(Short.parseShort(this.value, 10));
        }
        catch (NumberFormatException e) {
            return ShortOption.none();
        }
    }

    @NotNull
    public ShortOption toShortOption(int radix) {
        try {
            return ShortOption.some(Short.parseShort(this.value, radix));
        }
        catch (NumberFormatException e) {
            return ShortOption.none();
        }
    }

    public int toInt() throws NumberFormatException {
        return this.toInt(10);
    }

    public int toInt(int radix) throws NumberFormatException {
        return Integer.parseInt(this.value, radix);
    }

    @Nullable
    public Integer toIntOrNull() {
        try {
            return this.toInt(10);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public Integer toIntOrNull(int radix) {
        try {
            return this.toInt(radix);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    public IntOption toIntOption() {
        try {
            return IntOption.some(this.toInt(10));
        }
        catch (NumberFormatException e) {
            return IntOption.none();
        }
    }

    @NotNull
    public IntOption toIntOption(int radix) {
        try {
            return IntOption.some(this.toInt(radix));
        }
        catch (NumberFormatException e) {
            return IntOption.none();
        }
    }

    public long toLong() throws NumberFormatException {
        return this.toLong(10);
    }

    public long toLong(int radix) throws NumberFormatException {
        return Long.parseLong(this.value, radix);
    }

    @Nullable
    public Long toLongOrNull() {
        try {
            return this.toLong(10);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public Long toLongOrNull(int radix) {
        try {
            return this.toLong(radix);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    public LongOption toLongOption() {
        try {
            return LongOption.some(this.toLong(10));
        }
        catch (NumberFormatException e) {
            return LongOption.none();
        }
    }

    @NotNull
    public LongOption toLongOption(int radix) {
        try {
            return LongOption.some(this.toLong(radix));
        }
        catch (NumberFormatException e) {
            return LongOption.none();
        }
    }

    public float toFloat() throws NumberFormatException {
        return Float.parseFloat(this.value);
    }

    @Nullable
    public Float toFloatOrNull() {
        try {
            return Float.valueOf(Float.parseFloat(this.value));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    public FloatOption toFloatOption() {
        try {
            return FloatOption.some(Float.parseFloat(this.value));
        }
        catch (NumberFormatException e) {
            return FloatOption.none();
        }
    }

    public double toDouble() throws NumberFormatException {
        return Double.parseDouble(this.value);
    }

    @Nullable
    public Double toDoubleOrNull() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    public DoubleOption toDoubleOption() {
        try {
            return DoubleOption.some(Double.parseDouble(this.value));
        }
        catch (NumberFormatException e) {
            return DoubleOption.none();
        }
    }

    @Override
    @NotNull
    public CharIterator iterator() {
        return CharIterator.of(this.value);
    }

    @Override
    public void forEach(@NotNull CharConsumer action) {
        for (int i = 0; i < this.value.length(); ++i) {
            action.accept(this.value.charAt(i));
        }
    }

    public void forEachCodePoint(@NotNull IntConsumer action) {
        int ch;
        for (int offset = 0; offset < this.value.length(); offset += Character.charCount(ch)) {
            ch = this.value.codePointAt(offset);
            action.accept(ch);
        }
    }

    @Override
    public char @NotNull [] toArray() {
        return this.value.toCharArray();
    }

    @Override
    public int compareTo(@NotNull StringView o) {
        return this.value.compareTo(o.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof StringView && this.value.equals(((StringView)obj).value);
    }

    public boolean equalsIgnoreCase(String other) {
        return this.value.equalsIgnoreCase(other);
    }

    public boolean equalsIgnoreCase(StringView other) {
        return this.value.equalsIgnoreCase(other.value);
    }

    @Override
    public String toString() {
        return this.value;
    }
}

