/*
 * Decompiled with CFR 0.152.
 */
package kala.tuple;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.IntFunction;
import kala.collection.base.GenericArrays;
import kala.tuple.AnyTuple;
import kala.tuple.HList;
import kala.tuple.Tuple1;
import kala.tuple.Tuple2;
import kala.tuple.Tuple3;
import kala.tuple.Tuple4;
import kala.tuple.Tuple5;
import kala.tuple.Tuple6;
import kala.tuple.Tuple7;
import kala.tuple.Tuple8;
import kala.tuple.Tuple9;
import kala.tuple.TupleXXL;
import kala.tuple.Unit;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface Tuple
extends AnyTuple,
Serializable {
    @Override
    @Contract(pure=true)
    public int arity();

    @Override
    @Contract(pure=true)
    @Flow(sourceIsContainer=true)
    public <U> U elementAt(int var1);

    @Contract(pure=true)
    @NotNull
    public <H> HList<H, ? extends Tuple> cons(H var1);

    @Contract(value="-> new", pure=true)
    default public Object @NotNull [] toArray() {
        return this.toArray(Object[]::new);
    }

    default public <U> U @NotNull [] toArray(@NotNull Class<U> type) {
        return this.toArray(GenericArrays.generator(type));
    }

    @Contract(pure=true)
    public <U> U @NotNull [] toArray(@NotNull IntFunction<U[]> var1);

    @NotNull
    public static Unit empty() {
        return Unit.INSTANCE;
    }

    @NotNull
    public static Unit of() {
        return Unit.INSTANCE;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <T1> Tuple1<T1> of(T1 t1) {
        return new Tuple1<T1>(t1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static <T1, T2> Tuple2<T1, T2> of(T1 t1, T2 t2) {
        return new Tuple2<T1, T2>(t1, t2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static <T1, T2, T3> Tuple3<T1, T2, T3> of(T1 t1, T2 t2, T3 t3) {
        return new Tuple3<T1, T2, T3>(t1, t2, t3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static <T1, T2, T3, T4> Tuple4<T1, T2, T3, T4> of(T1 t1, T2 t2, T3 t3, T4 t4) {
        return new Tuple4<T1, T2, T3, T4>(t1, t2, t3, t4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static <T1, T2, T3, T4, T5> Tuple5<T1, T2, T3, T4, T5> of(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5) {
        return new Tuple5<T1, T2, T3, T4, T5>(t1, t2, t3, t4, t5);
    }

    @Contract(value="_, _, _, _, _, _ -> new")
    @NotNull
    public static <T1, T2, T3, T4, T5, T6> Tuple6<T1, T2, T3, T4, T5, T6> of(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6) {
        return new Tuple6<T1, T2, T3, T4, T5, T6>(t1, t2, t3, t4, t5, t6);
    }

    @Contract(value="_, _, _, _, _, _, _ -> new")
    @NotNull
    public static <T1, T2, T3, T4, T5, T6, T7> Tuple7<T1, T2, T3, T4, T5, T6, T7> of(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6, T7 t7) {
        return new Tuple7<T1, T2, T3, T4, T5, T6, T7>(t1, t2, t3, t4, t5, t6, t7);
    }

    @Contract(value="_, _, _, _, _, _, _, _ -> new")
    @NotNull
    public static <T1, T2, T3, T4, T5, T6, T7, T8> Tuple8<T1, T2, T3, T4, T5, T6, T7, T8> of(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6, T7 t7, T8 t8) {
        return new Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>(t1, t2, t3, t4, t5, t6, t7, t8);
    }

    @Contract(value="_, _, _, _, _, _, _, _, _ -> new")
    @NotNull
    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9> Tuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9> of(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6, T7 t7, T8 t8, T9 t9) {
        return new Tuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9>(t1, t2, t3, t4, t5, t6, t7, t8, t9);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <T extends Tuple> T of(Object ... values) {
        switch (values.length) {
            case 0: {
                return (T)Unit.INSTANCE;
            }
            case 1: {
                return (T)new Tuple1<Object>(values[0]);
            }
            case 2: {
                return (T)new Tuple2<Object, Object>(values[0], values[1]);
            }
            case 3: {
                return (T)new Tuple3<Object, Object, Object>(values[0], values[1], values[2]);
            }
            case 4: {
                return (T)new Tuple4<Object, Object, Object, Object>(values[0], values[1], values[2], values[3]);
            }
            case 5: {
                return (T)new Tuple5<Object, Object, Object, Object, Object>(values[0], values[1], values[2], values[3], values[4]);
            }
            case 6: {
                return (T)new Tuple6<Object, Object, Object, Object, Object, Object>(values[0], values[1], values[2], values[3], values[4], values[5]);
            }
            case 7: {
                return (T)new Tuple7<Object, Object, Object, Object, Object, Object, Object>(values[0], values[1], values[2], values[3], values[4], values[5], values[6]);
            }
            case 8: {
                return (T)new Tuple8<Object, Object, Object, Object, Object, Object, Object, Object>(values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]);
            }
            case 9: {
                return (T)new Tuple9<Object, Object, Object, Object, Object, Object, Object, Object, Object>(values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8]);
            }
        }
        return (T)new TupleXXL((Object[])values.clone());
    }

    public static <T> T component1(@NotNull HList<T, ?> tuple) {
        return (T)tuple.elementAt(0);
    }

    public static <T> T component2(@NotNull HList<?, ? extends HList<T, ?>> tuple) {
        return (T)tuple.elementAt(1);
    }

    public static <T> T component3(@NotNull HList<?, ? extends HList<?, ? extends HList<T, ?>>> tuple) {
        return (T)tuple.elementAt(2);
    }

    public static <T> T component4(@NotNull HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<T, ?>>>> tuple) {
        return (T)tuple.elementAt(3);
    }

    public static <T> T component5(@NotNull HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<T, ?>>>>> tuple) {
        return (T)tuple.elementAt(4);
    }

    public static <T> T component6(@NotNull HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<T, ?>>>>>> tuple) {
        return (T)tuple.elementAt(5);
    }

    public static <T> T component7(@NotNull HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<T, ?>>>>>>> tuple) {
        return (T)tuple.elementAt(6);
    }

    public static <T> T component8(@NotNull HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<T, ?>>>>>>>> tuple) {
        return (T)tuple.elementAt(7);
    }

    public static <T> T component9(@NotNull HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<T, ?>>>>>>>>> tuple) {
        return (T)tuple.elementAt(8);
    }

    public static <T> T component10(@NotNull HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<T, ?>>>>>>>>>> tuple) {
        return (T)tuple.elementAt(9);
    }

    public static <T> T component11(@NotNull HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<T, ?>>>>>>>>>>> tuple) {
        return (T)tuple.elementAt(10);
    }

    public static <T> T component12(@NotNull HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<T, ?>>>>>>>>>>>> tuple) {
        return (T)tuple.elementAt(11);
    }

    public static <T> T component13(@NotNull HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<T, ?>>>>>>>>>>>>> tuple) {
        return (T)tuple.elementAt(12);
    }

    public static <T> T component14(@NotNull HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<T, ?>>>>>>>>>>>>>> tuple) {
        return (T)tuple.elementAt(13);
    }

    public static <T> T component15(@NotNull HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<T, ?>>>>>>>>>>>>>>> tuple) {
        return (T)tuple.elementAt(14);
    }

    public static <T> T component16(@NotNull HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<T, ?>>>>>>>>>>>>>>>> tuple) {
        return (T)tuple.elementAt(15);
    }

    public static <T> T component17(@NotNull HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<T, ?>>>>>>>>>>>>>>>>> tuple) {
        return (T)tuple.elementAt(16);
    }

    public static <T> T component18(@NotNull HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<?, ? extends HList<T, ?>>>>>>>>>>>>>>>>>> tuple) {
        return (T)tuple.elementAt(17);
    }

    @NotNull
    public static Comparator<Unit> comparator() {
        return (Comparator & Serializable)(u1, u2) -> 0;
    }

    @NotNull
    public static <T1> Comparator<Tuple1<T1>> comparator(@NotNull Comparator<? super T1> c1) {
        return (Comparator & Serializable)(t1, t2) -> c1.compare((Object)t1.component1(), (Object)t2.component1());
    }

    @NotNull
    public static <T1, T2> Comparator<Tuple2<T1, T2>> comparator(@NotNull Comparator<? super T1> c1, @NotNull Comparator<? super T2> c2) {
        return (Comparator & Serializable)(t1, t2) -> {
            int compare1 = c1.compare((Object)t1.component1(), (Object)t2.component1());
            if (compare1 != 0) {
                return compare1;
            }
            return c2.compare((Object)t1.component2(), (Object)t2.component2());
        };
    }

    @NotNull
    public static <T1, T2, T3> Comparator<Tuple3<T1, T2, T3>> comparator(@NotNull Comparator<? super T1> c1, @NotNull Comparator<? super T2> c2, @NotNull Comparator<? super T3> c3) {
        return (Comparator & Serializable)(t1, t2) -> {
            int compare1 = c1.compare((Object)t1.component1(), (Object)t2.component1());
            if (compare1 != 0) {
                return compare1;
            }
            int compare2 = c2.compare((Object)t1.component2(), (Object)t2.component2());
            if (compare2 != 0) {
                return compare2;
            }
            return c3.compare((Object)t1.component3(), (Object)t2.component3());
        };
    }

    @NotNull
    public static <T1, T2, T3, T4> Comparator<Tuple4<T1, T2, T3, T4>> comparator(@NotNull Comparator<? super T1> c1, @NotNull Comparator<? super T2> c2, @NotNull Comparator<? super T3> c3, @NotNull Comparator<? super T4> c4) {
        return (Comparator & Serializable)(t1, t2) -> {
            int compare1 = c1.compare((Object)t1.component1(), (Object)t2.component1());
            if (compare1 != 0) {
                return compare1;
            }
            int compare2 = c2.compare((Object)t1.component2(), (Object)t2.component2());
            if (compare2 != 0) {
                return compare2;
            }
            int compare3 = c3.compare((Object)t1.component3(), (Object)t2.component3());
            if (compare3 != 0) {
                return compare3;
            }
            return c4.compare((Object)t1.component4(), (Object)t2.component4());
        };
    }

    @NotNull
    public static <T1, T2, T3, T4, T5> Comparator<Tuple5<T1, T2, T3, T4, T5>> comparator(@NotNull Comparator<? super T1> c1, @NotNull Comparator<? super T2> c2, @NotNull Comparator<? super T3> c3, @NotNull Comparator<? super T4> c4, @NotNull Comparator<? super T5> c5) {
        return (Comparator & Serializable)(t1, t2) -> {
            int compare1 = c1.compare((Object)t1.component1(), (Object)t2.component1());
            if (compare1 != 0) {
                return compare1;
            }
            int compare2 = c2.compare((Object)t1.component2(), (Object)t2.component2());
            if (compare2 != 0) {
                return compare2;
            }
            int compare3 = c3.compare((Object)t1.component3(), (Object)t2.component3());
            if (compare3 != 0) {
                return compare3;
            }
            int compare4 = c4.compare((Object)t1.component4(), (Object)t2.component4());
            if (compare4 != 0) {
                return compare4;
            }
            return c5.compare((Object)t1.component5(), (Object)t2.component5());
        };
    }

    @NotNull
    public static <T1, T2, T3, T4, T5, T6> Comparator<Tuple6<T1, T2, T3, T4, T5, T6>> comparator(@NotNull Comparator<? super T1> c1, @NotNull Comparator<? super T2> c2, @NotNull Comparator<? super T3> c3, @NotNull Comparator<? super T4> c4, @NotNull Comparator<? super T5> c5, @NotNull Comparator<? super T6> c6) {
        return (Comparator & Serializable)(t1, t2) -> {
            int compare1 = c1.compare((Object)t1.component1(), (Object)t2.component1());
            if (compare1 != 0) {
                return compare1;
            }
            int compare2 = c2.compare((Object)t1.component2(), (Object)t2.component2());
            if (compare2 != 0) {
                return compare2;
            }
            int compare3 = c3.compare((Object)t1.component3(), (Object)t2.component3());
            if (compare3 != 0) {
                return compare3;
            }
            int compare4 = c4.compare((Object)t1.component4(), (Object)t2.component4());
            if (compare4 != 0) {
                return compare4;
            }
            int compare5 = c5.compare((Object)t1.component5(), (Object)t2.component5());
            if (compare5 != 0) {
                return compare5;
            }
            return c6.compare((Object)t1.component6(), (Object)t2.component6());
        };
    }

    @NotNull
    public static <T1, T2, T3, T4, T5, T6, T7> Comparator<Tuple7<T1, T2, T3, T4, T5, T6, T7>> comparator(@NotNull Comparator<? super T1> c1, @NotNull Comparator<? super T2> c2, @NotNull Comparator<? super T3> c3, @NotNull Comparator<? super T4> c4, @NotNull Comparator<? super T5> c5, @NotNull Comparator<? super T6> c6, @NotNull Comparator<? super T7> c7) {
        return (Comparator & Serializable)(t1, t2) -> {
            int compare1 = c1.compare((Object)t1.component1(), (Object)t2.component1());
            if (compare1 != 0) {
                return compare1;
            }
            int compare2 = c2.compare((Object)t1.component2(), (Object)t2.component2());
            if (compare2 != 0) {
                return compare2;
            }
            int compare3 = c3.compare((Object)t1.component3(), (Object)t2.component3());
            if (compare3 != 0) {
                return compare3;
            }
            int compare4 = c4.compare((Object)t1.component4(), (Object)t2.component4());
            if (compare4 != 0) {
                return compare4;
            }
            int compare5 = c5.compare((Object)t1.component5(), (Object)t2.component5());
            if (compare5 != 0) {
                return compare5;
            }
            int compare6 = c6.compare((Object)t1.component6(), (Object)t2.component6());
            if (compare6 != 0) {
                return compare6;
            }
            return c7.compare((Object)t1.component7(), (Object)t2.component7());
        };
    }

    @NotNull
    public static <T1, T2, T3, T4, T5, T6, T7, T8> Comparator<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> comparator(@NotNull Comparator<? super T1> c1, @NotNull Comparator<? super T2> c2, @NotNull Comparator<? super T3> c3, @NotNull Comparator<? super T4> c4, @NotNull Comparator<? super T5> c5, @NotNull Comparator<? super T6> c6, @NotNull Comparator<? super T7> c7, @NotNull Comparator<? super T8> c8) {
        return (Comparator & Serializable)(t1, t2) -> {
            int compare1 = c1.compare((Object)t1.component1(), (Object)t2.component1());
            if (compare1 != 0) {
                return compare1;
            }
            int compare2 = c2.compare((Object)t1.component2(), (Object)t2.component2());
            if (compare2 != 0) {
                return compare2;
            }
            int compare3 = c3.compare((Object)t1.component3(), (Object)t2.component3());
            if (compare3 != 0) {
                return compare3;
            }
            int compare4 = c4.compare((Object)t1.component4(), (Object)t2.component4());
            if (compare4 != 0) {
                return compare4;
            }
            int compare5 = c5.compare((Object)t1.component5(), (Object)t2.component5());
            if (compare5 != 0) {
                return compare5;
            }
            int compare6 = c6.compare((Object)t1.component6(), (Object)t2.component6());
            if (compare6 != 0) {
                return compare6;
            }
            int compare7 = c7.compare((Object)t1.component7(), (Object)t2.component7());
            if (compare7 != 0) {
                return compare7;
            }
            return c8.compare((Object)t1.component8(), (Object)t2.component8());
        };
    }

    @NotNull
    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9> Comparator<Tuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9>> comparator(@NotNull Comparator<? super T1> c1, @NotNull Comparator<? super T2> c2, @NotNull Comparator<? super T3> c3, @NotNull Comparator<? super T4> c4, @NotNull Comparator<? super T5> c5, @NotNull Comparator<? super T6> c6, @NotNull Comparator<? super T7> c7, @NotNull Comparator<? super T8> c8, @NotNull Comparator<? super T9> c9) {
        return (Comparator & Serializable)(t1, t2) -> {
            int compare1 = c1.compare((Object)t1.component1(), (Object)t2.component1());
            if (compare1 != 0) {
                return compare1;
            }
            int compare2 = c2.compare((Object)t1.component2(), (Object)t2.component2());
            if (compare2 != 0) {
                return compare2;
            }
            int compare3 = c3.compare((Object)t1.component3(), (Object)t2.component3());
            if (compare3 != 0) {
                return compare3;
            }
            int compare4 = c4.compare((Object)t1.component4(), (Object)t2.component4());
            if (compare4 != 0) {
                return compare4;
            }
            int compare5 = c5.compare((Object)t1.component5(), (Object)t2.component5());
            if (compare5 != 0) {
                return compare5;
            }
            int compare6 = c6.compare((Object)t1.component6(), (Object)t2.component6());
            if (compare6 != 0) {
                return compare6;
            }
            int compare7 = c7.compare((Object)t1.component7(), (Object)t2.component7());
            if (compare7 != 0) {
                return compare7;
            }
            int compare8 = c8.compare((Object)t1.component8(), (Object)t2.component8());
            if (compare8 != 0) {
                return compare8;
            }
            return c9.compare((Object)t1.component9(), (Object)t2.component9());
        };
    }

    @NotNull
    public static <T extends Tuple> Comparator<T> comparator(Comparator<?> ... comparators) {
        int n = comparators.length;
        switch (n) {
            case 0: {
                return Tuple.comparator();
            }
            case 1: {
                return Tuple.comparator(comparators[0]);
            }
            case 2: {
                return Tuple.comparator(comparators[0], comparators[1]);
            }
            case 3: {
                return Tuple.comparator(comparators[0], comparators[1], comparators[2]);
            }
            case 4: {
                return Tuple.comparator(comparators[0], comparators[1], comparators[2], comparators[3]);
            }
            case 5: {
                return Tuple.comparator(comparators[0], comparators[1], comparators[2], comparators[3], comparators[4]);
            }
            case 6: {
                return Tuple.comparator(comparators[0], comparators[1], comparators[2], comparators[3], comparators[4], comparators[5]);
            }
            case 7: {
                return Tuple.comparator(comparators[0], comparators[1], comparators[2], comparators[3], comparators[4], comparators[5], comparators[6]);
            }
            case 8: {
                return Tuple.comparator(comparators[0], comparators[1], comparators[2], comparators[3], comparators[4], comparators[5], comparators[6], comparators[7]);
            }
            case 9: {
                return Tuple.comparator(comparators[0], comparators[1], comparators[2], comparators[3], comparators[4], comparators[5], comparators[6], comparators[7], comparators[8]);
            }
        }
        final class ComparatorN
        implements Comparator<Tuple>,
        Serializable {
            private static final long serialVersionUID = 0L;
            @NotNull
            private final Comparator<?>[] comparators;

            ComparatorN(@NotNull Comparator<?>[] comparators) {
                this.comparators = comparators;
            }

            @Override
            public int compare(Tuple o1, Tuple o2) {
                Comparator<?>[] comparators = this.comparators;
                int n = comparators.length;
                if (o1.arity() != n || o2.arity() != n) {
                    throw new ClassCastException();
                }
                for (int i = 0; i < n; ++i) {
                    Comparator<?> c = comparators[i];
                    int res = c.compare(o1.elementAt(i), o2.elementAt(i));
                    if (res == 0) continue;
                    return res;
                }
                return 0;
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof ComparatorN)) {
                    return false;
                }
                ComparatorN cn = (ComparatorN)obj;
                return Arrays.equals(this.comparators, cn.comparators);
            }
        }
        return new ComparatorN((Comparator[])comparators.clone());
    }
}

