/*
 * Decompiled with CFR 0.152.
 */
package kala.tuple;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.IntFunction;
import kala.tuple.AnyTuple;
import kala.tuple.HList;
import kala.tuple.SerializedTuple;
import kala.tuple.Tuple;
import kala.tuple.Tuple3;
import kala.tuple.Tuple5;
import kala.tuple.Unit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Tuple4<T1, T2, T3, T4>
implements HList<T1, Tuple3<T2, T3, T4>>,
Serializable {
    private static final long serialVersionUID = 2111962546132489176L;
    private final T1 component1;
    private final T2 component2;
    private final T3 component3;
    private final T4 component4;

    public Tuple4(T1 t1, T2 t2, T3 t3, T4 t4) {
        this.component1 = t1;
        this.component2 = t2;
        this.component3 = t3;
        this.component4 = t4;
    }

    @Contract(value="_ -> param1", pure=true)
    public static <T1, T2, T3, T4> Tuple4<T1, T2, T3, T4> narrow(HList<? extends T1, ? extends HList<? extends T2, ? extends HList<? extends T3, ? extends HList<? extends T4, ? extends Unit>>>> tuple) {
        return (Tuple4)tuple;
    }

    @Override
    public int arity() {
        return 4;
    }

    @Override
    public <U> U elementAt(int index) {
        switch (index) {
            case 0: {
                return (U)this.component1;
            }
            case 1: {
                return (U)this.component2;
            }
            case 2: {
                return (U)this.component3;
            }
            case 3: {
                return (U)this.component4;
            }
        }
        throw new IndexOutOfBoundsException("Index out of range: " + index);
    }

    @Override
    public <U> U @NotNull [] toArray(@NotNull IntFunction<U[]> generator) {
        U[] arr = generator.apply(this.arity());
        arr[0] = this.component1;
        arr[1] = this.component2;
        arr[2] = this.component3;
        arr[3] = this.component4;
        return arr;
    }

    public T1 component1() {
        return this.component1;
    }

    public T2 component2() {
        return this.component2;
    }

    public T3 component3() {
        return this.component3;
    }

    public T4 component4() {
        return this.component4;
    }

    @Override
    public T1 head() {
        return this.component1;
    }

    @Override
    @NotNull
    public Tuple3<T2, T3, T4> tail() {
        return Tuple.of(this.component2, this.component3, this.component4);
    }

    @Contract(value="_ -> new")
    @NotNull
    public <H> Tuple5<H, T1, T2, T3, T4> cons(H head) {
        return new Tuple5<H, T1, T2, T3, T4>(head, this.component1, this.component2, this.component3, this.component4);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Tuple4) {
            Tuple4 other = (Tuple4)o;
            return Objects.equals(this.component1, other.component1) && Objects.equals(this.component2, other.component2) && Objects.equals(this.component3, other.component3) && Objects.equals(this.component4, other.component4);
        }
        if (o instanceof AnyTuple) {
            AnyTuple other = (AnyTuple)o;
            return other.arity() == 4 && Objects.equals(this.component1, other.elementAt(0)) && Objects.equals(this.component2, other.elementAt(1)) && Objects.equals(this.component3, other.elementAt(2)) && Objects.equals(this.component4, other.elementAt(3));
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        hash = 31 * hash + Objects.hashCode(this.component1);
        hash = 31 * hash + Objects.hashCode(this.component2);
        hash = 31 * hash + Objects.hashCode(this.component3);
        hash = 31 * hash + Objects.hashCode(this.component4);
        return hash;
    }

    public String toString() {
        return "(" + this.component1 + ", " + this.component2 + ", " + this.component3 + ", " + this.component4 + ")";
    }

    private Object writeReplace() {
        return new SerializedTuple(this.toArray());
    }
}

