/*
 * Decompiled with CFR 0.152.
 */
package kala.tuple.primitive;

import java.util.Map;
import kala.Conditions;
import kala.tuple.AnyTuple;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import kala.tuple.primitive.PrimitiveTuple;
import org.jetbrains.annotations.NotNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class BooleanTuple2
implements Map.Entry<Boolean, Boolean>,
PrimitiveTuple {
    private static final long serialVersionUID = 0L;
    private static final BooleanTuple2 TT = new BooleanTuple2(true, true);
    private static final BooleanTuple2 TF = new BooleanTuple2(true, false);
    private static final BooleanTuple2 FT = new BooleanTuple2(false, true);
    private static final BooleanTuple2 FF = new BooleanTuple2(false, false);
    private static final String TT_S = "BooleanTuple2(true, true)";
    private static final String TF_S = "BooleanTuple2(true, false)";
    private static final String FT_S = "BooleanTuple2(false, true)";
    private static final String FF_S = "BooleanTuple2(false, false)";
    private final boolean component1;
    private final boolean component2;

    private BooleanTuple2(boolean b1, boolean b2) {
        this.component1 = b1;
        this.component2 = b2;
    }

    @NotNull
    public static BooleanTuple2 of(boolean b1, boolean b2) {
        if (b1) {
            return b2 ? TT : TF;
        }
        return b2 ? FT : FF;
    }

    @Override
    public int arity() {
        return 2;
    }

    @Override
    public <U> U elementAt(int index) {
        switch (index) {
            case 0: {
                return (U)Boolean.valueOf(this.component1);
            }
            case 1: {
                return (U)Boolean.valueOf(this.component2);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public boolean component1() {
        return this.component1;
    }

    public boolean component2() {
        return this.component2;
    }

    @NotNull
    public @NotNull Tuple2<@NotNull Boolean, @NotNull Boolean> toTuple2() {
        return Tuple.of(this.component1, this.component2);
    }

    @Override
    public Boolean getKey() {
        return this.component1;
    }

    @Override
    public Boolean getValue() {
        return this.component2;
    }

    @Override
    public Boolean setValue(Boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BooleanTuple2) {
            BooleanTuple2 other = (BooleanTuple2)o;
            return this.component1 == other.component1 && this.component2 == other.component2;
        }
        if (o instanceof Map.Entry) {
            Map.Entry other = (Map.Entry)o;
            return Conditions.equals(this.component1, other.getKey()) && Conditions.equals(this.component2, other.getValue());
        }
        if (o instanceof AnyTuple) {
            AnyTuple other = (AnyTuple)o;
            return other.arity() == 2 && Conditions.equals(this.component1, other.elementAt(0)) && Conditions.equals(this.component2, other.elementAt(1));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Boolean.hashCode(this.component1) ^ Boolean.hashCode(this.component2);
    }

    public String toString() {
        if (this.component1) {
            return this.component2 ? TT_S : TF_S;
        }
        return this.component2 ? FT_S : FF_S;
    }

    private Object readResolve() {
        return BooleanTuple2.of(this.component1, this.component2);
    }
}

