/*
 * Decompiled with CFR 0.152.
 */
package kala.tuple.primitive;

import java.util.Map;
import kala.Conditions;
import kala.tuple.AnyTuple;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import kala.tuple.primitive.PrimitiveTuple;
import org.jetbrains.annotations.NotNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class DoubleTuple2
implements PrimitiveTuple,
Map.Entry<Double, Double> {
    private static final long serialVersionUID = 0L;
    private final double component1;
    private final double component2;

    private DoubleTuple2(double v1, double v2) {
        this.component1 = v1;
        this.component2 = v2;
    }

    @NotNull
    public static DoubleTuple2 of(double v1, double v2) {
        return new DoubleTuple2(v1, v2);
    }

    @Override
    public int arity() {
        return 2;
    }

    @Override
    public <U> U elementAt(int index) {
        switch (index) {
            case 0: {
                return (U)Double.valueOf(this.component1);
            }
            case 1: {
                return (U)Double.valueOf(this.component2);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public double component1() {
        return this.component1;
    }

    public double component2() {
        return this.component2;
    }

    @NotNull
    public @NotNull Tuple2<@NotNull Double, @NotNull Double> toTuple2() {
        return Tuple.of(this.component1, this.component2);
    }

    @Override
    public Double getKey() {
        return this.component1;
    }

    @Override
    public Double getValue() {
        return this.component2;
    }

    @Override
    @Deprecated
    public Double setValue(Double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DoubleTuple2) {
            DoubleTuple2 other = (DoubleTuple2)o;
            return Conditions.equals(this.component1, other.component1) && Conditions.equals(this.component2, other.component2);
        }
        if (o instanceof Map.Entry) {
            Map.Entry other = (Map.Entry)o;
            return Conditions.equals(this.component1, other.getKey()) && Conditions.equals(this.component2, other.getValue());
        }
        if (o instanceof AnyTuple) {
            AnyTuple other = (AnyTuple)o;
            return other.arity() == 2 && Conditions.equals(this.component1, other.elementAt(0)) && Conditions.equals(this.component2, other.elementAt(1));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Double.hashCode(this.component1) ^ Double.hashCode(this.component2);
    }

    public String toString() {
        return "DoubleTuple2(" + this.component1 + ", " + this.component2 + ")";
    }
}

