/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.util.Objects;
import kala.collection.base.primitive.ByteIterator;
import kala.collection.base.primitive.ByteTraversable;
import kala.function.ByteConsumer;
import kala.function.ByteSupplier;
import kala.function.ByteUnaryOperator;
import kala.value.primitive.DefaultByteValue;
import kala.value.primitive.DelegateByteValue;
import kala.value.primitive.DelegateMutableByteValue;
import kala.value.primitive.LazyByteValue;
import kala.value.primitive.MutableByteValue;
import kala.value.primitive.PrimitiveValue;
import org.jetbrains.annotations.NotNull;

public interface ByteValue
extends PrimitiveValue<Byte>,
ByteTraversable,
ByteSupplier {
    @NotNull
    public static ByteValue of(byte value) {
        return new DefaultByteValue(value);
    }

    @NotNull
    public static ByteValue by(@NotNull ByteSupplier getter) {
        Objects.requireNonNull(getter);
        return new DelegateByteValue(getter);
    }

    @NotNull
    public static LazyByteValue lazy(@NotNull ByteSupplier getter) {
        return LazyByteValue.of(getter);
    }

    public byte get();

    @Override
    @Deprecated
    default public byte getAsByte() {
        return this.get();
    }

    @Override
    @NotNull
    default public Byte getValue() {
        return this.get();
    }

    @NotNull
    default public ByteValue map(@NotNull ByteUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return ByteValue.by(() -> mapper.applyAsByte(this.get()));
    }

    @NotNull
    default public MutableByteValue asMutable(@NotNull ByteConsumer setter) {
        Objects.requireNonNull(setter);
        return new DelegateMutableByteValue(this, setter);
    }

    @Override
    @NotNull
    default public ByteIterator iterator() {
        return ByteIterator.of(this.get());
    }

    @Override
    default public void forEach(@NotNull ByteConsumer action) {
        action.accept(this.get());
    }
}

