/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.util.Objects;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.function.CharConsumer;
import kala.function.CharSupplier;
import kala.function.CharUnaryOperator;
import kala.value.primitive.DefaultCharValue;
import kala.value.primitive.DelegateCharValue;
import kala.value.primitive.DelegateMutableCharValue;
import kala.value.primitive.LazyCharValue;
import kala.value.primitive.MutableCharValue;
import kala.value.primitive.PrimitiveValue;
import org.jetbrains.annotations.NotNull;

public interface CharValue
extends PrimitiveValue<Character>,
CharTraversable,
CharSupplier {
    @NotNull
    public static CharValue of(char value) {
        return new DefaultCharValue(value);
    }

    @NotNull
    public static CharValue by(@NotNull CharSupplier getter) {
        Objects.requireNonNull(getter);
        return new DelegateCharValue(getter);
    }

    @NotNull
    public static LazyCharValue lazy(@NotNull CharSupplier getter) {
        return LazyCharValue.of(getter);
    }

    public char get();

    @Override
    @Deprecated
    default public char getAsChar() {
        return this.get();
    }

    @Override
    @NotNull
    default public Character getValue() {
        return Character.valueOf(this.get());
    }

    @NotNull
    default public CharValue map(@NotNull CharUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return CharValue.by(() -> mapper.applyAsChar(this.get()));
    }

    @NotNull
    default public MutableCharValue asMutable(@NotNull CharConsumer setter) {
        Objects.requireNonNull(setter);
        return new DelegateMutableCharValue(this, setter);
    }

    @Override
    @NotNull
    default public CharIterator iterator() {
        return CharIterator.of(this.get());
    }

    @Override
    default public void forEach(@NotNull CharConsumer action) {
        action.accept(this.get());
    }
}

