/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.util.Objects;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.base.primitive.DoubleTraversable;
import kala.value.primitive.DefaultDoubleValue;
import kala.value.primitive.DelegateDoubleValue;
import kala.value.primitive.DelegateMutableDoubleValue;
import kala.value.primitive.LazyDoubleValue;
import kala.value.primitive.MutableDoubleValue;
import kala.value.primitive.PrimitiveValue;
import org.jetbrains.annotations.NotNull;

public interface DoubleValue
extends PrimitiveValue<Double>,
DoubleTraversable,
DoubleSupplier {
    @NotNull
    public static DoubleValue of(double value) {
        return new DefaultDoubleValue(value);
    }

    @NotNull
    public static DoubleValue by(@NotNull DoubleSupplier getter) {
        Objects.requireNonNull(getter);
        return new DelegateDoubleValue(getter);
    }

    @NotNull
    public static LazyDoubleValue lazy(@NotNull DoubleSupplier getter) {
        return LazyDoubleValue.of(getter);
    }

    public double get();

    @Override
    @Deprecated
    default public double getAsDouble() {
        return this.get();
    }

    @Override
    @NotNull
    default public Double getValue() {
        return this.get();
    }

    @NotNull
    default public DoubleValue map(@NotNull DoubleUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return DoubleValue.by(() -> mapper.applyAsDouble(this.get()));
    }

    @NotNull
    default public MutableDoubleValue asMutable(@NotNull DoubleConsumer setter) {
        Objects.requireNonNull(setter);
        return new DelegateMutableDoubleValue(this, setter);
    }

    @Override
    @NotNull
    default public DoubleIterator iterator() {
        return DoubleIterator.of(this.get());
    }

    @Override
    default public void forEach(@NotNull DoubleConsumer action) {
        action.accept(this.get());
    }
}

