/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.util.Objects;
import kala.collection.base.primitive.FloatIterator;
import kala.collection.base.primitive.FloatTraversable;
import kala.function.FloatConsumer;
import kala.function.FloatSupplier;
import kala.function.FloatUnaryOperator;
import kala.value.primitive.DefaultFloatValue;
import kala.value.primitive.DelegateFloatValue;
import kala.value.primitive.DelegateMutableFloatValue;
import kala.value.primitive.LazyFloatValue;
import kala.value.primitive.MutableFloatValue;
import kala.value.primitive.PrimitiveValue;
import org.jetbrains.annotations.NotNull;

public interface FloatValue
extends PrimitiveValue<Float>,
FloatTraversable,
FloatSupplier {
    @NotNull
    public static FloatValue of(float value) {
        return new DefaultFloatValue(value);
    }

    @NotNull
    public static FloatValue by(@NotNull FloatSupplier getter) {
        Objects.requireNonNull(getter);
        return new DelegateFloatValue(getter);
    }

    @NotNull
    public static LazyFloatValue lazy(@NotNull FloatSupplier getter) {
        return LazyFloatValue.of(getter);
    }

    public float get();

    @Override
    @Deprecated
    default public float getAsFloat() {
        return this.get();
    }

    @Override
    @NotNull
    default public Float getValue() {
        return Float.valueOf(this.get());
    }

    @NotNull
    default public FloatValue map(@NotNull FloatUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return FloatValue.by(() -> mapper.applyAsFloat(this.get()));
    }

    @NotNull
    default public MutableFloatValue asMutable(@NotNull FloatConsumer setter) {
        Objects.requireNonNull(setter);
        return new DelegateMutableFloatValue(this, setter);
    }

    @Override
    @NotNull
    default public FloatIterator iterator() {
        return FloatIterator.of(this.get());
    }

    @Override
    default public void forEach(@NotNull FloatConsumer action) {
        action.accept(this.get());
    }
}

