/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.base.primitive.AbstractByteIterator;
import kala.collection.base.primitive.ByteIterator;
import kala.collection.base.primitive.ByteTraversable;
import kala.function.ByteFunction;
import kala.function.ByteSupplier;
import kala.function.ByteUnaryOperator;
import kala.function.Memoized;
import kala.value.LazyValue;
import kala.value.primitive.AbstractByteValue;
import kala.value.primitive.ByteValue;
import org.jetbrains.annotations.NotNull;

public class LazyByteValue
extends AbstractByteValue
implements ByteTraversable,
ByteValue,
ByteSupplier,
Memoized,
Serializable {
    private static final long serialVersionUID = 0L;
    private volatile transient ByteSupplier supplier;
    private transient byte value;

    private LazyByteValue(ByteSupplier supplier) {
        this.supplier = supplier;
    }

    private LazyByteValue(byte value) {
        this.value = value;
    }

    public static LazyByteValue of(@NotNull ByteSupplier supplier) {
        Objects.requireNonNull(supplier);
        return new LazyByteValue(supplier);
    }

    public static LazyByteValue ofValue(byte value) {
        return new LazyByteValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte get() {
        if (this.supplier != null) {
            LazyByteValue lazyByteValue = this;
            synchronized (lazyByteValue) {
                ByteSupplier s = this.supplier;
                if (s != null) {
                    this.value = s.getAsByte();
                    this.supplier = null;
                }
            }
        }
        return this.value;
    }

    @Override
    public byte getAsByte() {
        return this.get();
    }

    public boolean isReady() {
        return this.supplier == null;
    }

    @Override
    @NotNull
    public LazyByteValue map(@NotNull ByteUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return LazyByteValue.of(() -> mapper.applyAsByte(this.get()));
    }

    public <U> LazyValue<U> mapToObj(@NotNull ByteFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return LazyValue.of(() -> mapper.apply(this.get()));
    }

    @Override
    @NotNull
    public ByteIterator iterator() {
        return new AbstractByteIterator(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public byte nextByte() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return LazyByteValue.this.get();
            }
        };
    }

    @Override
    public String toString() {
        if (this.supplier == null) {
            return "LazyByteValue[" + this.value + "]";
        }
        return "LazyByteValue[<not computed>]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.value = in.readByte();
        this.supplier = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(this.get());
    }
}

