/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.base.primitive.AbstractCharIterator;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.function.CharFunction;
import kala.function.CharSupplier;
import kala.function.CharUnaryOperator;
import kala.function.Memoized;
import kala.value.LazyValue;
import kala.value.primitive.AbstractCharValue;
import kala.value.primitive.CharValue;
import org.jetbrains.annotations.NotNull;

public class LazyCharValue
extends AbstractCharValue
implements CharTraversable,
CharValue,
CharSupplier,
Memoized,
Serializable {
    private static final long serialVersionUID = 0L;
    private volatile transient CharSupplier supplier;
    private transient char value;

    private LazyCharValue(CharSupplier supplier) {
        this.supplier = supplier;
    }

    private LazyCharValue(char value) {
        this.value = value;
    }

    public static LazyCharValue of(@NotNull CharSupplier supplier) {
        Objects.requireNonNull(supplier);
        return new LazyCharValue(supplier);
    }

    public static LazyCharValue ofValue(char value) {
        return new LazyCharValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char get() {
        if (this.supplier != null) {
            LazyCharValue lazyCharValue = this;
            synchronized (lazyCharValue) {
                CharSupplier s = this.supplier;
                if (s != null) {
                    this.value = s.getAsChar();
                    this.supplier = null;
                }
            }
        }
        return this.value;
    }

    @Override
    public char getAsChar() {
        return this.get();
    }

    public boolean isReady() {
        return this.supplier == null;
    }

    @Override
    @NotNull
    public LazyCharValue map(@NotNull CharUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return LazyCharValue.of(() -> mapper.applyAsChar(this.get()));
    }

    public <U> LazyValue<U> mapToObj(@NotNull CharFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return LazyValue.of(() -> mapper.apply(this.get()));
    }

    @Override
    @NotNull
    public CharIterator iterator() {
        return new AbstractCharIterator(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public char nextChar() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return LazyCharValue.this.get();
            }
        };
    }

    @Override
    public String toString() {
        if (this.supplier == null) {
            return "LazyCharValue[" + this.value + "]";
        }
        return "LazyCharValue[<not computed>]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.value = in.readChar();
        this.supplier = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeChar(this.get());
    }
}

