/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.util.Objects;
import kala.function.FloatBinaryOperator;
import kala.function.FloatConsumer;
import kala.function.FloatSupplier;
import kala.function.FloatUnaryOperator;
import kala.value.primitive.DelegateMutableFloatValue;
import kala.value.primitive.FloatValue;
import kala.value.primitive.FloatVar;
import kala.value.primitive.MutablePrimitiveValue;
import kala.value.primitive.VolatileFloatVar;
import org.jetbrains.annotations.NotNull;

public interface MutableFloatValue
extends MutablePrimitiveValue<Float>,
FloatValue,
FloatConsumer {
    @NotNull
    public static MutableFloatValue create() {
        return new FloatVar();
    }

    @NotNull
    public static MutableFloatValue create(float initialValue) {
        return new FloatVar(initialValue);
    }

    @NotNull
    public static MutableFloatValue createVolatile() {
        return new VolatileFloatVar();
    }

    @NotNull
    public static MutableFloatValue createVolatile(float initialValue) {
        return new VolatileFloatVar(initialValue);
    }

    @NotNull
    public static MutableFloatValue by(@NotNull FloatSupplier getter, @NotNull FloatConsumer setter) {
        Objects.requireNonNull(getter);
        Objects.requireNonNull(setter);
        return new DelegateMutableFloatValue(getter, setter);
    }

    public void set(float var1);

    @Override
    default public void setValue(@NotNull Float value) {
        this.set(value.floatValue());
    }

    @Override
    @Deprecated
    default public void accept(float value) {
        this.set(value);
    }

    @NotNull
    default public MutableFloatValue withGetter(@NotNull FloatSupplier newGetter) {
        Objects.requireNonNull(newGetter);
        return new DelegateMutableFloatValue(newGetter, this);
    }

    @NotNull
    default public MutableFloatValue withSetter(@NotNull FloatConsumer newSetter) {
        Objects.requireNonNull(newSetter);
        return new DelegateMutableFloatValue(this, newSetter);
    }

    @Override
    @Deprecated
    @NotNull
    default public MutableFloatValue asMutable(@NotNull FloatConsumer setter) {
        return this.withSetter(setter);
    }

    default public float getAndSet(float newValue) {
        float oldValue = this.get();
        this.set(newValue);
        return oldValue;
    }

    default public boolean compareAndSet(float expectedValue, float newValue) {
        if (Float.floatToIntBits(this.get()) == Float.floatToIntBits(expectedValue)) {
            this.set(newValue);
            return true;
        }
        return false;
    }

    default public void update(@NotNull FloatUnaryOperator updateFunction) {
        this.getAndUpdate(updateFunction);
    }

    default public float getAndUpdate(@NotNull FloatUnaryOperator updateFunction) {
        float v = this.get();
        this.set(updateFunction.applyAsFloat(v));
        return v;
    }

    default public float updateAndGet(@NotNull FloatUnaryOperator updateFunction) {
        float v = updateFunction.applyAsFloat(this.get());
        this.set(v);
        return v;
    }

    default public void accumulate(float t, @NotNull FloatBinaryOperator accumulatorFunction) {
        this.getAndAccumulate(t, accumulatorFunction);
    }

    default public float getAndAccumulate(float t, @NotNull FloatBinaryOperator accumulatorFunction) {
        float v = this.get();
        this.set(accumulatorFunction.applyAsFloat(v, t));
        return v;
    }

    default public float accumulateAndGet(float t, @NotNull FloatBinaryOperator accumulatorFunction) {
        float v = accumulatorFunction.applyAsFloat(this.get(), t);
        this.set(v);
        return v;
    }
}

