/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.util.Objects;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import kala.value.primitive.AtomicIntVar;
import kala.value.primitive.DelegateMutableIntValue;
import kala.value.primitive.IntValue;
import kala.value.primitive.IntVar;
import kala.value.primitive.MutablePrimitiveValue;
import kala.value.primitive.VolatileIntVar;
import org.jetbrains.annotations.NotNull;

public interface MutableIntValue
extends MutablePrimitiveValue<Integer>,
IntValue,
IntConsumer {
    @NotNull
    public static MutableIntValue create() {
        return new IntVar();
    }

    @NotNull
    public static MutableIntValue create(int initialValue) {
        return new IntVar(initialValue);
    }

    @NotNull
    public static MutableIntValue createVolatile() {
        return new VolatileIntVar();
    }

    @NotNull
    public static MutableIntValue createVolatile(int initialValue) {
        return new VolatileIntVar(initialValue);
    }

    @NotNull
    public static MutableIntValue createAtomic() {
        return new AtomicIntVar();
    }

    @NotNull
    public static MutableIntValue createAtomic(int initialValue) {
        return new AtomicIntVar(initialValue);
    }

    @NotNull
    public static MutableIntValue by(@NotNull IntSupplier getter, @NotNull IntConsumer setter) {
        Objects.requireNonNull(getter);
        Objects.requireNonNull(setter);
        return new DelegateMutableIntValue(getter, setter);
    }

    public void set(int var1);

    @Override
    default public void setValue(@NotNull Integer value) {
        this.set(value);
    }

    @Override
    @Deprecated
    default public void accept(int value) {
        this.set(value);
    }

    @NotNull
    default public MutableIntValue withGetter(@NotNull IntSupplier newGetter) {
        Objects.requireNonNull(newGetter);
        return new DelegateMutableIntValue(newGetter, this);
    }

    @NotNull
    default public MutableIntValue withSetter(@NotNull IntConsumer newSetter) {
        Objects.requireNonNull(newSetter);
        return new DelegateMutableIntValue(this, newSetter);
    }

    @Override
    @Deprecated
    @NotNull
    default public MutableIntValue asMutable(@NotNull IntConsumer setter) {
        return this.withSetter(setter);
    }

    default public int getAndSet(int newValue) {
        int oldValue = this.get();
        this.set(newValue);
        return oldValue;
    }

    default public boolean compareAndSet(int expectedValue, int newValue) {
        if (this.get() == expectedValue) {
            this.set(newValue);
            return true;
        }
        return false;
    }

    default public void update(@NotNull IntUnaryOperator updateFunction) {
        this.getAndUpdate(updateFunction);
    }

    default public int getAndUpdate(@NotNull IntUnaryOperator updateFunction) {
        int v = this.get();
        this.set(updateFunction.applyAsInt(v));
        return v;
    }

    default public int updateAndGet(@NotNull IntUnaryOperator updateFunction) {
        int v = updateFunction.applyAsInt(this.get());
        this.set(v);
        return v;
    }

    default public void accumulate(int t, @NotNull IntBinaryOperator accumulatorFunction) {
        this.getAndAccumulate(t, accumulatorFunction);
    }

    default public int getAndAccumulate(int t, @NotNull IntBinaryOperator accumulatorFunction) {
        int v = this.get();
        this.set(accumulatorFunction.applyAsInt(v, t));
        return v;
    }

    default public int accumulateAndGet(int t, @NotNull IntBinaryOperator accumulatorFunction) {
        int v = accumulatorFunction.applyAsInt(this.get(), t);
        this.set(v);
        return v;
    }

    default public void increment() {
        this.set(this.get() + 1);
    }

    default public void decrement() {
        this.set(this.get() - 1);
    }

    default public void add(int delta) {
        this.set(this.get() + delta);
    }

    default public void sub(int delta) {
        this.set(this.get() - delta);
    }

    default public int getAndIncrement() {
        int v = this.get();
        this.increment();
        return v;
    }

    default public int getAndDecrement() {
        int v = this.get();
        this.decrement();
        return v;
    }

    default public int getAndAdd(int delta) {
        int v = this.get();
        this.add(delta);
        return v;
    }

    default public int getAndSub(int delta) {
        int v = this.get();
        this.sub(delta);
        return v;
    }

    default public int incrementAndGet() {
        this.increment();
        return this.get();
    }

    default public int decrementAndGet() {
        this.decrement();
        return this.get();
    }

    default public int addAndGet(int delta) {
        this.add(delta);
        return this.get();
    }

    default public int subAndGet(int delta) {
        this.sub(delta);
        return this.get();
    }
}

