/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import kala.collection.base.GenericArrays;
import kala.collection.base.Iterators;
import kala.collection.base.Traversable;
import kala.control.Option;
import kala.function.CheckedIndexedConsumer;
import kala.function.IndexedBiFunction;
import kala.function.IndexedConsumer;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OrderedTraversable<T>
extends Traversable<T> {
    @NotNull
    default public Iterator<T> iterator(int beginIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") < 0");
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0) {
            if (beginIndex > knownSize) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") > size(" + knownSize + ")");
            }
            if (beginIndex == knownSize) {
                return Iterators.empty();
            }
        }
        Iterator it = this.iterator();
        for (int i = 0; i < beginIndex; ++i) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException("beginIndex: " + beginIndex);
            }
            it.next();
        }
        return it;
    }

    @NotNull
    default public Iterator<T> reverseIterator() {
        ArrayList buffer;
        int ks = this.knownSize();
        if (ks == 0) {
            return Iterators.empty();
        }
        Iterator it = this.iterator();
        if (!it.hasNext()) {
            return Iterators.empty();
        }
        ArrayList<Object> arrayList = buffer = ks > 0 ? new ArrayList(ks) : new ArrayList();
        while (it.hasNext()) {
            buffer.add(it.next());
        }
        Iterator<Object> res = GenericArrays.reverseIterator(buffer.toArray());
        return res;
    }

    @Override
    @NotNull
    default public Option<T> find(@NotNull Predicate<? super T> predicate) {
        return this.findFirst(predicate);
    }

    @NotNull
    default public Option<T> findFirst(@NotNull Predicate<? super T> predicate) {
        return Iterators.firstOption(this.iterator(), predicate);
    }

    @NotNull
    default public Option<T> findLast(@NotNull Predicate<? super T> predicate) {
        return Iterators.firstOption(this.reverseIterator(), predicate);
    }

    @Override
    default public T getAny() {
        return this.getFirst();
    }

    default public T getFirst() {
        return this.iterator().next();
    }

    @Nullable
    default public T getFirstOrNull() {
        return this.isNotEmpty() ? (T)this.getFirst() : null;
    }

    @NotNull
    default public Option<T> getFirstOption() {
        return this.isNotEmpty() ? Option.some(this.getFirst()) : Option.none();
    }

    default public T getLast() {
        return this.reverseIterator().next();
    }

    @Nullable
    default public T getLastOrNull() {
        return this.isNotEmpty() ? (T)this.getLast() : null;
    }

    @NotNull
    default public Option<T> getLastOption() {
        return this.isNotEmpty() ? Option.some(this.getLast()) : Option.none();
    }

    @Contract(pure=true)
    default public int indexOf(Object value) {
        int idx = 0;
        if (value == null) {
            for (Object t : this) {
                if (null == t) {
                    return idx;
                }
                ++idx;
            }
        } else {
            for (Object t : this) {
                if (value.equals(t)) {
                    return idx;
                }
                ++idx;
            }
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexOf(Object value, int from) {
        int idx = 0;
        if (value == null) {
            for (Object t : this) {
                if (idx >= from && null == t) {
                    return idx;
                }
                ++idx;
            }
        } else {
            for (Object t : this) {
                if (idx >= from && value.equals(t)) {
                    return idx;
                }
                ++idx;
            }
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexWhere(@NotNull Predicate<? super T> predicate) {
        int idx = 0;
        for (Object t : this) {
            if (predicate.test(t)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexWhere(@NotNull Predicate<? super T> predicate, int from) {
        int idx = 0;
        for (Object t : this) {
            if (idx >= from && predicate.test(t)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexOf(Object value) {
        int idx = this.size() - 1;
        Iterator<T> it = this.reverseIterator();
        if (value == null) {
            while (it.hasNext()) {
                if (null == it.next()) {
                    return idx;
                }
                --idx;
            }
        } else {
            while (it.hasNext()) {
                if (value.equals(it.next())) {
                    return idx;
                }
                --idx;
            }
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexOf(Object value, int end) {
        int idx = this.size() - 1;
        Iterator<T> it = this.reverseIterator();
        if (value == null) {
            while (it.hasNext()) {
                if (idx <= end && null == it.next()) {
                    return idx;
                }
                --idx;
            }
        } else {
            while (it.hasNext()) {
                if (idx <= end && value.equals(it.next())) {
                    return idx;
                }
                --idx;
            }
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexWhere(@NotNull Predicate<? super T> predicate) {
        int idx = this.size() - 1;
        Iterator<T> it = this.reverseIterator();
        while (it.hasNext()) {
            if (predicate.test(it.next())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexWhere(@NotNull Predicate<? super T> predicate, int end) {
        int idx = this.size() - 1;
        Iterator<T> it = this.reverseIterator();
        while (it.hasNext()) {
            if (idx <= end && predicate.test(it.next())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    default public T foldIndexed(T zero, @NotNull IndexedBiFunction<? super T, ? super T, ? extends T> op) {
        return this.foldLeftIndexed(zero, op);
    }

    default public <U> U foldLeftIndexed(U zero, @NotNull IndexedBiFunction<? super U, ? super T, ? extends U> op) {
        return Iterators.foldLeftIndexed(this.iterator(), zero, op);
    }

    default public <U> U foldRightIndexed(U zero, @NotNull IndexedBiFunction<? super T, ? super U, ? extends U> op) {
        return Iterators.foldRightIndexed(this.iterator(), zero, op);
    }

    @Override
    default public T reduceRight(@NotNull BiFunction<? super T, ? super T, ? extends T> op) throws NoSuchElementException {
        Iterator<T> it = this.reverseIterator();
        if (!it.hasNext()) {
            throw new NoSuchElementException();
        }
        T t = it.next();
        while (it.hasNext()) {
            t = op.apply(it.next(), t);
        }
        return t;
    }

    @Override
    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(Object @NotNull [] dest, int destPos, int limit) {
        return this.copyToArray(0, dest, destPos, limit);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, Object @NotNull [] dest) {
        return this.copyToArray(srcPos, dest, 0, Integer.MAX_VALUE);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, Object @NotNull [] dest, int destPos) {
        return this.copyToArray(srcPos, dest, destPos, Integer.MAX_VALUE);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, Object @NotNull [] dest, int destPos, int limit) {
        Iterator<T> it;
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + srcPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        if (limit <= 0) {
            return 0;
        }
        int dl = dest.length;
        if (destPos > dl) {
            return 0;
        }
        int kn = this.knownSize();
        if (kn >= 0 && srcPos >= kn) {
            return 0;
        }
        int end = Math.min(dl - destPos, limit) + destPos;
        try {
            it = this.iterator(srcPos);
        }
        catch (IndexOutOfBoundsException ignored) {
            return 0;
        }
        int idx = destPos;
        while (it.hasNext() && idx < end) {
            dest[idx++] = it.next();
        }
        return idx - destPos;
    }

    default public void forEachIndexed(@NotNull IndexedConsumer<? super T> action) {
        int idx = 0;
        for (Object t : this) {
            action.accept(idx++, t);
        }
    }

    default public <Ex extends Throwable> void forEachIndexedChecked(@NotNull CheckedIndexedConsumer<? super T, ? extends Ex> action) throws Ex {
        this.forEachIndexed(action);
    }

    default public void forEachIndexedUnchecked(@NotNull CheckedIndexedConsumer<? super T, ?> action) {
        this.forEachIndexed(action);
    }
}

