/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.util.Objects;
import kala.Conditions;
import kala.collection.base.primitive.AbstractBooleanIterator;
import kala.collection.base.primitive.BooleanIterator;
import org.jetbrains.annotations.Range;

public final class BitArrays {
    public static final int BITS_PRE_VALUE = 64;
    public static final long FULL_BITS = -1L;

    private BitArrays() {
    }

    public static boolean get(long bits, @Range(from=0L, to=63L) int position) {
        return (bits >> position & 1L) != 0L;
    }

    public static long set(long bits, @Range(from=0L, to=63L) int position, boolean newValue) {
        if (newValue) {
            return bits | 1L << position;
        }
        return bits & -(1L << position);
    }

    public static boolean get(long[] bitsArray, int index) {
        return BitArrays.get(bitsArray[index / 64], index % 64);
    }

    public static void set(long[] bitsArray, int index, boolean newValue) {
        int i = index / 64;
        bitsArray[i] = BitArrays.set(bitsArray[i], index % 64, newValue);
    }

    public static BooleanIterator iterator(long bits, int beginIndex, int endIndex) {
        Conditions.checkPositionIndices(beginIndex, endIndex, 64);
        return new Itr(bits, beginIndex, endIndex);
    }

    public static BooleanIterator iterator(long[] bitsArray, int beginIndex, int endIndex) {
        Objects.requireNonNull(bitsArray);
        Conditions.checkPositionIndices(beginIndex, endIndex, bitsArray.length * 64);
        return new LargeItr(bitsArray, beginIndex, endIndex);
    }

    private static final class Itr
    extends AbstractBooleanIterator {
        private final long bits;
        private final int endIndex;
        private int index;

        Itr(long bits, int index, int endIndex) {
            this.bits = bits;
            this.endIndex = endIndex;
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.endIndex;
        }

        @Override
        public boolean nextBoolean() {
            this.checkStatus();
            return BitArrays.get(this.bits, this.index++);
        }
    }

    private static final class LargeItr
    extends AbstractBooleanIterator {
        private final int endIndex;
        private final long[] bitsArray;
        private long bits;
        private int index;

        LargeItr(long[] bitsArray, int index, int endIndex) {
            this.bitsArray = bitsArray;
            this.index = index;
            this.endIndex = endIndex;
            if (index % 64 != 0) {
                this.bits = bitsArray[index / 64];
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < this.endIndex;
        }

        @Override
        public boolean nextBoolean() {
            this.checkStatus();
            int position = this.index % 64;
            if (position == 0) {
                this.bits = this.bitsArray[this.index / 64];
            }
            ++this.index;
            return BitArrays.get(this.bits, position);
        }
    }
}

