/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import kala.collection.base.AbstractIterator;
import kala.collection.base.GenericArrays;
import kala.collection.base.Growable;
import kala.collection.base.Iterators;
import kala.collection.base.primitive.AbstractByteIterator;
import kala.collection.base.primitive.ByteArrays;
import kala.collection.base.primitive.ByteGrowable;
import kala.collection.base.primitive.ByteIterators;
import kala.collection.base.primitive.PrimitiveIterator;
import kala.control.primitive.ByteOption;
import kala.function.ByteBinaryOperator;
import kala.function.ByteConsumer;
import kala.function.ByteFunction;
import kala.function.ByteObjBiFunction;
import kala.function.BytePredicate;
import kala.function.ByteUnaryOperator;
import kala.function.ObjByteBiFunction;
import kala.internal.InternalByteArrayBuilder;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ByteIterator
extends PrimitiveIterator<Byte, ByteConsumer> {
    @NotNull
    public static ByteIterator empty() {
        return ByteIterators.EMPTY;
    }

    @NotNull
    public static ByteIterator of() {
        return ByteIterator.empty();
    }

    @NotNull
    public static ByteIterator of(final byte value) {
        return new ByteIterator(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public byte nextByte() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return value;
                }
                throw new NoSuchElementException();
            }

            public String toString() {
                if (this.hasNext) {
                    return "ByteIterator[" + value + "]";
                }
                return "ByteIterator[]";
            }
        };
    }

    @NotNull
    public static ByteIterator of(byte ... values) {
        return ByteArrays.iterator(values);
    }

    @NotNull
    public static ByteIterator ofIterator(final @NotNull @NotNull Iterator<? extends @NotNull Byte> it) {
        Objects.requireNonNull(it);
        if (it instanceof ByteIterator) {
            return (ByteIterator)it;
        }
        return new ByteIterator(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public byte nextByte() {
                return (Byte)it.next();
            }

            public String toString() {
                return it.toString();
            }
        };
    }

    @NotNull
    public static ByteIterator concat(@NotNull ByteIterator it1, @NotNull ByteIterator it2) {
        if (!it1.hasNext()) {
            return Objects.requireNonNull(it2);
        }
        if (!it2.hasNext()) {
            return it1;
        }
        return new ByteIterators.Concat(it1, it2);
    }

    @NotNull
    public static ByteIterator concat(ByteIterator ... its) {
        return switch (its.length) {
            case 0 -> ByteIterator.empty();
            case 1 -> Objects.requireNonNull(its[0]);
            case 2 -> ByteIterator.concat(its[0], its[1]);
            default -> new ByteIterators.ConcatAll(GenericArrays.iterator(its));
        };
    }

    @NotNull
    public static ByteIterator concat(@NotNull Iterable<? extends ByteIterator> its) {
        return ByteIterator.concat(its.iterator());
    }

    @NotNull
    public static ByteIterator concat(@NotNull Iterator<? extends ByteIterator> its) {
        if (!its.hasNext()) {
            return ByteIterator.empty();
        }
        return new ByteIterators.ConcatAll(its);
    }

    public byte nextByte();

    @Override
    default public void nextIgnoreResult() {
        this.nextByte();
    }

    @Override
    @Deprecated
    @NotNull
    default public Byte next() {
        return this.nextByte();
    }

    @NotNull
    default public ByteOption find(@NotNull BytePredicate predicate) {
        while (this.hasNext()) {
            byte value = this.nextByte();
            if (!predicate.test(value)) continue;
            return ByteOption.some(value);
        }
        return ByteOption.None;
    }

    default public boolean contains(byte value) {
        while (this.hasNext()) {
            if (value != this.nextByte()) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean contains(Object value) {
        if (!(value instanceof Byte)) {
            return false;
        }
        byte v = (Byte)value;
        while (this.hasNext()) {
            if (v != this.nextByte()) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAll(byte @NotNull [] values) {
        block0: while (this.hasNext()) {
            byte v = this.nextByte();
            for (byte i : values) {
                if (i == v) continue block0;
            }
            return false;
        }
        return true;
    }

    default public boolean sameElements(@NotNull ByteIterator other) {
        while (this.hasNext() && other.hasNext()) {
            if (this.nextByte() == other.nextByte()) continue;
            return false;
        }
        return this.hasNext() == other.hasNext();
    }

    @Override
    default public boolean sameElements(@NotNull Iterator<?> other) {
        if (other instanceof ByteIterator) {
            return this.sameElements((ByteIterator)other);
        }
        while (this.hasNext() && other.hasNext()) {
            Object value = other.next();
            if (!(value instanceof Byte)) {
                return false;
            }
            if (((Byte)value).byteValue() == this.nextByte()) continue;
            return false;
        }
        return this.hasNext() == other.hasNext();
    }

    default public boolean anyMatch(@NotNull BytePredicate predicate) {
        while (this.hasNext()) {
            if (!predicate.test(this.nextByte())) continue;
            return true;
        }
        return false;
    }

    default public boolean allMatch(@NotNull BytePredicate predicate) {
        while (this.hasNext()) {
            if (predicate.test(this.nextByte())) continue;
            return false;
        }
        return true;
    }

    default public boolean noneMatch(@NotNull BytePredicate predicate) {
        while (this.hasNext()) {
            if (!predicate.test(this.nextByte())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public ByteIterator drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        while (n > 0 && this.hasNext()) {
            this.nextByte();
            --n;
        }
        return this;
    }

    @NotNull
    default public ByteIterator dropWhile(@NotNull BytePredicate predicate) {
        if (!this.hasNext()) {
            return this;
        }
        byte value = 0;
        boolean p = false;
        while (this.hasNext()) {
            value = this.nextByte();
            if (predicate.test(value)) continue;
            p = true;
            break;
        }
        if (p) {
            return this.hasNext() ? this.prepended(value) : ByteIterator.of(value);
        }
        return this;
    }

    @NotNull
    default public ByteIterator take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (!this.hasNext() || n == 0) {
            return ByteIterator.empty();
        }
        return new ByteIterators.Take(this, n);
    }

    @NotNull
    default public ByteIterator takeWhile(@NotNull BytePredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return this;
        }
        return new ByteIterators.TakeWhile(this, predicate);
    }

    @NotNull
    default public ByteIterator updated(int n, byte newValue) {
        if (!this.hasNext() || n < 0) {
            return this;
        }
        if (n == 0) {
            this.nextByte();
            return this.prepended(newValue);
        }
        return new ByteIterators.Updated(this, n, newValue);
    }

    @NotNull
    default public ByteIterator prepended(byte value) {
        return new ByteIterators.Prepended(this, value);
    }

    @NotNull
    default public ByteIterator appended(byte value) {
        return new ByteIterators.Appended(this, value);
    }

    @NotNull
    default public ByteIterator filter(@NotNull BytePredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return ByteIterator.empty();
        }
        return new ByteIterators.Filter(this, predicate, false);
    }

    @NotNull
    default public ByteIterator filterNot(@NotNull BytePredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return ByteIterator.empty();
        }
        return new ByteIterators.Filter(this, predicate, true);
    }

    @NotNull
    default public ByteIterator map(final @NotNull ByteUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        if (!this.hasNext()) {
            return this;
        }
        return new AbstractByteIterator(){

            @Override
            public boolean hasNext() {
                return ByteIterator.this.hasNext();
            }

            @Override
            public byte nextByte() {
                return mapper.applyAsByte(ByteIterator.this.nextByte());
            }
        };
    }

    @NotNull
    default public <U> Iterator<U> mapToObj(final @NotNull ByteFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.hasNext()) {
            return Iterators.empty();
        }
        return new AbstractIterator<U>(){

            @Override
            public boolean hasNext() {
                return ByteIterator.this.hasNext();
            }

            @Override
            public U next() {
                return mapper.apply(ByteIterator.this.nextByte());
            }
        };
    }

    @NotNull
    default public @NotNull Tuple2<@NotNull ByteIterator, @NotNull ByteIterator> span(@NotNull BytePredicate predicate) {
        if (!this.hasNext()) {
            return Tuple.of(ByteIterator.empty(), ByteIterator.empty());
        }
        InternalByteArrayBuilder builder = new InternalByteArrayBuilder();
        ByteIterator it = this;
        while (it.hasNext()) {
            byte e = it.nextByte();
            if (predicate.test(e)) {
                builder.append(e);
                continue;
            }
            it = it.prepended(e);
            break;
        }
        return Tuple.of(builder.iterator(), it);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends ByteGrowable> G filterTo(@NotNull G destination, @NotNull BytePredicate predicate) {
        ByteIterator it = this;
        while (it.hasNext()) {
            byte e = it.nextByte();
            if (!predicate.test(e)) continue;
            destination.plusAssign(e);
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends ByteGrowable> G filterNotTo(@NotNull G destination, @NotNull BytePredicate predicate) {
        ByteIterator it = this;
        while (it.hasNext()) {
            byte e = it.nextByte();
            if (predicate.test(e)) continue;
            destination.plusAssign(e);
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends ByteGrowable> G mapTo(@NotNull G destination, @NotNull ByteUnaryOperator mapper) {
        ByteIterator it = this;
        while (it.hasNext()) {
            destination.plusAssign(mapper.applyAsByte(it.nextByte()));
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends Growable<? super U>> G mapToObjTo(@NotNull G destination, @NotNull ByteFunction<? extends U> mapper) {
        ByteIterator it = this;
        while (it.hasNext()) {
            destination.plusAssign(mapper.apply(it.nextByte()));
        }
        return destination;
    }

    default public int count(@NotNull BytePredicate predicate) {
        int c = 0;
        while (this.hasNext()) {
            if (!predicate.test(this.nextByte())) continue;
            ++c;
        }
        return c;
    }

    default public byte max() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        byte value = this.nextByte();
        while (this.hasNext()) {
            value = (byte)Math.max(value, this.nextByte());
        }
        return value;
    }

    @Override
    @Nullable
    default public Byte maxOrNull() {
        return this.hasNext() ? Byte.valueOf(this.max()) : null;
    }

    @NotNull
    default public ByteOption maxOption() {
        return this.hasNext() ? ByteOption.some(this.max()) : ByteOption.none();
    }

    default public byte min() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        byte value = this.nextByte();
        while (this.hasNext()) {
            value = (byte)Math.min(value, this.nextByte());
        }
        return value;
    }

    @Override
    @Nullable
    default public Byte minOrNull() {
        return this.hasNext() ? Byte.valueOf(this.min()) : null;
    }

    @NotNull
    default public ByteOption minOption() {
        return this.hasNext() ? ByteOption.some(this.min()) : ByteOption.none();
    }

    default public byte fold(byte zero, @NotNull ByteBinaryOperator op) {
        return this.foldLeft(zero, op);
    }

    default public byte foldLeft(byte zero, @NotNull ByteBinaryOperator op) {
        while (this.hasNext()) {
            zero = op.applyAsByte(zero, this.nextByte());
        }
        return zero;
    }

    default public <U> U foldLeftToObj(U zero, @NotNull ObjByteBiFunction<U, U> op) {
        while (this.hasNext()) {
            zero = op.apply(zero, this.nextByte());
        }
        return zero;
    }

    default public byte foldRight(byte zero, @NotNull ByteBinaryOperator op) {
        if (!this.hasNext()) {
            return zero;
        }
        InternalByteArrayBuilder builder = new InternalByteArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextByte());
        }
        for (int i = builder.size() - 1; i >= 0; --i) {
            zero = op.applyAsByte(builder.get(i), zero);
        }
        return zero;
    }

    default public <U> U foldRightToObj(U zero, @NotNull ByteObjBiFunction<U, U> op) {
        if (!this.hasNext()) {
            return zero;
        }
        InternalByteArrayBuilder builder = new InternalByteArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextByte());
        }
        for (int i = builder.size() - 1; i >= 0; --i) {
            zero = op.apply(builder.get(i), zero);
        }
        return zero;
    }

    default public byte reduce(@NotNull ByteBinaryOperator op) {
        return this.reduceLeft(op);
    }

    @Nullable
    default public Byte reduceOrNull(@NotNull ByteBinaryOperator op) {
        return this.reduceLeftOrNull(op);
    }

    @NotNull
    default public ByteOption reduceOption(@NotNull ByteBinaryOperator op) {
        return this.reduceLeftOption(op);
    }

    default public byte reduceLeft(@NotNull ByteBinaryOperator op) {
        byte e = this.nextByte();
        while (this.hasNext()) {
            e = op.applyAsByte(e, this.nextByte());
        }
        return e;
    }

    @Nullable
    default public Byte reduceLeftOrNull(@NotNull ByteBinaryOperator op) {
        return this.hasNext() ? Byte.valueOf(this.reduceLeft(op)) : null;
    }

    @NotNull
    default public ByteOption reduceLeftOption(@NotNull ByteBinaryOperator op) {
        return this.hasNext() ? ByteOption.some(this.reduceLeft(op)) : ByteOption.none();
    }

    default public byte reduceRight(@NotNull ByteBinaryOperator op) {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        InternalByteArrayBuilder list = new InternalByteArrayBuilder();
        list.append(this.nextByte());
        while (this.hasNext()) {
            list.append(this.nextByte());
        }
        int size = list.size();
        byte e = list.get(size - 1);
        for (int i = size - 2; i >= 0; --i) {
            e = op.applyAsByte(list.get(i), e);
        }
        return e;
    }

    @Nullable
    default public Byte reduceRightOrNull(@NotNull ByteBinaryOperator op) {
        return this.hasNext() ? Byte.valueOf(this.reduceRight(op)) : null;
    }

    @NotNull
    default public ByteOption reduceRightOption(@NotNull ByteBinaryOperator op) {
        return this.hasNext() ? ByteOption.some(this.reduceRight(op)) : ByteOption.none();
    }

    default public byte @NotNull [] toArray() {
        if (!this.hasNext()) {
            return ByteArrays.EMPTY;
        }
        InternalByteArrayBuilder builder = new InternalByteArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextByte());
        }
        return builder.toArray();
    }

    @Override
    default public void forEach(@NotNull ByteConsumer action) {
        while (this.hasNext()) {
            action.accept(this.nextByte());
        }
    }

    @Override
    default public void forEachRemaining(@NotNull Consumer<? super Byte> action) {
        if (action instanceof ByteConsumer) {
            this.forEach((ByteConsumer)((Object)action));
        } else {
            this.forEach(action::accept);
        }
    }

    @Override
    default public void forEachRemaining(@NotNull ByteConsumer action) {
        this.forEach(action);
    }

    @Override
    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        try {
            buffer.append(prefix);
            if (this.hasNext()) {
                buffer.append(String.valueOf(this.nextByte()));
            }
            while (this.hasNext()) {
                buffer.append(separator).append(String.valueOf(this.nextByte()));
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    @Override
    default public int hash() {
        int res = 0;
        while (this.hasNext()) {
            res = res * 31 + Byte.hashCode(this.nextByte());
        }
        return res;
    }
}

