/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kala.collection.base.primitive.AbstractByteIterator;
import kala.collection.base.primitive.ByteIterator;
import kala.function.BytePredicate;
import org.jetbrains.annotations.NotNull;

final class ByteIterators {
    static final ByteIterator EMPTY = new AbstractByteIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public byte nextByte() {
            throw new NoSuchElementException();
        }

        @Override
        public String toString() {
            return "ByteIterator[]";
        }
    };

    ByteIterators() {
    }

    static final class Filter
    extends AbstractByteIterator {
        @NotNull
        private final ByteIterator source;
        @NotNull
        private final BytePredicate predicate;
        private byte nextValue;
        private boolean flag = false;
        private final boolean isFlipped;

        Filter(@NotNull ByteIterator source, @NotNull BytePredicate predicate, boolean isFlipped) {
            this.source = source;
            this.predicate = predicate;
            this.isFlipped = isFlipped;
        }

        @Override
        public boolean hasNext() {
            if (this.flag) {
                return true;
            }
            if (!this.source.hasNext()) {
                return false;
            }
            byte v = this.source.nextByte();
            while (this.predicate.test(v) == this.isFlipped) {
                if (!this.source.hasNext()) {
                    return false;
                }
                v = this.source.nextByte();
            }
            this.nextValue = v;
            this.flag = true;
            return true;
        }

        @Override
        public byte nextByte() {
            this.checkStatus();
            this.flag = false;
            return this.nextValue;
        }
    }

    static final class Appended
    extends AbstractByteIterator {
        @NotNull
        private final ByteIterator source;
        private final byte value;
        private boolean flag = true;

        Appended(@NotNull ByteIterator source, byte value) {
            this.source = source;
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext() || this.flag;
        }

        @Override
        public byte nextByte() {
            if (this.source.hasNext()) {
                return this.source.nextByte();
            }
            if (this.flag) {
                this.flag = false;
                return this.value;
            }
            throw new NoSuchElementException();
        }
    }

    static final class Prepended
    extends AbstractByteIterator {
        @NotNull
        private final ByteIterator source;
        private final byte value;
        private boolean flag = true;

        Prepended(@NotNull ByteIterator source, byte value) {
            this.source = source;
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.flag || this.source.hasNext();
        }

        @Override
        public byte nextByte() {
            if (this.flag) {
                this.flag = false;
                return this.value;
            }
            return this.source.nextByte();
        }
    }

    static final class Updated
    extends AbstractByteIterator {
        @NotNull
        private final ByteIterator source;
        private final int n;
        private final byte newValue;
        private int idx = 0;

        Updated(@NotNull ByteIterator source, int n, byte newValue) {
            this.source = source;
            this.n = n;
            this.newValue = newValue;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public byte nextByte() {
            if (this.idx++ == this.n) {
                this.source.nextByte();
                return this.newValue;
            }
            return this.source.nextByte();
        }
    }

    static final class TakeWhile
    extends AbstractByteIterator {
        @NotNull
        private ByteIterator source;
        private BytePredicate predicate;
        private byte nextValue;
        private boolean tag = false;

        TakeWhile(@NotNull ByteIterator source, BytePredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @Override
        public boolean hasNext() {
            if (this.tag) {
                return true;
            }
            if (this.source.hasNext()) {
                this.nextValue = this.source.nextByte();
                byte v = this.nextValue;
                if (this.predicate.test(v)) {
                    this.tag = true;
                    return true;
                }
                this.source = EMPTY;
                this.predicate = null;
                return false;
            }
            return false;
        }

        @Override
        public byte nextByte() {
            this.checkStatus();
            this.tag = false;
            return this.nextValue;
        }
    }

    static final class Take
    extends AbstractByteIterator {
        private final ByteIterator source;
        private int n;

        Take(ByteIterator source, int n) {
            this.source = source;
            this.n = n;
        }

        @Override
        public boolean hasNext() {
            return this.n > 0 && this.source.hasNext();
        }

        @Override
        public byte nextByte() {
            this.checkStatus();
            --this.n;
            return this.source.nextByte();
        }
    }

    static final class ConcatAll
    extends AbstractByteIterator {
        @NotNull
        private final Iterator<? extends ByteIterator> iterators;
        private ByteIterator current = null;

        ConcatAll(@NotNull Iterator<? extends ByteIterator> iterators) {
            this.iterators = iterators;
        }

        @Override
        public boolean hasNext() {
            while ((this.current == null || !this.current.hasNext()) && this.iterators.hasNext()) {
                this.current = this.iterators.next();
            }
            return this.current != null && this.current.hasNext();
        }

        @Override
        public byte nextByte() {
            this.checkStatus();
            return this.current.nextByte();
        }
    }

    static final class Concat
    extends AbstractByteIterator {
        private ByteIterator it1;
        private ByteIterator it2;

        Concat(ByteIterator it1, ByteIterator it2) {
            this.it1 = it1;
            this.it2 = it2;
        }

        @Override
        public boolean hasNext() {
            if (this.it1 != null) {
                if (this.it1.hasNext()) {
                    return true;
                }
                this.it1 = null;
            }
            if (this.it2 != null) {
                if (this.it2.hasNext()) {
                    return true;
                }
                this.it2 = null;
            }
            return false;
        }

        @Override
        public byte nextByte() {
            this.checkStatus();
            if (this.it1 != null) {
                return this.it1.nextByte();
            }
            if (this.it2 != null) {
                return this.it2.nextByte();
            }
            throw new AssertionError();
        }
    }
}

