/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntFunction;
import kala.Conditions;
import kala.collection.base.primitive.AbstractCharIterator;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.control.primitive.CharOption;
import kala.function.CharBinaryOperator;
import kala.function.CharFunction;
import kala.function.CharObjBiFunction;
import kala.function.CharPredicate;
import kala.function.ObjCharBiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CharArrays {
    public static final char[] EMPTY = new char[0];
    private static final IntFunction<char[]> GENERATOR = char[]::new;

    private CharArrays() {
    }

    @Contract(pure=true)
    @NotNull
    public static IntFunction<char[]> generator() {
        return GENERATOR;
    }

    public static char @NotNull [] create(int length) {
        return new char[length];
    }

    @Contract(value="_ -> param1", pure=true)
    public static char @NotNull [] of(char ... values) {
        return values;
    }

    public static char @NotNull [] from(char @NotNull [] values) {
        return (char[])values.clone();
    }

    public static char @NotNull [] from(@NotNull CharTraversable values) {
        return values.toArray();
    }

    public static char @NotNull [] from(@NotNull CharIterator it) {
        return it.toArray();
    }

    @NotNull
    public static String className(char @NotNull [] array) {
        return "char[]";
    }

    @NotNull
    public static CharIterator iterator(char @NotNull [] array) {
        int arrayLength = array.length;
        switch (arrayLength) {
            case 0: {
                return CharIterator.empty();
            }
            case 1: {
                return CharIterator.of(array[0]);
            }
        }
        return new Itr(array, 0, arrayLength);
    }

    @NotNull
    public static CharIterator iterator(char @NotNull [] array, int beginIndex) {
        int arrayLength = array.length;
        Conditions.checkPositionIndex(beginIndex, arrayLength);
        switch (arrayLength - beginIndex) {
            case 0: {
                return CharIterator.empty();
            }
            case 1: {
                return CharIterator.of(array[beginIndex]);
            }
        }
        return new Itr(array, beginIndex, arrayLength);
    }

    @NotNull
    public static CharIterator iterator(char @NotNull [] array, int beginIndex, int endIndex) {
        int arrayLength = array.length;
        Conditions.checkPositionIndices(beginIndex, endIndex, arrayLength);
        switch (endIndex - beginIndex) {
            case 0: {
                return CharIterator.empty();
            }
            case 1: {
                return CharIterator.of(array[beginIndex]);
            }
        }
        return new Itr(array, beginIndex, endIndex);
    }

    public static boolean isEmpty(char @NotNull [] array) {
        return array.length == 0;
    }

    public static int size(char @NotNull [] array) {
        return array.length;
    }

    public static int knownSize(char @NotNull [] array) {
        return array.length;
    }

    public static boolean isDefineAt(char @NotNull [] array, int index) {
        return index >= 0 && index <= array.length;
    }

    public static char get(char @NotNull [] array, int index) {
        try {
            return array[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Nullable
    public static Character getOrNull(char @NotNull [] array, int index) {
        return index >= 0 && index <= array.length ? Character.valueOf(array[index]) : null;
    }

    @NotNull
    public static CharOption getOption(char @NotNull [] array, int index) {
        return index >= 0 && index <= array.length ? CharOption.some(array[index]) : CharOption.none();
    }

    public static void set(char @NotNull [] array, int index, char value) {
        try {
            array[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    public static char @NotNull [] reversed(char @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            return array;
        }
        char[] res = new char[length];
        for (int i = 0; i < length; ++i) {
            res[i] = array[length - i - 1];
        }
        return res;
    }

    @NotNull
    public static CharIterator reverseIterator(char @NotNull [] array) {
        int length = array.length;
        switch (length) {
            case 0: {
                return CharIterator.empty();
            }
            case 1: {
                return CharIterator.of(array[0]);
            }
        }
        return new ReverseItr(array, length - 1);
    }

    public static void shuffle(char @NotNull [] array) {
        CharArrays.shuffle(array, ThreadLocalRandom.current());
    }

    public static void shuffle(char @NotNull [] array, @NotNull Random random) {
        int size = array.length;
        if (size <= 1) {
            return;
        }
        for (int i = size; i > 1; --i) {
            int k = random.nextInt(i);
            char tmp = array[i - 1];
            array[i - 1] = array[k];
            array[k] = tmp;
        }
    }

    public static void sort(char @NotNull [] array) {
        Arrays.sort(array);
    }

    public static void sort(char @NotNull [] array, int beginIndex, int endIndex) {
        Arrays.sort(array, beginIndex, endIndex);
    }

    @NotNull
    public static CharOption find(char @NotNull [] array, @NotNull CharPredicate predicate) {
        for (char e : array) {
            if (!predicate.test(e)) continue;
            return CharOption.some(e);
        }
        return CharOption.none();
    }

    public static char first(char @NotNull [] array) {
        try {
            return array[0];
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            throw new NoSuchElementException();
        }
    }

    public static char last(char @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        return array[length - 1];
    }

    public static boolean contains(char @NotNull [] array, char value) {
        for (char o : array) {
            if (value != o) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(char @NotNull [] array, char @NotNull [] values) {
        for (char value : values) {
            if (CharArrays.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(char @NotNull [] array, @NotNull CharTraversable values) {
        CharIterator it = values.iterator();
        while (it.hasNext()) {
            char value = it.nextChar();
            if (CharArrays.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean anyMatch(char @NotNull [] array, @NotNull CharPredicate predicate) {
        for (char e : array) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    public static boolean allMatch(char @NotNull [] array, @NotNull CharPredicate predicate) {
        for (char e : array) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public static boolean noneMatch(char @NotNull [] array, @NotNull CharPredicate predicate) {
        for (char e : array) {
            if (!predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int indexOf(char @NotNull [] array, char value) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(char @NotNull [] array, char value, int beginIndex) {
        int length = array.length;
        if (beginIndex >= length) {
            return -1;
        }
        for (int i = Math.max(beginIndex, 0); i < length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexWhere(char @NotNull [] array, @NotNull CharPredicate predicate) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexWhere(char @NotNull [] array, @NotNull CharPredicate predicate, int beginIndex) {
        int length = array.length;
        if (beginIndex >= length) {
            return -1;
        }
        for (int i = Math.max(beginIndex, 0); i < length; ++i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOf(char @NotNull [] array, char value) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOf(char @NotNull [] array, char value, int endIndex) {
        if (endIndex < 0) {
            return -1;
        }
        for (int i = endIndex; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexWhere(char @NotNull [] array, @NotNull CharPredicate predicate) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexWhere(char @NotNull [] array, @NotNull CharPredicate predicate, int endIndex) {
        if (endIndex < 0) {
            return -1;
        }
        for (int i = endIndex; i >= 0; --i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static char max(char @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        char e = array[0];
        for (int i = 1; i < length; ++i) {
            char v = array[i];
            if (Character.compare(e, v) >= 0) continue;
            e = v;
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Character maxOrNull(char @NotNull [] array) {
        return array.length != 0 ? Character.valueOf(CharArrays.max(array)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static CharOption maxOption(char @NotNull [] array) {
        return array.length != 0 ? CharOption.some(CharArrays.max(array)) : CharOption.none();
    }

    @Contract(pure=true)
    public static char min(char @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        char e = array[0];
        for (int i = 1; i < length; ++i) {
            char v = array[i];
            if (Character.compare(e, v) <= 0) continue;
            e = v;
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Character minOrNull(char @NotNull [] array) {
        return array.length != 0 ? Character.valueOf(CharArrays.min(array)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static CharOption minOption(char @NotNull [] array) {
        return array.length != 0 ? CharOption.some(CharArrays.min(array)) : CharOption.none();
    }

    @Contract(pure=true)
    public static char fold(char @NotNull [] array, char zero, @NotNull CharBinaryOperator op) {
        return CharArrays.foldLeft(array, zero, op);
    }

    @Contract(pure=true)
    public static char foldLeft(char @NotNull [] array, char zero, @NotNull CharBinaryOperator op) {
        for (char e : array) {
            zero = op.applyAsChar(zero, e);
        }
        return zero;
    }

    @Contract(pure=true)
    public static <U> U foldLeftToObj(char @NotNull [] array, U zero, @NotNull ObjCharBiFunction<U, U> op) {
        for (char e : array) {
            zero = op.apply(zero, e);
        }
        return zero;
    }

    @Contract(pure=true)
    public static char foldRight(char @NotNull [] array, char zero, @NotNull CharBinaryOperator op) {
        for (int i = array.length - 1; i >= 0; --i) {
            zero = op.applyAsChar(array[i], zero);
        }
        return zero;
    }

    public static <U> U foldRightToObj(char @NotNull [] array, U zero, @NotNull CharObjBiFunction<U, U> op) {
        for (int i = array.length - 1; i >= 0; --i) {
            zero = op.apply(array[i], zero);
        }
        return zero;
    }

    @Contract(pure=true)
    public static char reduce(char @NotNull [] array, @NotNull CharBinaryOperator op) {
        return CharArrays.reduceLeft(array, op);
    }

    @Contract(pure=true)
    @NotNull
    public static CharOption reduceOption(char @NotNull [] array, @NotNull CharBinaryOperator op) {
        return CharArrays.reduceLeftOption(array, op);
    }

    @Contract(pure=true)
    public static char reduceLeft(char @NotNull [] array, @NotNull CharBinaryOperator op) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        char e = array[0];
        for (int i = 1; i < length; ++i) {
            e = op.applyAsChar(e, array[i]);
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Character reduceLeftOrNull(char @NotNull [] array, @NotNull CharBinaryOperator op) {
        return array.length != 0 ? Character.valueOf(CharArrays.reduceLeft(array, op)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static CharOption reduceLeftOption(char @NotNull [] array, @NotNull CharBinaryOperator op) {
        return array.length != 0 ? CharOption.some(CharArrays.reduceLeft(array, op)) : CharOption.none();
    }

    @Contract(pure=true)
    public static char reduceRight(char @NotNull [] array, @NotNull CharBinaryOperator op) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        char e = array[length - 1];
        for (int i = length - 2; i >= 0; --i) {
            e = op.applyAsChar(array[i], e);
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Character reduceRightOrNull(char @NotNull [] array, @NotNull CharBinaryOperator op) {
        return array.length != 0 ? Character.valueOf(CharArrays.reduceRight(array, op)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static CharOption reduceRightOption(char @NotNull [] array, @NotNull CharBinaryOperator op) {
        return array.length != 0 ? CharOption.some(CharArrays.reduceRight(array, op)) : CharOption.none();
    }

    @NotNull
    public static <A extends Appendable> A joinTo(char @NotNull [] array, @NotNull A buffer) {
        return CharArrays.joinTo(array, buffer, ", ", "", "");
    }

    @NotNull
    public static <A extends Appendable> A joinTo(char @NotNull [] array, @NotNull A buffer, CharSequence separator) {
        return CharArrays.joinTo(array, buffer, separator, "", "");
    }

    @NotNull
    public static <A extends Appendable> A joinTo(char @NotNull [] array, @NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        int length = array.length;
        try {
            if (length == 0) {
                buffer.append(prefix).append(postfix);
                return buffer;
            }
            buffer.append(prefix).append(String.valueOf(array[0]));
            for (int i = 1; i < length; ++i) {
                buffer.append(separator);
                buffer.append(Objects.toString(Character.valueOf(array[i])));
            }
            buffer.append(postfix);
            return buffer;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public static <A extends Appendable> A joinTo(char @NotNull [] array, @NotNull A buffer, @NotNull CharFunction<? extends CharSequence> transform) {
        return CharArrays.joinTo(array, buffer, ", ", "", "", transform);
    }

    @NotNull
    public static <A extends Appendable> A joinTo(char @NotNull [] array, @NotNull A buffer, CharSequence separator, @NotNull CharFunction<? extends CharSequence> transform) {
        return CharArrays.joinTo(array, buffer, separator, "", "", transform);
    }

    @NotNull
    public static <A extends Appendable> A joinTo(char @NotNull [] array, @NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull CharFunction<? extends CharSequence> transform) {
        int length = array.length;
        try {
            if (length == 0) {
                buffer.append(prefix).append(postfix);
                return buffer;
            }
            buffer.append(prefix).append(transform.apply(array[0]));
            for (int i = 1; i < length; ++i) {
                buffer.append(separator);
                buffer.append(transform.apply(array[i]));
            }
            buffer.append(postfix);
            return buffer;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public static String joinToString(char @NotNull [] array) {
        return CharArrays.joinTo(array, new StringBuilder()).toString();
    }

    @NotNull
    public static String joinToString(char @NotNull [] array, CharSequence separator) {
        return CharArrays.joinTo(array, new StringBuilder(), separator).toString();
    }

    @NotNull
    public static String joinToString(char @NotNull [] array, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return CharArrays.joinTo(array, new StringBuilder(), separator, prefix, postfix).toString();
    }

    @NotNull
    public static String joinToString(char @NotNull [] array, @NotNull CharFunction<? extends CharSequence> transform) {
        return CharArrays.joinTo(array, new StringBuilder(), transform).toString();
    }

    @NotNull
    public static String joinToString(char @NotNull [] array, CharSequence separator, @NotNull CharFunction<? extends CharSequence> transform) {
        return CharArrays.joinTo(array, new StringBuilder(), separator, transform).toString();
    }

    @NotNull
    public static String joinToString(char @NotNull [] array, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull CharFunction<? extends CharSequence> transform) {
        return CharArrays.joinTo(array, new StringBuilder(), separator, prefix, postfix, transform).toString();
    }

    private static final class Itr
    extends AbstractCharIterator {
        private final char @NotNull [] array;
        private final int endIndex;
        private int index;

        Itr(char @NotNull [] array, int beginIndex, int endIndex) {
            this.array = array;
            this.index = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.endIndex;
        }

        @Override
        public char nextChar() {
            if (this.index >= this.endIndex) {
                throw new NoSuchElementException(String.valueOf(this) + ".next()");
            }
            return this.array[this.index++];
        }
    }

    private static final class ReverseItr
    extends AbstractCharIterator {
        private final char @NotNull [] array;
        private int index;

        ReverseItr(char @NotNull [] array, int index) {
            this.array = array;
            this.index = index;
        }

        ReverseItr(char @NotNull [] array) {
            this(array, array.length - 1);
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public char nextChar() {
            try {
                return this.array[this.index--];
            }
            catch (ArrayIndexOutOfBoundsException ignored) {
                throw new NoSuchElementException();
            }
        }
    }
}

