/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.base.Growable;
import kala.collection.base.primitive.CharArrays;
import kala.collection.base.primitive.CharGrowable;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.PrimitiveTraversable;
import kala.collection.factory.primitive.CharCollectionFactory;
import kala.control.primitive.CharOption;
import kala.function.CharBinaryOperator;
import kala.function.CharConsumer;
import kala.function.CharFunction;
import kala.function.CharObjBiFunction;
import kala.function.CharPredicate;
import kala.function.CharUnaryOperator;
import kala.function.CheckedCharConsumer;
import kala.function.ObjCharBiFunction;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CharTraversable
extends PrimitiveTraversable<Character> {
    @Override
    @NotNull
    public CharIterator iterator();

    default public char elementAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0 && index >= knownSize) {
            throw new IndexOutOfBoundsException();
        }
        CharIterator it = this.iterator();
        for (int i = 0; i < index; ++i) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            it.nextChar();
        }
        if (it.hasNext()) {
            return it.nextChar();
        }
        throw new IndexOutOfBoundsException("index: " + index);
    }

    @NotNull
    default public CharOption find(@NotNull CharPredicate predicate) {
        return this.iterator().find(predicate);
    }

    default public boolean contains(char value) {
        return this.knownSize() != 0 && this.iterator().contains(value);
    }

    default public boolean containsAll(char @NotNull [] values) {
        return this.iterator().containsAll(values);
    }

    default public boolean containsAll(@NotNull CharTraversable values) {
        CharIterator it = values.iterator();
        if (this.knownSize() == 0) {
            return !it.hasNext();
        }
        while (it.hasNext()) {
            if (this.contains(it.nextChar())) continue;
            return false;
        }
        return true;
    }

    default public boolean sameElements(@NotNull CharTraversable other) {
        return this.iterator().sameElements(other.iterator());
    }

    default public boolean sameElements(@NotNull Iterable<?> other) {
        return this.iterator().sameElements(other.iterator());
    }

    default public boolean anyMatch(@NotNull CharPredicate predicate) {
        return this.iterator().anyMatch(predicate);
    }

    default public boolean allMatch(@NotNull CharPredicate predicate) {
        return this.iterator().allMatch(predicate);
    }

    default public boolean noneMatch(@NotNull CharPredicate predicate) {
        return this.iterator().noneMatch(predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends CharGrowable> G filterTo(@NotNull G destination, @NotNull CharPredicate predicate) {
        return this.iterator().filterTo(destination, predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends CharGrowable> G filterNotTo(@NotNull G destination, @NotNull CharPredicate predicate) {
        return this.iterator().filterNotTo(destination, predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends CharGrowable> G mapTo(@NotNull G destination, @NotNull CharUnaryOperator mapper) {
        return this.iterator().mapTo(destination, mapper);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends Growable<? super U>> G mapToObjTo(@NotNull G destination, @NotNull CharFunction<? extends U> mapper) {
        return this.iterator().mapToObjTo(destination, mapper);
    }

    default public int count(@NotNull CharPredicate predicate) {
        return this.iterator().count(predicate);
    }

    default public char max() {
        if (this.knownSize() == 0) {
            throw new NoSuchElementException();
        }
        return this.iterator().max();
    }

    @Override
    @Nullable
    default public Character maxOrNull() {
        return this.isNotEmpty() ? Character.valueOf(this.max()) : null;
    }

    @NotNull
    default public CharOption maxOption() {
        return this.knownSize() == 0 ? CharOption.none() : this.iterator().maxOption();
    }

    default public char min() {
        if (this.knownSize() == 0) {
            throw new NoSuchElementException();
        }
        return this.iterator().min();
    }

    @Override
    @Nullable
    default public Character minOrNull() {
        return this.knownSize() == 0 ? null : this.iterator().minOrNull();
    }

    @NotNull
    default public CharOption minOption() {
        return this.knownSize() == 0 ? CharOption.none() : this.iterator().minOption();
    }

    default public char fold(char zero, @NotNull CharBinaryOperator op) {
        return this.foldLeft(zero, op);
    }

    default public char foldLeft(char zero, @NotNull CharBinaryOperator op) {
        return this.iterator().foldLeft(zero, op);
    }

    default public <U> U foldLeftToObj(U zero, @NotNull ObjCharBiFunction<U, U> op) {
        return this.iterator().foldLeftToObj(zero, op);
    }

    default public char foldRight(char zero, @NotNull CharBinaryOperator op) {
        return this.iterator().foldRight(zero, op);
    }

    default public <U> U foldRightToObj(U zero, @NotNull CharObjBiFunction<U, U> op) {
        return this.iterator().foldRightToObj(zero, op);
    }

    default public char reduce(@NotNull CharBinaryOperator op) {
        return this.reduceLeft(op);
    }

    @Nullable
    default public Character reduceOrNull(@NotNull CharBinaryOperator op) {
        return this.reduceLeftOrNull(op);
    }

    @NotNull
    default public CharOption reduceOption(@NotNull CharBinaryOperator op) {
        return this.reduceLeftOption(op);
    }

    default public char reduceLeft(@NotNull CharBinaryOperator op) {
        return this.iterator().reduceLeft(op);
    }

    @Nullable
    default public Character reduceLeftOrNull(@NotNull CharBinaryOperator op) {
        return this.isNotEmpty() ? Character.valueOf(this.reduceLeft(op)) : null;
    }

    @NotNull
    default public CharOption reduceLeftOption(@NotNull CharBinaryOperator op) {
        return this.isNotEmpty() ? CharOption.some(this.reduceLeft(op)) : CharOption.none();
    }

    default public char reduceRight(@NotNull CharBinaryOperator op) {
        return this.iterator().reduceRight(op);
    }

    @Nullable
    default public Character reduceRightOrNull(@NotNull CharBinaryOperator op) {
        return this.isNotEmpty() ? Character.valueOf(this.reduceRight(op)) : null;
    }

    @NotNull
    default public CharOption reduceRightOption(@NotNull CharBinaryOperator op) {
        return this.isNotEmpty() ? CharOption.some(this.reduceRight(op)) : CharOption.none();
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(char @NotNull [] dest) {
        return this.copyToArray(0, dest, 0, Integer.MAX_VALUE);
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(char @NotNull [] dest, int destPos) {
        return this.copyToArray(0, dest, destPos, Integer.MAX_VALUE);
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(char @NotNull [] dest, int destPos, int limit) {
        return this.copyToArray(0, dest, destPos, limit);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, char @NotNull [] dest) {
        return this.copyToArray(srcPos, dest, 0, Integer.MAX_VALUE);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, char @NotNull [] dest, int destPos) {
        return this.copyToArray(srcPos, dest, destPos, Integer.MAX_VALUE);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, char @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + srcPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        if (limit <= 0) {
            return 0;
        }
        int dl = dest.length;
        if (destPos > dl) {
            return 0;
        }
        int kn = this.knownSize();
        if (kn >= 0 && srcPos >= kn) {
            return 0;
        }
        int end = Math.min(dl - destPos, limit) + destPos;
        int n = 0;
        CharIterator it = this.iterator();
        while (n++ < srcPos) {
            if (it.hasNext()) {
                it.nextChar();
                continue;
            }
            return 0;
        }
        int idx = destPos;
        while (it.hasNext() && idx < end) {
            dest[idx++] = it.nextChar();
        }
        return idx - destPos;
    }

    @Override
    default public <R, Builder> R collect(@NotNull CharCollectionFactory<Builder, ? extends R> factory) {
        return CharCollectionFactory.buildBy(factory, this::forEach);
    }

    @Override
    @NotNull
    default public <G extends CharGrowable> G collect(@NotNull G destination) {
        destination.plusAssign(this);
        return destination;
    }

    default public char @NotNull [] toArray() {
        int s = this.knownSize();
        if (s == 0) {
            return CharArrays.EMPTY;
        }
        if (s > 0) {
            char[] arr = new char[s];
            int i = 0;
            CharIterator iterator = this.iterator();
            while (iterator.hasNext()) {
                char t = iterator.nextChar();
                arr[i++] = t;
            }
            return arr;
        }
        return this.iterator().toArray();
    }

    default public void forEach(@NotNull CharConsumer action) {
        this.iterator().forEach(action);
    }

    default public <Ex extends Throwable> void forEachChecked(@NotNull CheckedCharConsumer<Ex> action) throws Ex {
        this.forEach(action);
    }

    default public void forEachUnchecked(@NotNull CheckedCharConsumer<?> action) {
        this.forEach(action);
    }

    default public void forEachBreakable(@NotNull CharPredicate action) {
        Objects.requireNonNull(action);
        CharIterator it = this.iterator();
        while (it.hasNext() && action.test(it.nextChar())) {
        }
    }
}

