/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.Spliterator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.IntFunction;
import java.util.stream.DoubleStream;
import kala.Conditions;
import kala.collection.base.primitive.AbstractDoubleIterator;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.base.primitive.DoubleTraversable;
import kala.control.primitive.DoubleOption;
import kala.function.DoubleObjBiFunction;
import kala.function.ObjDoubleBiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DoubleArrays {
    public static final double[] EMPTY = new double[0];
    private static final IntFunction<double[]> GENERATOR = double[]::new;

    private DoubleArrays() {
    }

    @Contract(pure=true)
    @NotNull
    public static IntFunction<double[]> generator() {
        return GENERATOR;
    }

    public static double @NotNull [] create(int length) {
        return new double[length];
    }

    @Contract(value="_ -> param1", pure=true)
    public static double @NotNull [] of(double ... values) {
        return values;
    }

    public static double @NotNull [] from(double @NotNull [] values) {
        return (double[])values.clone();
    }

    public static double @NotNull [] from(@NotNull DoubleTraversable values) {
        return values.toArray();
    }

    public static double @NotNull [] from(@NotNull DoubleIterator it) {
        return it.toArray();
    }

    public static double @NotNull [] from(@NotNull DoubleStream stream) {
        return stream.toArray();
    }

    @NotNull
    public static String className(double @NotNull [] array) {
        return "double[]";
    }

    @NotNull
    public static DoubleIterator iterator(double @NotNull [] array) {
        int arrayLength = array.length;
        switch (arrayLength) {
            case 0: {
                return DoubleIterator.empty();
            }
            case 1: {
                return DoubleIterator.of(array[0]);
            }
        }
        return new Itr(array, 0, arrayLength);
    }

    @NotNull
    public static DoubleIterator iterator(double @NotNull [] array, int beginIndex) {
        int arrayLength = array.length;
        Conditions.checkPositionIndex(beginIndex, arrayLength);
        switch (arrayLength - beginIndex) {
            case 0: {
                return DoubleIterator.empty();
            }
            case 1: {
                return DoubleIterator.of(array[beginIndex]);
            }
        }
        return new Itr(array, beginIndex, arrayLength);
    }

    @NotNull
    public static DoubleIterator iterator(double @NotNull [] array, int beginIndex, int endIndex) {
        int arrayLength = array.length;
        Conditions.checkPositionIndices(beginIndex, endIndex, arrayLength);
        switch (endIndex - beginIndex) {
            case 0: {
                return DoubleIterator.empty();
            }
            case 1: {
                return DoubleIterator.of(array[beginIndex]);
            }
        }
        return new Itr(array, beginIndex, endIndex);
    }

    @NotNull
    public static Spliterator.OfDouble spliterator(double @NotNull [] array) {
        return Arrays.spliterator(array);
    }

    @NotNull
    public static DoubleStream stream(double @NotNull [] array) {
        return Arrays.stream(array);
    }

    @NotNull
    public static DoubleStream parallelStream(double @NotNull [] array) {
        return Arrays.stream(array).parallel();
    }

    public static boolean isEmpty(double @NotNull [] array) {
        return array.length == 0;
    }

    public static int size(double @NotNull [] array) {
        return array.length;
    }

    public static int knownSize(double @NotNull [] array) {
        return array.length;
    }

    public static boolean isDefineAt(double @NotNull [] array, int index) {
        return index >= 0 && index <= array.length;
    }

    public static double get(double @NotNull [] array, int index) {
        try {
            return array[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Nullable
    public static Double getOrNull(double @NotNull [] array, int index) {
        return index >= 0 && index <= array.length ? Double.valueOf(array[index]) : null;
    }

    @NotNull
    public static DoubleOption getOption(double @NotNull [] array, int index) {
        return index >= 0 && index <= array.length ? DoubleOption.some(array[index]) : DoubleOption.none();
    }

    public static void set(double @NotNull [] array, int index, double value) {
        try {
            array[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    public static double @NotNull [] reversed(double @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            return array;
        }
        double[] res = new double[length];
        for (int i = 0; i < length; ++i) {
            res[i] = array[length - i - 1];
        }
        return res;
    }

    @NotNull
    public static DoubleIterator reverseIterator(double @NotNull [] array) {
        int length = array.length;
        switch (length) {
            case 0: {
                return DoubleIterator.empty();
            }
            case 1: {
                return DoubleIterator.of(array[0]);
            }
        }
        return new ReverseItr(array, length - 1);
    }

    public static void shuffle(double @NotNull [] array) {
        DoubleArrays.shuffle(array, ThreadLocalRandom.current());
    }

    public static void shuffle(double @NotNull [] array, @NotNull Random random) {
        int size = array.length;
        if (size <= 1) {
            return;
        }
        for (int i = size; i > 1; --i) {
            int k = random.nextInt(i);
            double tmp = array[i - 1];
            array[i - 1] = array[k];
            array[k] = tmp;
        }
    }

    public static void sort(double @NotNull [] array) {
        Arrays.sort(array);
    }

    public static void sort(double @NotNull [] array, int beginIndex, int endIndex) {
        Arrays.sort(array, beginIndex, endIndex);
    }

    @NotNull
    public static DoubleOption find(double @NotNull [] array, @NotNull DoublePredicate predicate) {
        for (double e : array) {
            if (!predicate.test(e)) continue;
            return DoubleOption.some(e);
        }
        return DoubleOption.none();
    }

    public static double first(double @NotNull [] array) {
        try {
            return array[0];
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            throw new NoSuchElementException();
        }
    }

    public static double last(double @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        return array[length - 1];
    }

    public static boolean contains(double @NotNull [] array, double value) {
        for (double o : array) {
            if (Double.doubleToLongBits(value) != Double.doubleToLongBits(o)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(double @NotNull [] array, double @NotNull [] values) {
        for (double value : values) {
            if (DoubleArrays.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(double @NotNull [] array, @NotNull DoubleTraversable values) {
        DoubleIterator it = values.iterator();
        while (it.hasNext()) {
            double value = it.nextDouble();
            if (DoubleArrays.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean anyMatch(double @NotNull [] array, @NotNull DoublePredicate predicate) {
        for (double e : array) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    public static boolean allMatch(double @NotNull [] array, @NotNull DoublePredicate predicate) {
        for (double e : array) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public static boolean noneMatch(double @NotNull [] array, @NotNull DoublePredicate predicate) {
        for (double e : array) {
            if (!predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int indexOf(double @NotNull [] array, double value) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (Double.doubleToLongBits(value) != Double.doubleToLongBits(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(double @NotNull [] array, double value, int beginIndex) {
        int length = array.length;
        if (beginIndex >= length) {
            return -1;
        }
        for (int i = Math.max(beginIndex, 0); i < length; ++i) {
            if (Double.doubleToLongBits(value) != Double.doubleToLongBits(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexWhere(double @NotNull [] array, @NotNull DoublePredicate predicate) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexWhere(double @NotNull [] array, @NotNull DoublePredicate predicate, int beginIndex) {
        int length = array.length;
        if (beginIndex >= length) {
            return -1;
        }
        for (int i = Math.max(beginIndex, 0); i < length; ++i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOf(double @NotNull [] array, double value) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (Double.doubleToLongBits(value) != Double.doubleToLongBits(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOf(double @NotNull [] array, double value, int endIndex) {
        if (endIndex < 0) {
            return -1;
        }
        for (int i = endIndex; i >= 0; --i) {
            if (Double.doubleToLongBits(value) != Double.doubleToLongBits(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexWhere(double @NotNull [] array, @NotNull DoublePredicate predicate) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexWhere(double @NotNull [] array, @NotNull DoublePredicate predicate, int endIndex) {
        if (endIndex < 0) {
            return -1;
        }
        for (int i = endIndex; i >= 0; --i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static double max(double @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        double e = array[0];
        for (int i = 1; i < length; ++i) {
            double v = array[i];
            if (Double.compare(e, v) >= 0) continue;
            e = v;
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Double maxOrNull(double @NotNull [] array) {
        return array.length != 0 ? Double.valueOf(DoubleArrays.max(array)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static DoubleOption maxOption(double @NotNull [] array) {
        return array.length != 0 ? DoubleOption.some(DoubleArrays.max(array)) : DoubleOption.none();
    }

    @Contract(pure=true)
    public static double min(double @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        double e = array[0];
        for (int i = 1; i < length; ++i) {
            double v = array[i];
            if (Double.compare(e, v) <= 0) continue;
            e = v;
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Double minOrNull(double @NotNull [] array) {
        return array.length != 0 ? Double.valueOf(DoubleArrays.min(array)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static DoubleOption minOption(double @NotNull [] array) {
        return array.length != 0 ? DoubleOption.some(DoubleArrays.min(array)) : DoubleOption.none();
    }

    @Contract(pure=true)
    public static double fold(double @NotNull [] array, double zero, @NotNull DoubleBinaryOperator op) {
        return DoubleArrays.foldLeft(array, zero, op);
    }

    @Contract(pure=true)
    public static double foldLeft(double @NotNull [] array, double zero, @NotNull DoubleBinaryOperator op) {
        for (double e : array) {
            zero = op.applyAsDouble(zero, e);
        }
        return zero;
    }

    @Contract(pure=true)
    public static <U> U foldLeftToObj(double @NotNull [] array, U zero, @NotNull ObjDoubleBiFunction<U, U> op) {
        for (double e : array) {
            zero = op.apply(zero, e);
        }
        return zero;
    }

    @Contract(pure=true)
    public static double foldRight(double @NotNull [] array, double zero, @NotNull DoubleBinaryOperator op) {
        for (int i = array.length - 1; i >= 0; --i) {
            zero = op.applyAsDouble(array[i], zero);
        }
        return zero;
    }

    public static <U> U foldRightToObj(double @NotNull [] array, U zero, @NotNull DoubleObjBiFunction<U, U> op) {
        for (int i = array.length - 1; i >= 0; --i) {
            zero = op.apply(array[i], zero);
        }
        return zero;
    }

    @Contract(pure=true)
    public static double reduce(double @NotNull [] array, @NotNull DoubleBinaryOperator op) {
        return DoubleArrays.reduceLeft(array, op);
    }

    @Contract(pure=true)
    @NotNull
    public static DoubleOption reduceOption(double @NotNull [] array, @NotNull DoubleBinaryOperator op) {
        return DoubleArrays.reduceLeftOption(array, op);
    }

    @Contract(pure=true)
    public static double reduceLeft(double @NotNull [] array, @NotNull DoubleBinaryOperator op) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        double e = array[0];
        for (int i = 1; i < length; ++i) {
            e = op.applyAsDouble(e, array[i]);
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Double reduceLeftOrNull(double @NotNull [] array, @NotNull DoubleBinaryOperator op) {
        return array.length != 0 ? Double.valueOf(DoubleArrays.reduceLeft(array, op)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static DoubleOption reduceLeftOption(double @NotNull [] array, @NotNull DoubleBinaryOperator op) {
        return array.length != 0 ? DoubleOption.some(DoubleArrays.reduceLeft(array, op)) : DoubleOption.none();
    }

    @Contract(pure=true)
    public static double reduceRight(double @NotNull [] array, @NotNull DoubleBinaryOperator op) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        double e = array[length - 1];
        for (int i = length - 2; i >= 0; --i) {
            e = op.applyAsDouble(array[i], e);
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Double reduceRightOrNull(double @NotNull [] array, @NotNull DoubleBinaryOperator op) {
        return array.length != 0 ? Double.valueOf(DoubleArrays.reduceRight(array, op)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static DoubleOption reduceRightOption(double @NotNull [] array, @NotNull DoubleBinaryOperator op) {
        return array.length != 0 ? DoubleOption.some(DoubleArrays.reduceRight(array, op)) : DoubleOption.none();
    }

    @NotNull
    public static <A extends Appendable> A joinTo(double @NotNull [] array, @NotNull A buffer) {
        return DoubleArrays.joinTo(array, buffer, ", ", "", "");
    }

    @NotNull
    public static <A extends Appendable> A joinTo(double @NotNull [] array, @NotNull A buffer, CharSequence separator) {
        return DoubleArrays.joinTo(array, buffer, separator, "", "");
    }

    @NotNull
    public static <A extends Appendable> A joinTo(double @NotNull [] array, @NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        int length = array.length;
        try {
            if (length == 0) {
                buffer.append(prefix).append(postfix);
                return buffer;
            }
            buffer.append(prefix).append(String.valueOf(array[0]));
            for (int i = 1; i < length; ++i) {
                buffer.append(separator);
                buffer.append(Objects.toString(array[i]));
            }
            buffer.append(postfix);
            return buffer;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public static <A extends Appendable> A joinTo(double @NotNull [] array, @NotNull A buffer, @NotNull DoubleFunction<? extends CharSequence> transform) {
        return DoubleArrays.joinTo(array, buffer, ", ", "", "", transform);
    }

    @NotNull
    public static <A extends Appendable> A joinTo(double @NotNull [] array, @NotNull A buffer, CharSequence separator, @NotNull DoubleFunction<? extends CharSequence> transform) {
        return DoubleArrays.joinTo(array, buffer, separator, "", "", transform);
    }

    @NotNull
    public static <A extends Appendable> A joinTo(double @NotNull [] array, @NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull DoubleFunction<? extends CharSequence> transform) {
        int length = array.length;
        try {
            if (length == 0) {
                buffer.append(prefix).append(postfix);
                return buffer;
            }
            buffer.append(prefix).append(transform.apply(array[0]));
            for (int i = 1; i < length; ++i) {
                buffer.append(separator);
                buffer.append(transform.apply(array[i]));
            }
            buffer.append(postfix);
            return buffer;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public static String joinToString(double @NotNull [] array) {
        return DoubleArrays.joinTo(array, new StringBuilder()).toString();
    }

    @NotNull
    public static String joinToString(double @NotNull [] array, CharSequence separator) {
        return DoubleArrays.joinTo(array, new StringBuilder(), separator).toString();
    }

    @NotNull
    public static String joinToString(double @NotNull [] array, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return DoubleArrays.joinTo(array, new StringBuilder(), separator, prefix, postfix).toString();
    }

    @NotNull
    public static String joinToString(double @NotNull [] array, @NotNull DoubleFunction<? extends CharSequence> transform) {
        return DoubleArrays.joinTo(array, new StringBuilder(), transform).toString();
    }

    @NotNull
    public static String joinToString(double @NotNull [] array, CharSequence separator, @NotNull DoubleFunction<? extends CharSequence> transform) {
        return DoubleArrays.joinTo(array, new StringBuilder(), separator, transform).toString();
    }

    @NotNull
    public static String joinToString(double @NotNull [] array, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull DoubleFunction<? extends CharSequence> transform) {
        return DoubleArrays.joinTo(array, new StringBuilder(), separator, prefix, postfix, transform).toString();
    }

    private static final class Itr
    extends AbstractDoubleIterator {
        private final double @NotNull [] array;
        private final int endIndex;
        private int index;

        Itr(double @NotNull [] array, int beginIndex, int endIndex) {
            this.array = array;
            this.index = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.endIndex;
        }

        @Override
        public double nextDouble() {
            if (this.index >= this.endIndex) {
                throw new NoSuchElementException(String.valueOf(this) + ".next()");
            }
            return this.array[this.index++];
        }
    }

    private static final class ReverseItr
    extends AbstractDoubleIterator {
        private final double @NotNull [] array;
        private int index;

        ReverseItr(double @NotNull [] array, int index) {
            this.array = array;
            this.index = index;
        }

        ReverseItr(double @NotNull [] array) {
            this(array, array.length - 1);
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public double nextDouble() {
            try {
                return this.array[this.index--];
            }
            catch (ArrayIndexOutOfBoundsException ignored) {
                throw new NoSuchElementException();
            }
        }
    }
}

