/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import kala.collection.base.AbstractIterator;
import kala.collection.base.GenericArrays;
import kala.collection.base.Growable;
import kala.collection.base.Iterators;
import kala.collection.base.primitive.AbstractFloatIterator;
import kala.collection.base.primitive.FloatArrays;
import kala.collection.base.primitive.FloatGrowable;
import kala.collection.base.primitive.FloatIterators;
import kala.collection.base.primitive.PrimitiveIterator;
import kala.control.primitive.FloatOption;
import kala.function.FloatBinaryOperator;
import kala.function.FloatConsumer;
import kala.function.FloatFunction;
import kala.function.FloatObjBiFunction;
import kala.function.FloatPredicate;
import kala.function.FloatUnaryOperator;
import kala.function.ObjFloatBiFunction;
import kala.internal.InternalFloatArrayBuilder;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FloatIterator
extends PrimitiveIterator<Float, FloatConsumer> {
    @NotNull
    public static FloatIterator empty() {
        return FloatIterators.EMPTY;
    }

    @NotNull
    public static FloatIterator of() {
        return FloatIterator.empty();
    }

    @NotNull
    public static FloatIterator of(final float value) {
        return new FloatIterator(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public float nextFloat() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return value;
                }
                throw new NoSuchElementException();
            }

            public String toString() {
                if (this.hasNext) {
                    return "FloatIterator[" + value + "]";
                }
                return "FloatIterator[]";
            }
        };
    }

    @NotNull
    public static FloatIterator of(float ... values) {
        return FloatArrays.iterator(values);
    }

    @NotNull
    public static FloatIterator ofIterator(final @NotNull @NotNull Iterator<? extends @NotNull Float> it) {
        Objects.requireNonNull(it);
        if (it instanceof FloatIterator) {
            return (FloatIterator)it;
        }
        return new FloatIterator(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public float nextFloat() {
                return ((Float)it.next()).floatValue();
            }

            public String toString() {
                return it.toString();
            }
        };
    }

    @NotNull
    public static FloatIterator concat(@NotNull FloatIterator it1, @NotNull FloatIterator it2) {
        if (!it1.hasNext()) {
            return Objects.requireNonNull(it2);
        }
        if (!it2.hasNext()) {
            return it1;
        }
        return new FloatIterators.Concat(it1, it2);
    }

    @NotNull
    public static FloatIterator concat(FloatIterator ... its) {
        return switch (its.length) {
            case 0 -> FloatIterator.empty();
            case 1 -> Objects.requireNonNull(its[0]);
            case 2 -> FloatIterator.concat(its[0], its[1]);
            default -> new FloatIterators.ConcatAll(GenericArrays.iterator(its));
        };
    }

    @NotNull
    public static FloatIterator concat(@NotNull Iterable<? extends FloatIterator> its) {
        return FloatIterator.concat(its.iterator());
    }

    @NotNull
    public static FloatIterator concat(@NotNull Iterator<? extends FloatIterator> its) {
        if (!its.hasNext()) {
            return FloatIterator.empty();
        }
        return new FloatIterators.ConcatAll(its);
    }

    public float nextFloat();

    @Override
    default public void nextIgnoreResult() {
        this.nextFloat();
    }

    @Override
    @Deprecated
    @NotNull
    default public Float next() {
        return Float.valueOf(this.nextFloat());
    }

    @NotNull
    default public FloatOption find(@NotNull FloatPredicate predicate) {
        while (this.hasNext()) {
            float value = this.nextFloat();
            if (!predicate.test(value)) continue;
            return FloatOption.some(value);
        }
        return FloatOption.None;
    }

    default public boolean contains(float value) {
        while (this.hasNext()) {
            if (Float.floatToIntBits(value) != Float.floatToIntBits(this.nextFloat())) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean contains(Object value) {
        if (!(value instanceof Float)) {
            return false;
        }
        float v = ((Float)value).floatValue();
        while (this.hasNext()) {
            if (Float.floatToIntBits(v) != Float.floatToIntBits(this.nextFloat())) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAll(float @NotNull [] values) {
        block0: while (this.hasNext()) {
            float v = this.nextFloat();
            for (float i : values) {
                if (Float.floatToIntBits(i) == Float.floatToIntBits(v)) continue block0;
            }
            return false;
        }
        return true;
    }

    default public boolean sameElements(@NotNull FloatIterator other) {
        while (this.hasNext() && other.hasNext()) {
            if (Float.floatToIntBits(this.nextFloat()) == Float.floatToIntBits(other.nextFloat())) continue;
            return false;
        }
        return this.hasNext() == other.hasNext();
    }

    @Override
    default public boolean sameElements(@NotNull Iterator<?> other) {
        if (other instanceof FloatIterator) {
            return this.sameElements((FloatIterator)other);
        }
        while (this.hasNext() && other.hasNext()) {
            Object value = other.next();
            if (!(value instanceof Float)) {
                return false;
            }
            if (Float.floatToIntBits(((Float)value).floatValue()) == Float.floatToIntBits(this.nextFloat())) continue;
            return false;
        }
        return this.hasNext() == other.hasNext();
    }

    default public boolean anyMatch(@NotNull FloatPredicate predicate) {
        while (this.hasNext()) {
            if (!predicate.test(this.nextFloat())) continue;
            return true;
        }
        return false;
    }

    default public boolean allMatch(@NotNull FloatPredicate predicate) {
        while (this.hasNext()) {
            if (predicate.test(this.nextFloat())) continue;
            return false;
        }
        return true;
    }

    default public boolean noneMatch(@NotNull FloatPredicate predicate) {
        while (this.hasNext()) {
            if (!predicate.test(this.nextFloat())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public FloatIterator drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        while (n > 0 && this.hasNext()) {
            this.nextFloat();
            --n;
        }
        return this;
    }

    @NotNull
    default public FloatIterator dropWhile(@NotNull FloatPredicate predicate) {
        if (!this.hasNext()) {
            return this;
        }
        float value = 0.0f;
        boolean p = false;
        while (this.hasNext()) {
            value = this.nextFloat();
            if (predicate.test(value)) continue;
            p = true;
            break;
        }
        if (p) {
            return this.hasNext() ? this.prepended(value) : FloatIterator.of(value);
        }
        return this;
    }

    @NotNull
    default public FloatIterator take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (!this.hasNext() || n == 0) {
            return FloatIterator.empty();
        }
        return new FloatIterators.Take(this, n);
    }

    @NotNull
    default public FloatIterator takeWhile(@NotNull FloatPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return this;
        }
        return new FloatIterators.TakeWhile(this, predicate);
    }

    @NotNull
    default public FloatIterator updated(int n, float newValue) {
        if (!this.hasNext() || n < 0) {
            return this;
        }
        if (n == 0) {
            this.nextFloat();
            return this.prepended(newValue);
        }
        return new FloatIterators.Updated(this, n, newValue);
    }

    @NotNull
    default public FloatIterator prepended(float value) {
        return new FloatIterators.Prepended(this, value);
    }

    @NotNull
    default public FloatIterator appended(float value) {
        return new FloatIterators.Appended(this, value);
    }

    @NotNull
    default public FloatIterator filter(@NotNull FloatPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return FloatIterator.empty();
        }
        return new FloatIterators.Filter(this, predicate, false);
    }

    @NotNull
    default public FloatIterator filterNot(@NotNull FloatPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return FloatIterator.empty();
        }
        return new FloatIterators.Filter(this, predicate, true);
    }

    @NotNull
    default public FloatIterator map(final @NotNull FloatUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        if (!this.hasNext()) {
            return this;
        }
        return new AbstractFloatIterator(){

            @Override
            public boolean hasNext() {
                return FloatIterator.this.hasNext();
            }

            @Override
            public float nextFloat() {
                return mapper.applyAsFloat(FloatIterator.this.nextFloat());
            }
        };
    }

    @NotNull
    default public <U> Iterator<U> mapToObj(final @NotNull FloatFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.hasNext()) {
            return Iterators.empty();
        }
        return new AbstractIterator<U>(){

            @Override
            public boolean hasNext() {
                return FloatIterator.this.hasNext();
            }

            @Override
            public U next() {
                return mapper.apply(FloatIterator.this.nextFloat());
            }
        };
    }

    @NotNull
    default public @NotNull Tuple2<@NotNull FloatIterator, @NotNull FloatIterator> span(@NotNull FloatPredicate predicate) {
        if (!this.hasNext()) {
            return Tuple.of(FloatIterator.empty(), FloatIterator.empty());
        }
        InternalFloatArrayBuilder builder = new InternalFloatArrayBuilder();
        FloatIterator it = this;
        while (it.hasNext()) {
            float e = it.nextFloat();
            if (predicate.test(e)) {
                builder.append(e);
                continue;
            }
            it = it.prepended(e);
            break;
        }
        return Tuple.of(builder.iterator(), it);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends FloatGrowable> G filterTo(@NotNull G destination, @NotNull FloatPredicate predicate) {
        FloatIterator it = this;
        while (it.hasNext()) {
            float e = it.nextFloat();
            if (!predicate.test(e)) continue;
            destination.plusAssign(e);
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends FloatGrowable> G filterNotTo(@NotNull G destination, @NotNull FloatPredicate predicate) {
        FloatIterator it = this;
        while (it.hasNext()) {
            float e = it.nextFloat();
            if (predicate.test(e)) continue;
            destination.plusAssign(e);
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends FloatGrowable> G mapTo(@NotNull G destination, @NotNull FloatUnaryOperator mapper) {
        FloatIterator it = this;
        while (it.hasNext()) {
            destination.plusAssign(mapper.applyAsFloat(it.nextFloat()));
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends Growable<? super U>> G mapToObjTo(@NotNull G destination, @NotNull FloatFunction<? extends U> mapper) {
        FloatIterator it = this;
        while (it.hasNext()) {
            destination.plusAssign(mapper.apply(it.nextFloat()));
        }
        return destination;
    }

    default public int count(@NotNull FloatPredicate predicate) {
        int c = 0;
        while (this.hasNext()) {
            if (!predicate.test(this.nextFloat())) continue;
            ++c;
        }
        return c;
    }

    default public float max() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        float value = this.nextFloat();
        while (this.hasNext()) {
            value = Math.max(value, this.nextFloat());
        }
        return value;
    }

    @Override
    @Nullable
    default public Float maxOrNull() {
        return this.hasNext() ? Float.valueOf(this.max()) : null;
    }

    @NotNull
    default public FloatOption maxOption() {
        return this.hasNext() ? FloatOption.some(this.max()) : FloatOption.none();
    }

    default public float min() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        float value = this.nextFloat();
        while (this.hasNext()) {
            value = Math.min(value, this.nextFloat());
        }
        return value;
    }

    @Override
    @Nullable
    default public Float minOrNull() {
        return this.hasNext() ? Float.valueOf(this.min()) : null;
    }

    @NotNull
    default public FloatOption minOption() {
        return this.hasNext() ? FloatOption.some(this.min()) : FloatOption.none();
    }

    default public float fold(float zero, @NotNull FloatBinaryOperator op) {
        return this.foldLeft(zero, op);
    }

    default public float foldLeft(float zero, @NotNull FloatBinaryOperator op) {
        while (this.hasNext()) {
            zero = op.applyAsFloat(zero, this.nextFloat());
        }
        return zero;
    }

    default public <U> U foldLeftToObj(U zero, @NotNull ObjFloatBiFunction<U, U> op) {
        while (this.hasNext()) {
            zero = op.apply(zero, this.nextFloat());
        }
        return zero;
    }

    default public float foldRight(float zero, @NotNull FloatBinaryOperator op) {
        if (!this.hasNext()) {
            return zero;
        }
        InternalFloatArrayBuilder builder = new InternalFloatArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextFloat());
        }
        for (int i = builder.size() - 1; i >= 0; --i) {
            zero = op.applyAsFloat(builder.get(i), zero);
        }
        return zero;
    }

    default public <U> U foldRightToObj(U zero, @NotNull FloatObjBiFunction<U, U> op) {
        if (!this.hasNext()) {
            return zero;
        }
        InternalFloatArrayBuilder builder = new InternalFloatArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextFloat());
        }
        for (int i = builder.size() - 1; i >= 0; --i) {
            zero = op.apply(builder.get(i), zero);
        }
        return zero;
    }

    default public float reduce(@NotNull FloatBinaryOperator op) {
        return this.reduceLeft(op);
    }

    @Nullable
    default public Float reduceOrNull(@NotNull FloatBinaryOperator op) {
        return this.reduceLeftOrNull(op);
    }

    @NotNull
    default public FloatOption reduceOption(@NotNull FloatBinaryOperator op) {
        return this.reduceLeftOption(op);
    }

    default public float reduceLeft(@NotNull FloatBinaryOperator op) {
        float e = this.nextFloat();
        while (this.hasNext()) {
            e = op.applyAsFloat(e, this.nextFloat());
        }
        return e;
    }

    @Nullable
    default public Float reduceLeftOrNull(@NotNull FloatBinaryOperator op) {
        return this.hasNext() ? Float.valueOf(this.reduceLeft(op)) : null;
    }

    @NotNull
    default public FloatOption reduceLeftOption(@NotNull FloatBinaryOperator op) {
        return this.hasNext() ? FloatOption.some(this.reduceLeft(op)) : FloatOption.none();
    }

    default public float reduceRight(@NotNull FloatBinaryOperator op) {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        InternalFloatArrayBuilder list = new InternalFloatArrayBuilder();
        list.append(this.nextFloat());
        while (this.hasNext()) {
            list.append(this.nextFloat());
        }
        int size = list.size();
        float e = list.get(size - 1);
        for (int i = size - 2; i >= 0; --i) {
            e = op.applyAsFloat(list.get(i), e);
        }
        return e;
    }

    @Nullable
    default public Float reduceRightOrNull(@NotNull FloatBinaryOperator op) {
        return this.hasNext() ? Float.valueOf(this.reduceRight(op)) : null;
    }

    @NotNull
    default public FloatOption reduceRightOption(@NotNull FloatBinaryOperator op) {
        return this.hasNext() ? FloatOption.some(this.reduceRight(op)) : FloatOption.none();
    }

    default public float @NotNull [] toArray() {
        if (!this.hasNext()) {
            return FloatArrays.EMPTY;
        }
        InternalFloatArrayBuilder builder = new InternalFloatArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextFloat());
        }
        return builder.toArray();
    }

    @Override
    default public void forEach(@NotNull FloatConsumer action) {
        while (this.hasNext()) {
            action.accept(this.nextFloat());
        }
    }

    @Override
    default public void forEachRemaining(@NotNull Consumer<? super Float> action) {
        if (action instanceof FloatConsumer) {
            this.forEach((FloatConsumer)((Object)action));
        } else {
            this.forEach(action::accept);
        }
    }

    @Override
    default public void forEachRemaining(@NotNull FloatConsumer action) {
        this.forEach(action);
    }

    @Override
    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        try {
            buffer.append(prefix);
            if (this.hasNext()) {
                buffer.append(String.valueOf(this.nextFloat()));
            }
            while (this.hasNext()) {
                buffer.append(separator).append(String.valueOf(this.nextFloat()));
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    @Override
    default public int hash() {
        int res = 0;
        while (this.hasNext()) {
            res = res * 31 + Float.hashCode(this.nextFloat());
        }
        return res;
    }
}

