/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.base.Growable;
import kala.collection.base.primitive.FloatArrays;
import kala.collection.base.primitive.FloatGrowable;
import kala.collection.base.primitive.FloatIterator;
import kala.collection.base.primitive.PrimitiveTraversable;
import kala.collection.factory.primitive.FloatCollectionFactory;
import kala.control.primitive.FloatOption;
import kala.function.CheckedFloatConsumer;
import kala.function.FloatBinaryOperator;
import kala.function.FloatConsumer;
import kala.function.FloatFunction;
import kala.function.FloatObjBiFunction;
import kala.function.FloatPredicate;
import kala.function.FloatUnaryOperator;
import kala.function.ObjFloatBiFunction;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FloatTraversable
extends PrimitiveTraversable<Float> {
    @Override
    @NotNull
    public FloatIterator iterator();

    default public float elementAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0 && index >= knownSize) {
            throw new IndexOutOfBoundsException();
        }
        FloatIterator it = this.iterator();
        for (int i = 0; i < index; ++i) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            it.nextFloat();
        }
        if (it.hasNext()) {
            return it.nextFloat();
        }
        throw new IndexOutOfBoundsException("index: " + index);
    }

    @NotNull
    default public FloatOption find(@NotNull FloatPredicate predicate) {
        return this.iterator().find(predicate);
    }

    default public boolean contains(float value) {
        return this.knownSize() != 0 && this.iterator().contains(value);
    }

    default public boolean containsAll(float @NotNull [] values) {
        return this.iterator().containsAll(values);
    }

    default public boolean containsAll(@NotNull FloatTraversable values) {
        FloatIterator it = values.iterator();
        if (this.knownSize() == 0) {
            return !it.hasNext();
        }
        while (it.hasNext()) {
            if (this.contains(it.nextFloat())) continue;
            return false;
        }
        return true;
    }

    default public boolean sameElements(@NotNull FloatTraversable other) {
        return this.iterator().sameElements(other.iterator());
    }

    default public boolean sameElements(@NotNull Iterable<?> other) {
        return this.iterator().sameElements(other.iterator());
    }

    default public boolean anyMatch(@NotNull FloatPredicate predicate) {
        return this.iterator().anyMatch(predicate);
    }

    default public boolean allMatch(@NotNull FloatPredicate predicate) {
        return this.iterator().allMatch(predicate);
    }

    default public boolean noneMatch(@NotNull FloatPredicate predicate) {
        return this.iterator().noneMatch(predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends FloatGrowable> G filterTo(@NotNull G destination, @NotNull FloatPredicate predicate) {
        return this.iterator().filterTo(destination, predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends FloatGrowable> G filterNotTo(@NotNull G destination, @NotNull FloatPredicate predicate) {
        return this.iterator().filterNotTo(destination, predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends FloatGrowable> G mapTo(@NotNull G destination, @NotNull FloatUnaryOperator mapper) {
        return this.iterator().mapTo(destination, mapper);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends Growable<? super U>> G mapToObjTo(@NotNull G destination, @NotNull FloatFunction<? extends U> mapper) {
        return this.iterator().mapToObjTo(destination, mapper);
    }

    default public int count(@NotNull FloatPredicate predicate) {
        return this.iterator().count(predicate);
    }

    default public float max() {
        if (this.knownSize() == 0) {
            throw new NoSuchElementException();
        }
        return this.iterator().max();
    }

    @Override
    @Nullable
    default public Float maxOrNull() {
        return this.isNotEmpty() ? Float.valueOf(this.max()) : null;
    }

    @NotNull
    default public FloatOption maxOption() {
        return this.knownSize() == 0 ? FloatOption.none() : this.iterator().maxOption();
    }

    default public float min() {
        if (this.knownSize() == 0) {
            throw new NoSuchElementException();
        }
        return this.iterator().min();
    }

    @Override
    @Nullable
    default public Float minOrNull() {
        return this.knownSize() == 0 ? null : this.iterator().minOrNull();
    }

    @NotNull
    default public FloatOption minOption() {
        return this.knownSize() == 0 ? FloatOption.none() : this.iterator().minOption();
    }

    default public float fold(float zero, @NotNull FloatBinaryOperator op) {
        return this.foldLeft(zero, op);
    }

    default public float foldLeft(float zero, @NotNull FloatBinaryOperator op) {
        return this.iterator().foldLeft(zero, op);
    }

    default public <U> U foldLeftToObj(U zero, @NotNull ObjFloatBiFunction<U, U> op) {
        return this.iterator().foldLeftToObj(zero, op);
    }

    default public float foldRight(float zero, @NotNull FloatBinaryOperator op) {
        return this.iterator().foldRight(zero, op);
    }

    default public <U> U foldRightToObj(U zero, @NotNull FloatObjBiFunction<U, U> op) {
        return this.iterator().foldRightToObj(zero, op);
    }

    default public float reduce(@NotNull FloatBinaryOperator op) {
        return this.reduceLeft(op);
    }

    @Nullable
    default public Float reduceOrNull(@NotNull FloatBinaryOperator op) {
        return this.reduceLeftOrNull(op);
    }

    @NotNull
    default public FloatOption reduceOption(@NotNull FloatBinaryOperator op) {
        return this.reduceLeftOption(op);
    }

    default public float reduceLeft(@NotNull FloatBinaryOperator op) {
        return this.iterator().reduceLeft(op);
    }

    @Nullable
    default public Float reduceLeftOrNull(@NotNull FloatBinaryOperator op) {
        return this.isNotEmpty() ? Float.valueOf(this.reduceLeft(op)) : null;
    }

    @NotNull
    default public FloatOption reduceLeftOption(@NotNull FloatBinaryOperator op) {
        return this.isNotEmpty() ? FloatOption.some(this.reduceLeft(op)) : FloatOption.none();
    }

    default public float reduceRight(@NotNull FloatBinaryOperator op) {
        return this.iterator().reduceRight(op);
    }

    @Nullable
    default public Float reduceRightOrNull(@NotNull FloatBinaryOperator op) {
        return this.isNotEmpty() ? Float.valueOf(this.reduceRight(op)) : null;
    }

    @NotNull
    default public FloatOption reduceRightOption(@NotNull FloatBinaryOperator op) {
        return this.isNotEmpty() ? FloatOption.some(this.reduceRight(op)) : FloatOption.none();
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(float @NotNull [] dest) {
        return this.copyToArray(0, dest, 0, Integer.MAX_VALUE);
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(float @NotNull [] dest, int destPos) {
        return this.copyToArray(0, dest, destPos, Integer.MAX_VALUE);
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(float @NotNull [] dest, int destPos, int limit) {
        return this.copyToArray(0, dest, destPos, limit);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, float @NotNull [] dest) {
        return this.copyToArray(srcPos, dest, 0, Integer.MAX_VALUE);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, float @NotNull [] dest, int destPos) {
        return this.copyToArray(srcPos, dest, destPos, Integer.MAX_VALUE);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, float @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + srcPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        if (limit <= 0) {
            return 0;
        }
        int dl = dest.length;
        if (destPos > dl) {
            return 0;
        }
        int kn = this.knownSize();
        if (kn >= 0 && srcPos >= kn) {
            return 0;
        }
        int end = Math.min(dl - destPos, limit) + destPos;
        int n = 0;
        FloatIterator it = this.iterator();
        while (n++ < srcPos) {
            if (it.hasNext()) {
                it.nextFloat();
                continue;
            }
            return 0;
        }
        int idx = destPos;
        while (it.hasNext() && idx < end) {
            dest[idx++] = it.nextFloat();
        }
        return idx - destPos;
    }

    @Override
    default public <R, Builder> R collect(@NotNull FloatCollectionFactory<Builder, ? extends R> factory) {
        return FloatCollectionFactory.buildBy(factory, this::forEach);
    }

    @Override
    @NotNull
    default public <G extends FloatGrowable> G collect(@NotNull G destination) {
        destination.plusAssign(this);
        return destination;
    }

    default public float @NotNull [] toArray() {
        int s = this.knownSize();
        if (s == 0) {
            return FloatArrays.EMPTY;
        }
        if (s > 0) {
            float[] arr = new float[s];
            int i = 0;
            FloatIterator iterator = this.iterator();
            while (iterator.hasNext()) {
                float t = iterator.nextFloat();
                arr[i++] = t;
            }
            return arr;
        }
        return this.iterator().toArray();
    }

    default public void forEach(@NotNull FloatConsumer action) {
        this.iterator().forEach(action);
    }

    default public <Ex extends Throwable> void forEachChecked(@NotNull CheckedFloatConsumer<Ex> action) throws Ex {
        this.forEach(action);
    }

    default public void forEachUnchecked(@NotNull CheckedFloatConsumer<?> action) {
        this.forEach(action);
    }

    default public void forEachBreakable(@NotNull FloatPredicate action) {
        Objects.requireNonNull(action);
        FloatIterator it = this.iterator();
        while (it.hasNext() && action.test(it.nextFloat())) {
        }
    }
}

