/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import kala.collection.base.AbstractIterator;
import kala.collection.base.GenericArrays;
import kala.collection.base.Growable;
import kala.collection.base.Iterators;
import kala.collection.base.primitive.AbstractIntIterator;
import kala.collection.base.primitive.IntArrays;
import kala.collection.base.primitive.IntGrowable;
import kala.collection.base.primitive.IntIterators;
import kala.collection.base.primitive.PrimitiveIterator;
import kala.control.primitive.IntOption;
import kala.function.IntObjBiFunction;
import kala.function.ObjIntBiFunction;
import kala.internal.InternalIntArrayBuilder;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IntIterator
extends PrimitiveIterator<Integer, IntConsumer>,
PrimitiveIterator.OfInt {
    @NotNull
    public static IntIterator empty() {
        return IntIterators.EMPTY;
    }

    @NotNull
    public static IntIterator of() {
        return IntIterator.empty();
    }

    @NotNull
    public static IntIterator of(final int value) {
        return new IntIterator(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public int nextInt() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return value;
                }
                throw new NoSuchElementException();
            }

            public String toString() {
                if (this.hasNext) {
                    return "IntIterator[" + value + "]";
                }
                return "IntIterator[]";
            }
        };
    }

    @NotNull
    public static IntIterator of(int ... values) {
        return IntArrays.iterator(values);
    }

    @NotNull
    public static IntIterator ofIterator(final @NotNull @NotNull Iterator<? extends @NotNull Integer> it) {
        Objects.requireNonNull(it);
        if (it instanceof IntIterator) {
            return (IntIterator)it;
        }
        return new IntIterator(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public int nextInt() {
                return (Integer)it.next();
            }

            public String toString() {
                return it.toString();
            }
        };
    }

    @NotNull
    public static IntIterator ofIterator(final @NotNull PrimitiveIterator.OfInt it) {
        Objects.requireNonNull(it);
        if (it instanceof IntIterator) {
            return (IntIterator)it;
        }
        return new IntIterator(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public int nextInt() {
                return it.nextInt();
            }

            public String toString() {
                return it.toString();
            }
        };
    }

    @NotNull
    public static IntIterator concat(@NotNull IntIterator it1, @NotNull IntIterator it2) {
        if (!it1.hasNext()) {
            return Objects.requireNonNull(it2);
        }
        if (!it2.hasNext()) {
            return it1;
        }
        return new IntIterators.Concat(it1, it2);
    }

    @NotNull
    public static IntIterator concat(IntIterator ... its) {
        return switch (its.length) {
            case 0 -> IntIterator.empty();
            case 1 -> Objects.requireNonNull(its[0]);
            case 2 -> IntIterator.concat(its[0], its[1]);
            default -> new IntIterators.ConcatAll(GenericArrays.iterator(its));
        };
    }

    @NotNull
    public static IntIterator concat(@NotNull Iterable<? extends IntIterator> its) {
        return IntIterator.concat(its.iterator());
    }

    @NotNull
    public static IntIterator concat(@NotNull Iterator<? extends IntIterator> its) {
        if (!its.hasNext()) {
            return IntIterator.empty();
        }
        return new IntIterators.ConcatAll(its);
    }

    @Override
    public int nextInt();

    @Override
    default public void nextIgnoreResult() {
        this.nextInt();
    }

    @Override
    @Deprecated
    @NotNull
    default public Integer next() {
        return this.nextInt();
    }

    @NotNull
    default public IntOption find(@NotNull IntPredicate predicate) {
        while (this.hasNext()) {
            int value = this.nextInt();
            if (!predicate.test(value)) continue;
            return IntOption.some(value);
        }
        return IntOption.None;
    }

    default public boolean contains(int value) {
        while (this.hasNext()) {
            if (value != this.nextInt()) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean contains(Object value) {
        if (!(value instanceof Integer)) {
            return false;
        }
        int v = (Integer)value;
        while (this.hasNext()) {
            if (v != this.nextInt()) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAll(int @NotNull [] values) {
        block0: while (this.hasNext()) {
            int v = this.nextInt();
            for (int i : values) {
                if (i == v) continue block0;
            }
            return false;
        }
        return true;
    }

    default public boolean sameElements(@NotNull IntIterator other) {
        return this.sameElements((PrimitiveIterator.OfInt)other);
    }

    default public boolean sameElements(@NotNull PrimitiveIterator.OfInt other) {
        while (this.hasNext() && other.hasNext()) {
            if (this.nextInt() == other.nextInt()) continue;
            return false;
        }
        return this.hasNext() == other.hasNext();
    }

    @Override
    default public boolean sameElements(@NotNull Iterator<?> other) {
        if (other instanceof PrimitiveIterator.OfInt) {
            return this.sameElements((PrimitiveIterator.OfInt)other);
        }
        while (this.hasNext() && other.hasNext()) {
            Object value = other.next();
            if (!(value instanceof Integer)) {
                return false;
            }
            if (((Integer)value).intValue() == this.nextInt()) continue;
            return false;
        }
        return this.hasNext() == other.hasNext();
    }

    default public boolean anyMatch(@NotNull IntPredicate predicate) {
        while (this.hasNext()) {
            if (!predicate.test(this.nextInt())) continue;
            return true;
        }
        return false;
    }

    default public boolean allMatch(@NotNull IntPredicate predicate) {
        while (this.hasNext()) {
            if (predicate.test(this.nextInt())) continue;
            return false;
        }
        return true;
    }

    default public boolean noneMatch(@NotNull IntPredicate predicate) {
        while (this.hasNext()) {
            if (!predicate.test(this.nextInt())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public IntIterator drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        while (n > 0 && this.hasNext()) {
            this.nextInt();
            --n;
        }
        return this;
    }

    @NotNull
    default public IntIterator dropWhile(@NotNull IntPredicate predicate) {
        if (!this.hasNext()) {
            return this;
        }
        int value = 0;
        boolean p = false;
        while (this.hasNext()) {
            value = this.nextInt();
            if (predicate.test(value)) continue;
            p = true;
            break;
        }
        if (p) {
            return this.hasNext() ? this.prepended(value) : IntIterator.of(value);
        }
        return this;
    }

    @NotNull
    default public IntIterator take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (!this.hasNext() || n == 0) {
            return IntIterator.empty();
        }
        return new IntIterators.Take(this, n);
    }

    @NotNull
    default public IntIterator takeWhile(@NotNull IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return this;
        }
        return new IntIterators.TakeWhile(this, predicate);
    }

    @NotNull
    default public IntIterator updated(int n, int newValue) {
        if (!this.hasNext() || n < 0) {
            return this;
        }
        if (n == 0) {
            this.nextInt();
            return this.prepended(newValue);
        }
        return new IntIterators.Updated(this, n, newValue);
    }

    @NotNull
    default public IntIterator prepended(int value) {
        return new IntIterators.Prepended(this, value);
    }

    @NotNull
    default public IntIterator appended(int value) {
        return new IntIterators.Appended(this, value);
    }

    @NotNull
    default public IntIterator filter(@NotNull IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return IntIterator.empty();
        }
        return new IntIterators.Filter(this, predicate, false);
    }

    @NotNull
    default public IntIterator filterNot(@NotNull IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return IntIterator.empty();
        }
        return new IntIterators.Filter(this, predicate, true);
    }

    @NotNull
    default public IntIterator map(final @NotNull IntUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        if (!this.hasNext()) {
            return this;
        }
        return new AbstractIntIterator(){

            @Override
            public boolean hasNext() {
                return IntIterator.this.hasNext();
            }

            @Override
            public int nextInt() {
                return mapper.applyAsInt(IntIterator.this.nextInt());
            }
        };
    }

    @NotNull
    default public <U> Iterator<U> mapToObj(final @NotNull IntFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.hasNext()) {
            return Iterators.empty();
        }
        return new AbstractIterator<U>(){

            @Override
            public boolean hasNext() {
                return IntIterator.this.hasNext();
            }

            @Override
            public U next() {
                return mapper.apply(IntIterator.this.nextInt());
            }
        };
    }

    @NotNull
    default public @NotNull Tuple2<@NotNull IntIterator, @NotNull IntIterator> span(@NotNull IntPredicate predicate) {
        if (!this.hasNext()) {
            return Tuple.of(IntIterator.empty(), IntIterator.empty());
        }
        InternalIntArrayBuilder builder = new InternalIntArrayBuilder();
        IntIterator it = this;
        while (it.hasNext()) {
            int e = it.nextInt();
            if (predicate.test(e)) {
                builder.append(e);
                continue;
            }
            it = it.prepended(e);
            break;
        }
        return Tuple.of(builder.iterator(), it);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends IntGrowable> G filterTo(@NotNull G destination, @NotNull IntPredicate predicate) {
        IntIterator it = this;
        while (it.hasNext()) {
            int e = it.nextInt();
            if (!predicate.test(e)) continue;
            destination.plusAssign(e);
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends IntGrowable> G filterNotTo(@NotNull G destination, @NotNull IntPredicate predicate) {
        IntIterator it = this;
        while (it.hasNext()) {
            int e = it.nextInt();
            if (predicate.test(e)) continue;
            destination.plusAssign(e);
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends IntGrowable> G mapTo(@NotNull G destination, @NotNull IntUnaryOperator mapper) {
        IntIterator it = this;
        while (it.hasNext()) {
            destination.plusAssign(mapper.applyAsInt(it.nextInt()));
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends Growable<? super U>> G mapToObjTo(@NotNull G destination, @NotNull IntFunction<? extends U> mapper) {
        IntIterator it = this;
        while (it.hasNext()) {
            destination.plusAssign(mapper.apply(it.nextInt()));
        }
        return destination;
    }

    default public int count(@NotNull IntPredicate predicate) {
        int c = 0;
        while (this.hasNext()) {
            if (!predicate.test(this.nextInt())) continue;
            ++c;
        }
        return c;
    }

    default public int max() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int value = this.nextInt();
        while (this.hasNext()) {
            value = Math.max(value, this.nextInt());
        }
        return value;
    }

    @Override
    @Nullable
    default public Integer maxOrNull() {
        return this.hasNext() ? Integer.valueOf(this.max()) : null;
    }

    @NotNull
    default public IntOption maxOption() {
        return this.hasNext() ? IntOption.some(this.max()) : IntOption.none();
    }

    default public int min() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int value = this.nextInt();
        while (this.hasNext()) {
            value = Math.min(value, this.nextInt());
        }
        return value;
    }

    @Override
    @Nullable
    default public Integer minOrNull() {
        return this.hasNext() ? Integer.valueOf(this.min()) : null;
    }

    @NotNull
    default public IntOption minOption() {
        return this.hasNext() ? IntOption.some(this.min()) : IntOption.none();
    }

    default public int fold(int zero, @NotNull IntBinaryOperator op) {
        return this.foldLeft(zero, op);
    }

    default public int foldLeft(int zero, @NotNull IntBinaryOperator op) {
        while (this.hasNext()) {
            zero = op.applyAsInt(zero, this.nextInt());
        }
        return zero;
    }

    default public <U> U foldLeftToObj(U zero, @NotNull ObjIntBiFunction<U, U> op) {
        while (this.hasNext()) {
            zero = op.apply(zero, this.nextInt());
        }
        return zero;
    }

    default public int foldRight(int zero, @NotNull IntBinaryOperator op) {
        if (!this.hasNext()) {
            return zero;
        }
        InternalIntArrayBuilder builder = new InternalIntArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextInt());
        }
        for (int i = builder.size() - 1; i >= 0; --i) {
            zero = op.applyAsInt(builder.get(i), zero);
        }
        return zero;
    }

    default public <U> U foldRightToObj(U zero, @NotNull IntObjBiFunction<U, U> op) {
        if (!this.hasNext()) {
            return zero;
        }
        InternalIntArrayBuilder builder = new InternalIntArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextInt());
        }
        for (int i = builder.size() - 1; i >= 0; --i) {
            zero = op.apply(builder.get(i), zero);
        }
        return zero;
    }

    default public int reduce(@NotNull IntBinaryOperator op) {
        return this.reduceLeft(op);
    }

    @Nullable
    default public Integer reduceOrNull(@NotNull IntBinaryOperator op) {
        return this.reduceLeftOrNull(op);
    }

    @NotNull
    default public IntOption reduceOption(@NotNull IntBinaryOperator op) {
        return this.reduceLeftOption(op);
    }

    default public int reduceLeft(@NotNull IntBinaryOperator op) {
        int e = this.nextInt();
        while (this.hasNext()) {
            e = op.applyAsInt(e, this.nextInt());
        }
        return e;
    }

    @Nullable
    default public Integer reduceLeftOrNull(@NotNull IntBinaryOperator op) {
        return this.hasNext() ? Integer.valueOf(this.reduceLeft(op)) : null;
    }

    @NotNull
    default public IntOption reduceLeftOption(@NotNull IntBinaryOperator op) {
        return this.hasNext() ? IntOption.some(this.reduceLeft(op)) : IntOption.none();
    }

    default public int reduceRight(@NotNull IntBinaryOperator op) {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        InternalIntArrayBuilder list = new InternalIntArrayBuilder();
        list.append(this.nextInt());
        while (this.hasNext()) {
            list.append(this.nextInt());
        }
        int size = list.size();
        int e = list.get(size - 1);
        for (int i = size - 2; i >= 0; --i) {
            e = op.applyAsInt(list.get(i), e);
        }
        return e;
    }

    @Nullable
    default public Integer reduceRightOrNull(@NotNull IntBinaryOperator op) {
        return this.hasNext() ? Integer.valueOf(this.reduceRight(op)) : null;
    }

    @NotNull
    default public IntOption reduceRightOption(@NotNull IntBinaryOperator op) {
        return this.hasNext() ? IntOption.some(this.reduceRight(op)) : IntOption.none();
    }

    default public int @NotNull [] toArray() {
        if (!this.hasNext()) {
            return IntArrays.EMPTY;
        }
        InternalIntArrayBuilder builder = new InternalIntArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextInt());
        }
        return builder.toArray();
    }

    @Override
    default public void forEach(@NotNull IntConsumer action) {
        while (this.hasNext()) {
            action.accept(this.nextInt());
        }
    }

    @Override
    default public void forEachRemaining(@NotNull Consumer<? super Integer> action) {
        if (action instanceof IntConsumer) {
            this.forEach((IntConsumer)((Object)action));
        } else {
            this.forEach(action::accept);
        }
    }

    @Override
    default public void forEachRemaining(@NotNull IntConsumer action) {
        this.forEach(action);
    }

    @Override
    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        try {
            buffer.append(prefix);
            if (this.hasNext()) {
                buffer.append(String.valueOf(this.nextInt()));
            }
            while (this.hasNext()) {
                buffer.append(separator).append(String.valueOf(this.nextInt()));
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    @Override
    default public int hash() {
        int res = 0;
        while (this.hasNext()) {
            res = res * 31 + Integer.hashCode(this.nextInt());
        }
        return res;
    }
}

