/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import kala.collection.base.Growable;
import kala.collection.base.primitive.IntArrays;
import kala.collection.base.primitive.IntGrowable;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.PrimitiveTraversable;
import kala.collection.factory.primitive.IntCollectionFactory;
import kala.control.primitive.IntOption;
import kala.function.CheckedIntConsumer;
import kala.function.IntObjBiFunction;
import kala.function.ObjIntBiFunction;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IntTraversable
extends PrimitiveTraversable<Integer> {
    @Override
    @NotNull
    public IntIterator iterator();

    @NotNull
    default public Spliterator.OfInt spliterator() {
        int ks = this.knownSize();
        if (ks == 0) {
            return Spliterators.emptyIntSpliterator();
        }
        if (ks > 0) {
            return Spliterators.spliterator(this.iterator(), (long)ks, this.characteristics());
        }
        return Spliterators.spliteratorUnknownSize(this.iterator(), this.characteristics());
    }

    @NotNull
    default public IntStream stream() {
        return StreamSupport.intStream(this.spliterator(), false);
    }

    @NotNull
    default public IntStream parallelStream() {
        return StreamSupport.intStream(this.spliterator(), true);
    }

    default public int elementAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0 && index >= knownSize) {
            throw new IndexOutOfBoundsException();
        }
        IntIterator it = this.iterator();
        for (int i = 0; i < index; ++i) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            it.nextInt();
        }
        if (it.hasNext()) {
            return it.nextInt();
        }
        throw new IndexOutOfBoundsException("index: " + index);
    }

    @NotNull
    default public IntOption find(@NotNull IntPredicate predicate) {
        return this.iterator().find(predicate);
    }

    default public boolean contains(int value) {
        return this.knownSize() != 0 && this.iterator().contains(value);
    }

    default public boolean containsAll(int @NotNull [] values) {
        return this.iterator().containsAll(values);
    }

    default public boolean containsAll(@NotNull IntTraversable values) {
        IntIterator it = values.iterator();
        if (this.knownSize() == 0) {
            return !it.hasNext();
        }
        while (it.hasNext()) {
            if (this.contains(it.nextInt())) continue;
            return false;
        }
        return true;
    }

    default public boolean sameElements(@NotNull IntTraversable other) {
        return this.iterator().sameElements(other.iterator());
    }

    default public boolean sameElements(@NotNull Iterable<?> other) {
        return this.iterator().sameElements(other.iterator());
    }

    default public boolean anyMatch(@NotNull IntPredicate predicate) {
        return this.iterator().anyMatch(predicate);
    }

    default public boolean allMatch(@NotNull IntPredicate predicate) {
        return this.iterator().allMatch(predicate);
    }

    default public boolean noneMatch(@NotNull IntPredicate predicate) {
        return this.iterator().noneMatch(predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends IntGrowable> G filterTo(@NotNull G destination, @NotNull IntPredicate predicate) {
        return this.iterator().filterTo(destination, predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends IntGrowable> G filterNotTo(@NotNull G destination, @NotNull IntPredicate predicate) {
        return this.iterator().filterNotTo(destination, predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends IntGrowable> G mapTo(@NotNull G destination, @NotNull IntUnaryOperator mapper) {
        return this.iterator().mapTo(destination, mapper);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends Growable<? super U>> G mapToObjTo(@NotNull G destination, @NotNull IntFunction<? extends U> mapper) {
        return this.iterator().mapToObjTo(destination, mapper);
    }

    default public int count(@NotNull IntPredicate predicate) {
        return this.iterator().count(predicate);
    }

    default public int max() {
        if (this.knownSize() == 0) {
            throw new NoSuchElementException();
        }
        return this.iterator().max();
    }

    @Override
    @Nullable
    default public Integer maxOrNull() {
        return this.isNotEmpty() ? Integer.valueOf(this.max()) : null;
    }

    @NotNull
    default public IntOption maxOption() {
        return this.knownSize() == 0 ? IntOption.none() : this.iterator().maxOption();
    }

    default public int min() {
        if (this.knownSize() == 0) {
            throw new NoSuchElementException();
        }
        return this.iterator().min();
    }

    @Override
    @Nullable
    default public Integer minOrNull() {
        return this.knownSize() == 0 ? null : this.iterator().minOrNull();
    }

    @NotNull
    default public IntOption minOption() {
        return this.knownSize() == 0 ? IntOption.none() : this.iterator().minOption();
    }

    default public int fold(int zero, @NotNull IntBinaryOperator op) {
        return this.foldLeft(zero, op);
    }

    default public int foldLeft(int zero, @NotNull IntBinaryOperator op) {
        return this.iterator().foldLeft(zero, op);
    }

    default public <U> U foldLeftToObj(U zero, @NotNull ObjIntBiFunction<U, U> op) {
        return this.iterator().foldLeftToObj(zero, op);
    }

    default public int foldRight(int zero, @NotNull IntBinaryOperator op) {
        return this.iterator().foldRight(zero, op);
    }

    default public <U> U foldRightToObj(U zero, @NotNull IntObjBiFunction<U, U> op) {
        return this.iterator().foldRightToObj(zero, op);
    }

    default public int reduce(@NotNull IntBinaryOperator op) {
        return this.reduceLeft(op);
    }

    @Nullable
    default public Integer reduceOrNull(@NotNull IntBinaryOperator op) {
        return this.reduceLeftOrNull(op);
    }

    @NotNull
    default public IntOption reduceOption(@NotNull IntBinaryOperator op) {
        return this.reduceLeftOption(op);
    }

    default public int reduceLeft(@NotNull IntBinaryOperator op) {
        return this.iterator().reduceLeft(op);
    }

    @Nullable
    default public Integer reduceLeftOrNull(@NotNull IntBinaryOperator op) {
        return this.isNotEmpty() ? Integer.valueOf(this.reduceLeft(op)) : null;
    }

    @NotNull
    default public IntOption reduceLeftOption(@NotNull IntBinaryOperator op) {
        return this.isNotEmpty() ? IntOption.some(this.reduceLeft(op)) : IntOption.none();
    }

    default public int reduceRight(@NotNull IntBinaryOperator op) {
        return this.iterator().reduceRight(op);
    }

    @Nullable
    default public Integer reduceRightOrNull(@NotNull IntBinaryOperator op) {
        return this.isNotEmpty() ? Integer.valueOf(this.reduceRight(op)) : null;
    }

    @NotNull
    default public IntOption reduceRightOption(@NotNull IntBinaryOperator op) {
        return this.isNotEmpty() ? IntOption.some(this.reduceRight(op)) : IntOption.none();
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int @NotNull [] dest) {
        return this.copyToArray(0, dest, 0, Integer.MAX_VALUE);
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int @NotNull [] dest, int destPos) {
        return this.copyToArray(0, dest, destPos, Integer.MAX_VALUE);
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int @NotNull [] dest, int destPos, int limit) {
        return this.copyToArray(0, dest, destPos, limit);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, int @NotNull [] dest) {
        return this.copyToArray(srcPos, dest, 0, Integer.MAX_VALUE);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, int @NotNull [] dest, int destPos) {
        return this.copyToArray(srcPos, dest, destPos, Integer.MAX_VALUE);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, int @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + srcPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        if (limit <= 0) {
            return 0;
        }
        int dl = dest.length;
        if (destPos > dl) {
            return 0;
        }
        int kn = this.knownSize();
        if (kn >= 0 && srcPos >= kn) {
            return 0;
        }
        int end = Math.min(dl - destPos, limit) + destPos;
        int n = 0;
        IntIterator it = this.iterator();
        while (n++ < srcPos) {
            if (it.hasNext()) {
                it.nextInt();
                continue;
            }
            return 0;
        }
        int idx = destPos;
        while (it.hasNext() && idx < end) {
            dest[idx++] = it.nextInt();
        }
        return idx - destPos;
    }

    @Override
    default public <R, Builder> R collect(@NotNull IntCollectionFactory<Builder, ? extends R> factory) {
        return IntCollectionFactory.buildBy(factory, this::forEach);
    }

    @Override
    @NotNull
    default public <G extends IntGrowable> G collect(@NotNull G destination) {
        destination.plusAssign(this);
        return destination;
    }

    default public int @NotNull [] toArray() {
        int s = this.knownSize();
        if (s == 0) {
            return IntArrays.EMPTY;
        }
        if (s > 0) {
            int[] arr = new int[s];
            int i = 0;
            IntIterator iterator = this.iterator();
            while (iterator.hasNext()) {
                int t = iterator.nextInt();
                arr[i++] = t;
            }
            return arr;
        }
        return this.iterator().toArray();
    }

    default public void forEach(@NotNull IntConsumer action) {
        this.iterator().forEach(action);
    }

    default public <Ex extends Throwable> void forEachChecked(@NotNull CheckedIntConsumer<Ex> action) throws Ex {
        this.forEach(action);
    }

    default public void forEachUnchecked(@NotNull CheckedIntConsumer<?> action) {
        this.forEach(action);
    }

    default public void forEachBreakable(@NotNull IntPredicate action) {
        Objects.requireNonNull(action);
        IntIterator it = this.iterator();
        while (it.hasNext() && action.test(it.nextInt())) {
        }
    }
}

