/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.Spliterator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntFunction;
import java.util.function.LongBinaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.stream.LongStream;
import kala.Conditions;
import kala.collection.base.primitive.AbstractLongIterator;
import kala.collection.base.primitive.LongIterator;
import kala.collection.base.primitive.LongTraversable;
import kala.control.primitive.LongOption;
import kala.function.LongObjBiFunction;
import kala.function.ObjLongBiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LongArrays {
    public static final long[] EMPTY = new long[0];
    private static final IntFunction<long[]> GENERATOR = long[]::new;

    private LongArrays() {
    }

    @Contract(pure=true)
    @NotNull
    public static IntFunction<long[]> generator() {
        return GENERATOR;
    }

    public static long @NotNull [] create(int length) {
        return new long[length];
    }

    @Contract(value="_ -> param1", pure=true)
    public static long @NotNull [] of(long ... values) {
        return values;
    }

    public static long @NotNull [] from(long @NotNull [] values) {
        return (long[])values.clone();
    }

    public static long @NotNull [] from(@NotNull LongTraversable values) {
        return values.toArray();
    }

    public static long @NotNull [] from(@NotNull LongIterator it) {
        return it.toArray();
    }

    public static long @NotNull [] from(@NotNull LongStream stream) {
        return stream.toArray();
    }

    @NotNull
    public static String className(long @NotNull [] array) {
        return "long[]";
    }

    @NotNull
    public static LongIterator iterator(long @NotNull [] array) {
        int arrayLength = array.length;
        switch (arrayLength) {
            case 0: {
                return LongIterator.empty();
            }
            case 1: {
                return LongIterator.of(array[0]);
            }
        }
        return new Itr(array, 0, arrayLength);
    }

    @NotNull
    public static LongIterator iterator(long @NotNull [] array, int beginIndex) {
        int arrayLength = array.length;
        Conditions.checkPositionIndex(beginIndex, arrayLength);
        switch (arrayLength - beginIndex) {
            case 0: {
                return LongIterator.empty();
            }
            case 1: {
                return LongIterator.of(array[beginIndex]);
            }
        }
        return new Itr(array, beginIndex, arrayLength);
    }

    @NotNull
    public static LongIterator iterator(long @NotNull [] array, int beginIndex, int endIndex) {
        int arrayLength = array.length;
        Conditions.checkPositionIndices(beginIndex, endIndex, arrayLength);
        switch (endIndex - beginIndex) {
            case 0: {
                return LongIterator.empty();
            }
            case 1: {
                return LongIterator.of(array[beginIndex]);
            }
        }
        return new Itr(array, beginIndex, endIndex);
    }

    @NotNull
    public static Spliterator.OfLong spliterator(long @NotNull [] array) {
        return Arrays.spliterator(array);
    }

    @NotNull
    public static LongStream stream(long @NotNull [] array) {
        return Arrays.stream(array);
    }

    @NotNull
    public static LongStream parallelStream(long @NotNull [] array) {
        return Arrays.stream(array).parallel();
    }

    public static boolean isEmpty(long @NotNull [] array) {
        return array.length == 0;
    }

    public static int size(long @NotNull [] array) {
        return array.length;
    }

    public static int knownSize(long @NotNull [] array) {
        return array.length;
    }

    public static boolean isDefineAt(long @NotNull [] array, int index) {
        return index >= 0 && index <= array.length;
    }

    public static long get(long @NotNull [] array, int index) {
        try {
            return array[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Nullable
    public static Long getOrNull(long @NotNull [] array, int index) {
        return index >= 0 && index <= array.length ? Long.valueOf(array[index]) : null;
    }

    @NotNull
    public static LongOption getOption(long @NotNull [] array, int index) {
        return index >= 0 && index <= array.length ? LongOption.some(array[index]) : LongOption.none();
    }

    public static void set(long @NotNull [] array, int index, long value) {
        try {
            array[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    public static long @NotNull [] reversed(long @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            return array;
        }
        long[] res = new long[length];
        for (int i = 0; i < length; ++i) {
            res[i] = array[length - i - 1];
        }
        return res;
    }

    @NotNull
    public static LongIterator reverseIterator(long @NotNull [] array) {
        int length = array.length;
        switch (length) {
            case 0: {
                return LongIterator.empty();
            }
            case 1: {
                return LongIterator.of(array[0]);
            }
        }
        return new ReverseItr(array, length - 1);
    }

    public static void shuffle(long @NotNull [] array) {
        LongArrays.shuffle(array, ThreadLocalRandom.current());
    }

    public static void shuffle(long @NotNull [] array, @NotNull Random random) {
        int size = array.length;
        if (size <= 1) {
            return;
        }
        for (int i = size; i > 1; --i) {
            int k = random.nextInt(i);
            long tmp = array[i - 1];
            array[i - 1] = array[k];
            array[k] = tmp;
        }
    }

    public static void sort(long @NotNull [] array) {
        Arrays.sort(array);
    }

    public static void sort(long @NotNull [] array, int beginIndex, int endIndex) {
        Arrays.sort(array, beginIndex, endIndex);
    }

    @NotNull
    public static LongOption find(long @NotNull [] array, @NotNull LongPredicate predicate) {
        for (long e : array) {
            if (!predicate.test(e)) continue;
            return LongOption.some(e);
        }
        return LongOption.none();
    }

    public static long first(long @NotNull [] array) {
        try {
            return array[0];
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            throw new NoSuchElementException();
        }
    }

    public static long last(long @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        return array[length - 1];
    }

    public static boolean contains(long @NotNull [] array, long value) {
        for (long o : array) {
            if (value != o) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(long @NotNull [] array, long @NotNull [] values) {
        for (long value : values) {
            if (LongArrays.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(long @NotNull [] array, @NotNull LongTraversable values) {
        LongIterator it = values.iterator();
        while (it.hasNext()) {
            long value = it.nextLong();
            if (LongArrays.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean anyMatch(long @NotNull [] array, @NotNull LongPredicate predicate) {
        for (long e : array) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    public static boolean allMatch(long @NotNull [] array, @NotNull LongPredicate predicate) {
        for (long e : array) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public static boolean noneMatch(long @NotNull [] array, @NotNull LongPredicate predicate) {
        for (long e : array) {
            if (!predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int indexOf(long @NotNull [] array, long value) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(long @NotNull [] array, long value, int beginIndex) {
        int length = array.length;
        if (beginIndex >= length) {
            return -1;
        }
        for (int i = Math.max(beginIndex, 0); i < length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexWhere(long @NotNull [] array, @NotNull LongPredicate predicate) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexWhere(long @NotNull [] array, @NotNull LongPredicate predicate, int beginIndex) {
        int length = array.length;
        if (beginIndex >= length) {
            return -1;
        }
        for (int i = Math.max(beginIndex, 0); i < length; ++i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOf(long @NotNull [] array, long value) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOf(long @NotNull [] array, long value, int endIndex) {
        if (endIndex < 0) {
            return -1;
        }
        for (int i = endIndex; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexWhere(long @NotNull [] array, @NotNull LongPredicate predicate) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexWhere(long @NotNull [] array, @NotNull LongPredicate predicate, int endIndex) {
        if (endIndex < 0) {
            return -1;
        }
        for (int i = endIndex; i >= 0; --i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static long max(long @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        long e = array[0];
        for (int i = 1; i < length; ++i) {
            long v = array[i];
            if (Long.compare(e, v) >= 0) continue;
            e = v;
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Long maxOrNull(long @NotNull [] array) {
        return array.length != 0 ? Long.valueOf(LongArrays.max(array)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static LongOption maxOption(long @NotNull [] array) {
        return array.length != 0 ? LongOption.some(LongArrays.max(array)) : LongOption.none();
    }

    @Contract(pure=true)
    public static long min(long @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        long e = array[0];
        for (int i = 1; i < length; ++i) {
            long v = array[i];
            if (Long.compare(e, v) <= 0) continue;
            e = v;
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Long minOrNull(long @NotNull [] array) {
        return array.length != 0 ? Long.valueOf(LongArrays.min(array)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static LongOption minOption(long @NotNull [] array) {
        return array.length != 0 ? LongOption.some(LongArrays.min(array)) : LongOption.none();
    }

    @Contract(pure=true)
    public static long fold(long @NotNull [] array, long zero, @NotNull LongBinaryOperator op) {
        return LongArrays.foldLeft(array, zero, op);
    }

    @Contract(pure=true)
    public static long foldLeft(long @NotNull [] array, long zero, @NotNull LongBinaryOperator op) {
        for (long e : array) {
            zero = op.applyAsLong(zero, e);
        }
        return zero;
    }

    @Contract(pure=true)
    public static <U> U foldLeftToObj(long @NotNull [] array, U zero, @NotNull ObjLongBiFunction<U, U> op) {
        for (long e : array) {
            zero = op.apply(zero, e);
        }
        return zero;
    }

    @Contract(pure=true)
    public static long foldRight(long @NotNull [] array, long zero, @NotNull LongBinaryOperator op) {
        for (int i = array.length - 1; i >= 0; --i) {
            zero = op.applyAsLong(array[i], zero);
        }
        return zero;
    }

    public static <U> U foldRightToObj(long @NotNull [] array, U zero, @NotNull LongObjBiFunction<U, U> op) {
        for (int i = array.length - 1; i >= 0; --i) {
            zero = op.apply(array[i], zero);
        }
        return zero;
    }

    @Contract(pure=true)
    public static long reduce(long @NotNull [] array, @NotNull LongBinaryOperator op) {
        return LongArrays.reduceLeft(array, op);
    }

    @Contract(pure=true)
    @NotNull
    public static LongOption reduceOption(long @NotNull [] array, @NotNull LongBinaryOperator op) {
        return LongArrays.reduceLeftOption(array, op);
    }

    @Contract(pure=true)
    public static long reduceLeft(long @NotNull [] array, @NotNull LongBinaryOperator op) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        long e = array[0];
        for (int i = 1; i < length; ++i) {
            e = op.applyAsLong(e, array[i]);
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Long reduceLeftOrNull(long @NotNull [] array, @NotNull LongBinaryOperator op) {
        return array.length != 0 ? Long.valueOf(LongArrays.reduceLeft(array, op)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static LongOption reduceLeftOption(long @NotNull [] array, @NotNull LongBinaryOperator op) {
        return array.length != 0 ? LongOption.some(LongArrays.reduceLeft(array, op)) : LongOption.none();
    }

    @Contract(pure=true)
    public static long reduceRight(long @NotNull [] array, @NotNull LongBinaryOperator op) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        long e = array[length - 1];
        for (int i = length - 2; i >= 0; --i) {
            e = op.applyAsLong(array[i], e);
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Long reduceRightOrNull(long @NotNull [] array, @NotNull LongBinaryOperator op) {
        return array.length != 0 ? Long.valueOf(LongArrays.reduceRight(array, op)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static LongOption reduceRightOption(long @NotNull [] array, @NotNull LongBinaryOperator op) {
        return array.length != 0 ? LongOption.some(LongArrays.reduceRight(array, op)) : LongOption.none();
    }

    @NotNull
    public static <A extends Appendable> A joinTo(long @NotNull [] array, @NotNull A buffer) {
        return LongArrays.joinTo(array, buffer, ", ", "", "");
    }

    @NotNull
    public static <A extends Appendable> A joinTo(long @NotNull [] array, @NotNull A buffer, CharSequence separator) {
        return LongArrays.joinTo(array, buffer, separator, "", "");
    }

    @NotNull
    public static <A extends Appendable> A joinTo(long @NotNull [] array, @NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        int length = array.length;
        try {
            if (length == 0) {
                buffer.append(prefix).append(postfix);
                return buffer;
            }
            buffer.append(prefix).append(String.valueOf(array[0]));
            for (int i = 1; i < length; ++i) {
                buffer.append(separator);
                buffer.append(Objects.toString(array[i]));
            }
            buffer.append(postfix);
            return buffer;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public static <A extends Appendable> A joinTo(long @NotNull [] array, @NotNull A buffer, @NotNull LongFunction<? extends CharSequence> transform) {
        return LongArrays.joinTo(array, buffer, ", ", "", "", transform);
    }

    @NotNull
    public static <A extends Appendable> A joinTo(long @NotNull [] array, @NotNull A buffer, CharSequence separator, @NotNull LongFunction<? extends CharSequence> transform) {
        return LongArrays.joinTo(array, buffer, separator, "", "", transform);
    }

    @NotNull
    public static <A extends Appendable> A joinTo(long @NotNull [] array, @NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull LongFunction<? extends CharSequence> transform) {
        int length = array.length;
        try {
            if (length == 0) {
                buffer.append(prefix).append(postfix);
                return buffer;
            }
            buffer.append(prefix).append(transform.apply(array[0]));
            for (int i = 1; i < length; ++i) {
                buffer.append(separator);
                buffer.append(transform.apply(array[i]));
            }
            buffer.append(postfix);
            return buffer;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public static String joinToString(long @NotNull [] array) {
        return LongArrays.joinTo(array, new StringBuilder()).toString();
    }

    @NotNull
    public static String joinToString(long @NotNull [] array, CharSequence separator) {
        return LongArrays.joinTo(array, new StringBuilder(), separator).toString();
    }

    @NotNull
    public static String joinToString(long @NotNull [] array, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return LongArrays.joinTo(array, new StringBuilder(), separator, prefix, postfix).toString();
    }

    @NotNull
    public static String joinToString(long @NotNull [] array, @NotNull LongFunction<? extends CharSequence> transform) {
        return LongArrays.joinTo(array, new StringBuilder(), transform).toString();
    }

    @NotNull
    public static String joinToString(long @NotNull [] array, CharSequence separator, @NotNull LongFunction<? extends CharSequence> transform) {
        return LongArrays.joinTo(array, new StringBuilder(), separator, transform).toString();
    }

    @NotNull
    public static String joinToString(long @NotNull [] array, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull LongFunction<? extends CharSequence> transform) {
        return LongArrays.joinTo(array, new StringBuilder(), separator, prefix, postfix, transform).toString();
    }

    private static final class Itr
    extends AbstractLongIterator {
        private final long @NotNull [] array;
        private final int endIndex;
        private int index;

        Itr(long @NotNull [] array, int beginIndex, int endIndex) {
            this.array = array;
            this.index = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.endIndex;
        }

        @Override
        public long nextLong() {
            if (this.index >= this.endIndex) {
                throw new NoSuchElementException(String.valueOf(this) + ".next()");
            }
            return this.array[this.index++];
        }
    }

    private static final class ReverseItr
    extends AbstractLongIterator {
        private final long @NotNull [] array;
        private int index;

        ReverseItr(long @NotNull [] array, int index) {
            this.array = array;
            this.index = index;
        }

        ReverseItr(long @NotNull [] array) {
            this(array, array.length - 1);
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public long nextLong() {
            try {
                return this.array[this.index--];
            }
            catch (ArrayIndexOutOfBoundsException ignored) {
                throw new NoSuchElementException();
            }
        }
    }
}

