/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.base.Growable;
import kala.collection.base.primitive.PrimitiveTraversable;
import kala.collection.base.primitive.ShortArrays;
import kala.collection.base.primitive.ShortGrowable;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.factory.primitive.ShortCollectionFactory;
import kala.control.primitive.ShortOption;
import kala.function.CheckedShortConsumer;
import kala.function.ObjShortBiFunction;
import kala.function.ShortBinaryOperator;
import kala.function.ShortConsumer;
import kala.function.ShortFunction;
import kala.function.ShortObjBiFunction;
import kala.function.ShortPredicate;
import kala.function.ShortUnaryOperator;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ShortTraversable
extends PrimitiveTraversable<Short> {
    @Override
    @NotNull
    public ShortIterator iterator();

    default public short elementAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0 && index >= knownSize) {
            throw new IndexOutOfBoundsException();
        }
        ShortIterator it = this.iterator();
        for (int i = 0; i < index; ++i) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            it.nextShort();
        }
        if (it.hasNext()) {
            return it.nextShort();
        }
        throw new IndexOutOfBoundsException("index: " + index);
    }

    @NotNull
    default public ShortOption find(@NotNull ShortPredicate predicate) {
        return this.iterator().find(predicate);
    }

    default public boolean contains(short value) {
        return this.knownSize() != 0 && this.iterator().contains(value);
    }

    default public boolean containsAll(short @NotNull [] values) {
        return this.iterator().containsAll(values);
    }

    default public boolean containsAll(@NotNull ShortTraversable values) {
        ShortIterator it = values.iterator();
        if (this.knownSize() == 0) {
            return !it.hasNext();
        }
        while (it.hasNext()) {
            if (this.contains(it.nextShort())) continue;
            return false;
        }
        return true;
    }

    default public boolean sameElements(@NotNull ShortTraversable other) {
        return this.iterator().sameElements(other.iterator());
    }

    default public boolean sameElements(@NotNull Iterable<?> other) {
        return this.iterator().sameElements(other.iterator());
    }

    default public boolean anyMatch(@NotNull ShortPredicate predicate) {
        return this.iterator().anyMatch(predicate);
    }

    default public boolean allMatch(@NotNull ShortPredicate predicate) {
        return this.iterator().allMatch(predicate);
    }

    default public boolean noneMatch(@NotNull ShortPredicate predicate) {
        return this.iterator().noneMatch(predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends ShortGrowable> G filterTo(@NotNull G destination, @NotNull ShortPredicate predicate) {
        return this.iterator().filterTo(destination, predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends ShortGrowable> G filterNotTo(@NotNull G destination, @NotNull ShortPredicate predicate) {
        return this.iterator().filterNotTo(destination, predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends ShortGrowable> G mapTo(@NotNull G destination, @NotNull ShortUnaryOperator mapper) {
        return this.iterator().mapTo(destination, mapper);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends Growable<? super U>> G mapToObjTo(@NotNull G destination, @NotNull ShortFunction<? extends U> mapper) {
        return this.iterator().mapToObjTo(destination, mapper);
    }

    default public int count(@NotNull ShortPredicate predicate) {
        return this.iterator().count(predicate);
    }

    default public short max() {
        if (this.knownSize() == 0) {
            throw new NoSuchElementException();
        }
        return this.iterator().max();
    }

    @Override
    @Nullable
    default public Short maxOrNull() {
        return this.isNotEmpty() ? Short.valueOf(this.max()) : null;
    }

    @NotNull
    default public ShortOption maxOption() {
        return this.knownSize() == 0 ? ShortOption.none() : this.iterator().maxOption();
    }

    default public short min() {
        if (this.knownSize() == 0) {
            throw new NoSuchElementException();
        }
        return this.iterator().min();
    }

    @Override
    @Nullable
    default public Short minOrNull() {
        return this.knownSize() == 0 ? null : this.iterator().minOrNull();
    }

    @NotNull
    default public ShortOption minOption() {
        return this.knownSize() == 0 ? ShortOption.none() : this.iterator().minOption();
    }

    default public short fold(short zero, @NotNull ShortBinaryOperator op) {
        return this.foldLeft(zero, op);
    }

    default public short foldLeft(short zero, @NotNull ShortBinaryOperator op) {
        return this.iterator().foldLeft(zero, op);
    }

    default public <U> U foldLeftToObj(U zero, @NotNull ObjShortBiFunction<U, U> op) {
        return this.iterator().foldLeftToObj(zero, op);
    }

    default public short foldRight(short zero, @NotNull ShortBinaryOperator op) {
        return this.iterator().foldRight(zero, op);
    }

    default public <U> U foldRightToObj(U zero, @NotNull ShortObjBiFunction<U, U> op) {
        return this.iterator().foldRightToObj(zero, op);
    }

    default public short reduce(@NotNull ShortBinaryOperator op) {
        return this.reduceLeft(op);
    }

    @Nullable
    default public Short reduceOrNull(@NotNull ShortBinaryOperator op) {
        return this.reduceLeftOrNull(op);
    }

    @NotNull
    default public ShortOption reduceOption(@NotNull ShortBinaryOperator op) {
        return this.reduceLeftOption(op);
    }

    default public short reduceLeft(@NotNull ShortBinaryOperator op) {
        return this.iterator().reduceLeft(op);
    }

    @Nullable
    default public Short reduceLeftOrNull(@NotNull ShortBinaryOperator op) {
        return this.isNotEmpty() ? Short.valueOf(this.reduceLeft(op)) : null;
    }

    @NotNull
    default public ShortOption reduceLeftOption(@NotNull ShortBinaryOperator op) {
        return this.isNotEmpty() ? ShortOption.some(this.reduceLeft(op)) : ShortOption.none();
    }

    default public short reduceRight(@NotNull ShortBinaryOperator op) {
        return this.iterator().reduceRight(op);
    }

    @Nullable
    default public Short reduceRightOrNull(@NotNull ShortBinaryOperator op) {
        return this.isNotEmpty() ? Short.valueOf(this.reduceRight(op)) : null;
    }

    @NotNull
    default public ShortOption reduceRightOption(@NotNull ShortBinaryOperator op) {
        return this.isNotEmpty() ? ShortOption.some(this.reduceRight(op)) : ShortOption.none();
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(short @NotNull [] dest) {
        return this.copyToArray(0, dest, 0, Integer.MAX_VALUE);
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(short @NotNull [] dest, int destPos) {
        return this.copyToArray(0, dest, destPos, Integer.MAX_VALUE);
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(short @NotNull [] dest, int destPos, int limit) {
        return this.copyToArray(0, dest, destPos, limit);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, short @NotNull [] dest) {
        return this.copyToArray(srcPos, dest, 0, Integer.MAX_VALUE);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, short @NotNull [] dest, int destPos) {
        return this.copyToArray(srcPos, dest, destPos, Integer.MAX_VALUE);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, short @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + srcPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        if (limit <= 0) {
            return 0;
        }
        int dl = dest.length;
        if (destPos > dl) {
            return 0;
        }
        int kn = this.knownSize();
        if (kn >= 0 && srcPos >= kn) {
            return 0;
        }
        int end = Math.min(dl - destPos, limit) + destPos;
        int n = 0;
        ShortIterator it = this.iterator();
        while (n++ < srcPos) {
            if (it.hasNext()) {
                it.nextShort();
                continue;
            }
            return 0;
        }
        int idx = destPos;
        while (it.hasNext() && idx < end) {
            dest[idx++] = it.nextShort();
        }
        return idx - destPos;
    }

    @Override
    default public <R, Builder> R collect(@NotNull ShortCollectionFactory<Builder, ? extends R> factory) {
        return ShortCollectionFactory.buildBy(factory, this::forEach);
    }

    @Override
    @NotNull
    default public <G extends ShortGrowable> G collect(@NotNull G destination) {
        destination.plusAssign(this);
        return destination;
    }

    default public short @NotNull [] toArray() {
        int s = this.knownSize();
        if (s == 0) {
            return ShortArrays.EMPTY;
        }
        if (s > 0) {
            short[] arr = new short[s];
            int i = 0;
            ShortIterator iterator = this.iterator();
            while (iterator.hasNext()) {
                short t = iterator.nextShort();
                arr[i++] = t;
            }
            return arr;
        }
        return this.iterator().toArray();
    }

    default public void forEach(@NotNull ShortConsumer action) {
        this.iterator().forEach(action);
    }

    default public <Ex extends Throwable> void forEachChecked(@NotNull CheckedShortConsumer<Ex> action) throws Ex {
        this.forEach(action);
    }

    default public void forEachUnchecked(@NotNull CheckedShortConsumer<?> action) {
        this.forEach(action);
    }

    default public void forEachBreakable(@NotNull ShortPredicate action) {
        Objects.requireNonNull(action);
        ShortIterator it = this.iterator();
        while (it.hasNext() && action.test(it.nextShort())) {
        }
    }
}

