/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.factory.primitive;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.base.primitive.BooleanTraversable;
import kala.collection.factory.primitive.BooleanCollectionBuilder;
import kala.collection.factory.primitive.PrimitiveCollectionFactory;
import kala.function.BooleanConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface BooleanCollectionFactory<Builder, R>
extends PrimitiveCollectionFactory<Boolean, Builder, R> {
    public static <Builder, R> BooleanCollectionFactory<Builder, R> narrow(BooleanCollectionFactory<Builder, ? extends R> factory) {
        return factory;
    }

    @ApiStatus.Experimental
    public static <Builder, R> R buildBy(@NotNull BooleanCollectionFactory<Builder, R> factory, Consumer<BooleanConsumer> consumer) {
        Object builder = factory.newBuilder();
        consumer.accept(value -> factory.addToBuilder((Builder)builder, value));
        return factory.build(builder);
    }

    @ApiStatus.Experimental
    @NotNull
    default public BooleanCollectionBuilder<R> newCollectionBuilder(final Builder builder) {
        return new BooleanCollectionBuilder<R>(){

            @Override
            public void plusAssign(boolean value) {
                BooleanCollectionFactory.this.addToBuilder(builder, value);
            }

            @Override
            public void sizeHint(int size) {
                BooleanCollectionFactory.this.sizeHint(builder, size);
            }

            @Override
            public R build() {
                return BooleanCollectionFactory.this.build(builder);
            }
        };
    }

    @ApiStatus.Experimental
    @NotNull
    default public BooleanCollectionBuilder<R> newCollectionBuilder() {
        return this.newCollectionBuilder(this.newBuilder());
    }

    @ApiStatus.Experimental
    @NotNull
    default public BooleanCollectionBuilder<R> newCollectionBuilder(int capacity) {
        return this.newCollectionBuilder(this.newBuilder(capacity));
    }

    @Override
    public void addToBuilder(@NotNull Builder var1, boolean var2);

    @Override
    default public void addToBuilder(@NotNull Builder builder, Boolean value) {
        this.addToBuilder(builder, (boolean)value);
    }

    default public void addAllToBuilder(@NotNull Builder builder, @NotNull BooleanTraversable values) {
        this.addAllToBuilder(builder, values.iterator());
    }

    default public void addAllToBuilder(@NotNull Builder builder, @NotNull BooleanIterator it) {
        while (it.hasNext()) {
            this.addToBuilder(builder, it.nextBoolean());
        }
    }

    default public void addAllToBuilder(@NotNull Builder builder, boolean @NotNull [] values) {
        Objects.requireNonNull(values);
        for (boolean value : values) {
            this.addToBuilder(builder, value);
        }
    }

    @Override
    default public R fill(int n, boolean value) {
        if (n <= 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, n);
        for (int i = 0; i < n; ++i) {
            this.addToBuilder((Builder)builder, value);
        }
        return this.build(builder);
    }

    @Override
    default public R fill(int n, BooleanSupplier supplier) {
        if (n <= 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, n);
        for (int i = 0; i < n; ++i) {
            this.addToBuilder((Builder)builder, supplier.getAsBoolean());
        }
        return this.build(builder);
    }

    @Override
    default public R fill(int n, Boolean value) {
        return this.fill(n, (boolean)value);
    }

    default public R from(boolean @NotNull [] values) {
        if (values.length == 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, values.length);
        this.addAllToBuilder(builder, values);
        return this.build(builder);
    }

    default public R from(@NotNull BooleanTraversable values) {
        Object builder = this.newBuilder();
        this.sizeHint(builder, values);
        this.addAllToBuilder(builder, values);
        return this.build(builder);
    }

    default public R from(@NotNull BooleanIterator it) {
        if (!it.hasNext()) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.addAllToBuilder(builder, it);
        return this.build(builder);
    }

    @Override
    @NotNull
    default public <U> BooleanCollectionFactory<Builder, U> mapResult(final @NotNull Function<? super R, ? extends U> mapper) {
        final BooleanCollectionFactory self = this;
        return new BooleanCollectionFactory<Builder, U>(){

            @Override
            public void addToBuilder(@NotNull Builder builder, boolean value) {
                self.addToBuilder(builder, value);
            }

            @Override
            public Builder newBuilder() {
                return self.newBuilder();
            }

            @Override
            public U build(Builder builder) {
                return mapper.apply(self.build(builder));
            }

            @Override
            public Builder mergeBuilder(@NotNull Builder builder1, @NotNull Builder builder2) {
                return self.mergeBuilder(builder1, builder2);
            }
        };
    }
}

