/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.factory.primitive;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import kala.collection.base.primitive.ByteIterator;
import kala.collection.base.primitive.ByteTraversable;
import kala.collection.factory.primitive.ByteCollectionBuilder;
import kala.collection.factory.primitive.PrimitiveCollectionFactory;
import kala.function.ByteConsumer;
import kala.function.ByteSupplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface ByteCollectionFactory<Builder, R>
extends PrimitiveCollectionFactory<Byte, Builder, R> {
    public static <Builder, R> ByteCollectionFactory<Builder, R> narrow(ByteCollectionFactory<Builder, ? extends R> factory) {
        return factory;
    }

    @ApiStatus.Experimental
    public static <Builder, R> R buildBy(@NotNull ByteCollectionFactory<Builder, R> factory, Consumer<ByteConsumer> consumer) {
        Object builder = factory.newBuilder();
        consumer.accept(value -> factory.addToBuilder((Builder)builder, value));
        return factory.build(builder);
    }

    @ApiStatus.Experimental
    @NotNull
    default public ByteCollectionBuilder<R> newCollectionBuilder(final Builder builder) {
        return new ByteCollectionBuilder<R>(){

            @Override
            public void plusAssign(byte value) {
                ByteCollectionFactory.this.addToBuilder(builder, value);
            }

            @Override
            public void sizeHint(int size) {
                ByteCollectionFactory.this.sizeHint(builder, size);
            }

            @Override
            public R build() {
                return ByteCollectionFactory.this.build(builder);
            }
        };
    }

    @ApiStatus.Experimental
    @NotNull
    default public ByteCollectionBuilder<R> newCollectionBuilder() {
        return this.newCollectionBuilder(this.newBuilder());
    }

    @ApiStatus.Experimental
    @NotNull
    default public ByteCollectionBuilder<R> newCollectionBuilder(int capacity) {
        return this.newCollectionBuilder(this.newBuilder(capacity));
    }

    @Override
    public void addToBuilder(@NotNull Builder var1, byte var2);

    @Override
    default public void addToBuilder(@NotNull Builder builder, Byte value) {
        this.addToBuilder(builder, (byte)value);
    }

    default public void addAllToBuilder(@NotNull Builder builder, @NotNull ByteTraversable values) {
        this.addAllToBuilder(builder, values.iterator());
    }

    default public void addAllToBuilder(@NotNull Builder builder, @NotNull ByteIterator it) {
        while (it.hasNext()) {
            this.addToBuilder(builder, it.nextByte());
        }
    }

    default public void addAllToBuilder(@NotNull Builder builder, byte @NotNull [] values) {
        Objects.requireNonNull(values);
        for (byte value : values) {
            this.addToBuilder(builder, value);
        }
    }

    @Override
    default public R fill(int n, byte value) {
        if (n <= 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, n);
        for (int i = 0; i < n; ++i) {
            this.addToBuilder((Builder)builder, value);
        }
        return this.build(builder);
    }

    @Override
    default public R fill(int n, ByteSupplier supplier) {
        if (n <= 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, n);
        for (int i = 0; i < n; ++i) {
            this.addToBuilder((Builder)builder, supplier.getAsByte());
        }
        return this.build(builder);
    }

    @Override
    default public R fill(int n, Byte value) {
        return this.fill(n, (byte)value);
    }

    default public R from(byte @NotNull [] values) {
        if (values.length == 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, values.length);
        this.addAllToBuilder(builder, values);
        return this.build(builder);
    }

    default public R from(@NotNull ByteTraversable values) {
        Object builder = this.newBuilder();
        this.sizeHint(builder, values);
        this.addAllToBuilder(builder, values);
        return this.build(builder);
    }

    default public R from(@NotNull ByteIterator it) {
        if (!it.hasNext()) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.addAllToBuilder(builder, it);
        return this.build(builder);
    }

    @Override
    @NotNull
    default public <U> ByteCollectionFactory<Builder, U> mapResult(final @NotNull Function<? super R, ? extends U> mapper) {
        final ByteCollectionFactory self = this;
        return new ByteCollectionFactory<Builder, U>(){

            @Override
            public void addToBuilder(@NotNull Builder builder, byte value) {
                self.addToBuilder(builder, value);
            }

            @Override
            public Builder newBuilder() {
                return self.newBuilder();
            }

            @Override
            public U build(Builder builder) {
                return mapper.apply(self.build(builder));
            }

            @Override
            public Builder mergeBuilder(@NotNull Builder builder1, @NotNull Builder builder2) {
                return self.mergeBuilder(builder1, builder2);
            }
        };
    }
}

