/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.factory.primitive;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.base.primitive.DoubleTraversable;
import kala.collection.factory.primitive.DoubleCollectionBuilder;
import kala.collection.factory.primitive.PrimitiveCollectionFactory;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface DoubleCollectionFactory<Builder, R>
extends PrimitiveCollectionFactory<Double, Builder, R> {
    public static <Builder, R> DoubleCollectionFactory<Builder, R> narrow(DoubleCollectionFactory<Builder, ? extends R> factory) {
        return factory;
    }

    @ApiStatus.Experimental
    public static <Builder, R> R buildBy(@NotNull DoubleCollectionFactory<Builder, R> factory, Consumer<DoubleConsumer> consumer) {
        Object builder = factory.newBuilder();
        consumer.accept(value -> factory.addToBuilder((Builder)builder, value));
        return factory.build(builder);
    }

    @ApiStatus.Experimental
    @NotNull
    default public DoubleCollectionBuilder<R> newCollectionBuilder(final Builder builder) {
        return new DoubleCollectionBuilder<R>(){

            @Override
            public void plusAssign(double value) {
                DoubleCollectionFactory.this.addToBuilder(builder, value);
            }

            @Override
            public void sizeHint(int size) {
                DoubleCollectionFactory.this.sizeHint(builder, size);
            }

            @Override
            public R build() {
                return DoubleCollectionFactory.this.build(builder);
            }
        };
    }

    @ApiStatus.Experimental
    @NotNull
    default public DoubleCollectionBuilder<R> newCollectionBuilder() {
        return this.newCollectionBuilder(this.newBuilder());
    }

    @ApiStatus.Experimental
    @NotNull
    default public DoubleCollectionBuilder<R> newCollectionBuilder(int capacity) {
        return this.newCollectionBuilder(this.newBuilder(capacity));
    }

    @Override
    public void addToBuilder(@NotNull Builder var1, double var2);

    @Override
    default public void addToBuilder(@NotNull Builder builder, Double value) {
        this.addToBuilder(builder, (double)value);
    }

    default public void addAllToBuilder(@NotNull Builder builder, @NotNull DoubleTraversable values) {
        this.addAllToBuilder(builder, values.iterator());
    }

    default public void addAllToBuilder(@NotNull Builder builder, @NotNull DoubleIterator it) {
        while (it.hasNext()) {
            this.addToBuilder(builder, it.nextDouble());
        }
    }

    default public void addAllToBuilder(@NotNull Builder builder, double @NotNull [] values) {
        Objects.requireNonNull(values);
        for (double value : values) {
            this.addToBuilder(builder, value);
        }
    }

    @Override
    default public R fill(int n, double value) {
        if (n <= 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, n);
        for (int i = 0; i < n; ++i) {
            this.addToBuilder((Builder)builder, value);
        }
        return this.build(builder);
    }

    @Override
    default public R fill(int n, DoubleSupplier supplier) {
        if (n <= 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, n);
        for (int i = 0; i < n; ++i) {
            this.addToBuilder((Builder)builder, supplier.getAsDouble());
        }
        return this.build(builder);
    }

    @Override
    default public R fill(int n, Double value) {
        return this.fill(n, (double)value);
    }

    default public R from(double @NotNull [] values) {
        if (values.length == 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, values.length);
        this.addAllToBuilder(builder, values);
        return this.build(builder);
    }

    default public R from(@NotNull DoubleTraversable values) {
        Object builder = this.newBuilder();
        this.sizeHint(builder, values);
        this.addAllToBuilder(builder, values);
        return this.build(builder);
    }

    default public R from(@NotNull DoubleIterator it) {
        if (!it.hasNext()) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.addAllToBuilder(builder, it);
        return this.build(builder);
    }

    @Override
    @NotNull
    default public <U> DoubleCollectionFactory<Builder, U> mapResult(final @NotNull Function<? super R, ? extends U> mapper) {
        final DoubleCollectionFactory self = this;
        return new DoubleCollectionFactory<Builder, U>(){

            @Override
            public void addToBuilder(@NotNull Builder builder, double value) {
                self.addToBuilder(builder, value);
            }

            @Override
            public Builder newBuilder() {
                return self.newBuilder();
            }

            @Override
            public U build(Builder builder) {
                return mapper.apply(self.build(builder));
            }

            @Override
            public Builder mergeBuilder(@NotNull Builder builder1, @NotNull Builder builder2) {
                return self.mergeBuilder(builder1, builder2);
            }
        };
    }
}

