/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.factory.primitive;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.base.primitive.ShortTraversable;
import kala.collection.factory.primitive.PrimitiveCollectionFactory;
import kala.collection.factory.primitive.ShortCollectionBuilder;
import kala.function.ShortConsumer;
import kala.function.ShortSupplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface ShortCollectionFactory<Builder, R>
extends PrimitiveCollectionFactory<Short, Builder, R> {
    public static <Builder, R> ShortCollectionFactory<Builder, R> narrow(ShortCollectionFactory<Builder, ? extends R> factory) {
        return factory;
    }

    @ApiStatus.Experimental
    public static <Builder, R> R buildBy(@NotNull ShortCollectionFactory<Builder, R> factory, Consumer<ShortConsumer> consumer) {
        Object builder = factory.newBuilder();
        consumer.accept(value -> factory.addToBuilder((Builder)builder, value));
        return factory.build(builder);
    }

    @ApiStatus.Experimental
    @NotNull
    default public ShortCollectionBuilder<R> newCollectionBuilder(final Builder builder) {
        return new ShortCollectionBuilder<R>(){

            @Override
            public void plusAssign(short value) {
                ShortCollectionFactory.this.addToBuilder(builder, value);
            }

            @Override
            public void sizeHint(int size) {
                ShortCollectionFactory.this.sizeHint(builder, size);
            }

            @Override
            public R build() {
                return ShortCollectionFactory.this.build(builder);
            }
        };
    }

    @ApiStatus.Experimental
    @NotNull
    default public ShortCollectionBuilder<R> newCollectionBuilder() {
        return this.newCollectionBuilder(this.newBuilder());
    }

    @ApiStatus.Experimental
    @NotNull
    default public ShortCollectionBuilder<R> newCollectionBuilder(int capacity) {
        return this.newCollectionBuilder(this.newBuilder(capacity));
    }

    @Override
    public void addToBuilder(@NotNull Builder var1, short var2);

    @Override
    default public void addToBuilder(@NotNull Builder builder, Short value) {
        this.addToBuilder(builder, (short)value);
    }

    default public void addAllToBuilder(@NotNull Builder builder, @NotNull ShortTraversable values) {
        this.addAllToBuilder(builder, values.iterator());
    }

    default public void addAllToBuilder(@NotNull Builder builder, @NotNull ShortIterator it) {
        while (it.hasNext()) {
            this.addToBuilder(builder, it.nextShort());
        }
    }

    default public void addAllToBuilder(@NotNull Builder builder, short @NotNull [] values) {
        Objects.requireNonNull(values);
        for (short value : values) {
            this.addToBuilder(builder, value);
        }
    }

    @Override
    default public R fill(int n, short value) {
        if (n <= 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, n);
        for (int i = 0; i < n; ++i) {
            this.addToBuilder((Builder)builder, value);
        }
        return this.build(builder);
    }

    @Override
    default public R fill(int n, ShortSupplier supplier) {
        if (n <= 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, n);
        for (int i = 0; i < n; ++i) {
            this.addToBuilder((Builder)builder, supplier.getAsShort());
        }
        return this.build(builder);
    }

    @Override
    default public R fill(int n, Short value) {
        return this.fill(n, (short)value);
    }

    default public R from(short @NotNull [] values) {
        if (values.length == 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, values.length);
        this.addAllToBuilder(builder, values);
        return this.build(builder);
    }

    default public R from(@NotNull ShortTraversable values) {
        Object builder = this.newBuilder();
        this.sizeHint(builder, values);
        this.addAllToBuilder(builder, values);
        return this.build(builder);
    }

    default public R from(@NotNull ShortIterator it) {
        if (!it.hasNext()) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.addAllToBuilder(builder, it);
        return this.build(builder);
    }

    @Override
    @NotNull
    default public <U> ShortCollectionFactory<Builder, U> mapResult(final @NotNull Function<? super R, ? extends U> mapper) {
        final ShortCollectionFactory self = this;
        return new ShortCollectionFactory<Builder, U>(){

            @Override
            public void addToBuilder(@NotNull Builder builder, short value) {
                self.addToBuilder(builder, value);
            }

            @Override
            public Builder newBuilder() {
                return self.newBuilder();
            }

            @Override
            public U build(Builder builder) {
                return mapper.apply(self.build(builder));
            }

            @Override
            public Builder mergeBuilder(@NotNull Builder builder1, @NotNull Builder builder2) {
                return self.mergeBuilder(builder1, builder2);
            }
        };
    }
}

