/*
 * Decompiled with CFR 0.152.
 */
package kala.control;

import java.io.Serializable;
import java.util.function.Supplier;
import kala.control.AnyOption;
import kala.control.Option;
import kala.control.Try;
import kala.control.primitive.PrimitiveTry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface AnyTry<T>
extends Serializable
permits Try, PrimitiveTry {
    public static final int SUCCESS_HASH_MAGIC = "SUCCESS".hashCode();
    public static final int FAILURE_HASH_MAGIC = "FAILURE".hashCode();

    public boolean isSuccess();

    public boolean isFailure();

    public T getValue();

    @Nullable
    public T getOrNull();

    public AnyOption<T> getOption();

    @NotNull
    public Throwable getCause();

    @Nullable
    default public Throwable getCauseOrNull() {
        return this.isFailure() ? this.getCause() : null;
    }

    @NotNull
    default public Option<Throwable> getCauseOption() {
        return this.isFailure() ? Option.some(this.getCause()) : Option.none();
    }

    default public Throwable getCauseOrDefault(Throwable defaultValue) {
        return this.isFailure() ? this.getCause() : defaultValue;
    }

    default public Throwable getCauseOrElse(@NotNull Supplier<? extends Throwable> supplier) {
        return this.isFailure() ? this.getCause() : supplier.get();
    }

    @NotNull
    public <Ex extends Throwable> AnyTry<T> rethrow() throws Ex;

    @NotNull
    public <Ex extends Throwable> AnyTry<T> rethrow(@NotNull Class<? extends Ex> var1) throws Ex;

    @NotNull
    public AnyTry<T> rethrowFatal();
}

