/*
 * Decompiled with CFR 0.152.
 */
package kala.control;

import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import kala.control.Option;
import kala.control.OptionContainer;
import kala.control.Result;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public sealed interface Either<A, B>
extends Serializable {
    @Contract(value="_ -> param1", pure=true)
    public static <A, B> Either<A, B> narrow(Either<? extends A, ? extends B> either) {
        return either;
    }

    @Contract(value="_ -> param1", pure=true)
    public static <A, B> Left<A, B> narrow(Left<? extends A, ? extends B> left) {
        return left;
    }

    @Contract(value="_ -> param1", pure=true)
    public static <A, B> Right<A, B> narrow(Right<? extends A, ? extends B> right) {
        return right;
    }

    @Contract(value="_ -> new")
    public static <A, B> @NotNull Left<A, B> left(A value) {
        return new Left(value);
    }

    @Contract(value="_ -> new")
    public static <A, B> @NotNull Right<A, B> right(B value) {
        return new Right(value);
    }

    public static <T> T join(@NotNull Either<? extends T, ? extends T> either) {
        if (either.isLeft()) {
            return either.getLeftValue();
        }
        return either.getRightValue();
    }

    default public boolean isLeft() {
        return this instanceof Left;
    }

    default public boolean isRight() {
        return this instanceof Right;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public A getLeftValue() {
        Object value;
        Either either = this;
        if (!(either instanceof Left)) throw new NoSuchElementException("Either.Right#getLeftValue");
        Left left = (Left)either;
        try {
            Object a;
            value = a = left.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    default public Option<A> getLeftOption() {
        Object value;
        Option<Object> option;
        Either either = this;
        if (!(either instanceof Left)) {
            option = Option.none();
            return option;
        }
        Left left = (Left)either;
        try {
            Object a;
            value = a = left.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        option = Option.some(value);
        return option;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public B getRightValue() {
        Object value;
        Either either = this;
        if (!(either instanceof Right)) throw new NoSuchElementException("Either.Right#getLeftValue");
        Right right = (Right)either;
        try {
            Object b;
            value = b = right.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    default public Option<B> getRightOption() {
        Object value;
        Option<Object> option;
        Either either = this;
        if (!(either instanceof Right)) {
            option = Option.none();
            return option;
        }
        Right right = (Right)either;
        try {
            Object b;
            value = b = right.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        option = Option.some(value);
        return option;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    default public <U, V> Either<U, V> map(@NotNull Function<? super A, ? extends U> leftMapper, @NotNull Function<? super B, ? extends V> rightMapper) {
        Object value;
        Record record;
        Either either = this;
        Objects.requireNonNull(either);
        Either either2 = either;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Left.class, Right.class}, (Object)either2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Object value2;
                Left left = (Left)either2;
                try {
                    Object a;
                    value2 = a = left.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                record = Either.left(leftMapper.apply(value2));
                return record;
            }
            case 1: 
        }
        Right right = (Right)either2;
        {
            Object b;
            value = b = right.value();
        }
        record = Either.right(rightMapper.apply(value));
        return record;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    default public <U> Either<U, B> mapLeft(@NotNull Function<? super A, ? extends U> mapper) {
        Object value;
        Left<U, B> left;
        Left<U, B> left2 = this;
        if (!(left2 instanceof Left)) {
            left = this;
            return left;
        }
        Left left3 = left2;
        try {
            Object a;
            value = a = left3.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        left = Either.left(mapper.apply(value));
        return left;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    default public <U> Either<A, U> mapRight(@NotNull Function<? super B, ? extends U> mapper) {
        Object value;
        Right<A, U> right;
        Right<A, U> right2 = this;
        if (!(right2 instanceof Right)) {
            right = this;
            return right;
        }
        Right right3 = right2;
        try {
            Object b;
            value = b = right3.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        right = Either.right(mapper.apply(value));
        return right;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <U> U fold(@NotNull Function<? super A, ? extends U> leftMapper, @NotNull Function<? super B, ? extends U> rightMapper) {
        U u;
        Either either = this;
        Objects.requireNonNull(either);
        Either either2 = either;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Left.class, Right.class}, (Object)either2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Left left = (Left)either2;
                try {
                    Object a;
                    Object value = a = left.value();
                    u = leftMapper.apply(value);
                    return u;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: 
        }
        Right right = (Right)either2;
        {
            Object b;
            Object value = b = right.value();
            u = rightMapper.apply(value);
        }
        return u;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public <C, D, U> U bifold(@NotNull Either<? extends C, ? extends D> other, U defaultValue, @NotNull BiFunction<? super A, ? super C, ? extends U> leftMapper, @NotNull BiFunction<? super B, ? super D, ? extends U> rightMapper) {
        Object value1;
        Object object;
        Record record;
        Either<A, B> either = this;
        if (either instanceof Left) {
            record = (Left)either;
            value1 = object = ((Left)record).value();
            if (other instanceof Left) {
                Left left = (Left)other;
                Either<A, B> value2 = either = left.value();
                return (U)leftMapper.apply(value1, value2);
            }
        }
        if (!((either = this) instanceof Right)) return defaultValue;
        record = (Right)either;
        try {
            value1 = object = ((Right)record).value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (!(other instanceof Right)) return defaultValue;
        Right right = (Right)other;
        Either<A, B> value2 = either = right.value();
        return (U)rightMapper.apply(value1, value2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Contract(value="-> new")
    @NotNull
    default public Either<B, A> swap() {
        Object value;
        Record record;
        Either either = this;
        Objects.requireNonNull(either);
        Either either2 = either;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Left.class, Right.class}, (Object)either2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Object value2;
                Left left = (Left)either2;
                try {
                    Object a;
                    value2 = a = left.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                record = Either.right(value2);
                return record;
            }
            case 1: 
        }
        Right right = (Right)either2;
        {
            Object b;
            value = b = right.value();
        }
        record = Either.left(value);
        return record;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Contract(value="-> new")
    @NotNull
    default public Result<B, A> toResult() {
        Object value;
        Result<Object, Object> result;
        Either either = this;
        Objects.requireNonNull(either);
        Either either2 = either;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Left.class, Right.class}, (Object)either2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Object value2;
                Left left = (Left)either2;
                try {
                    Object a;
                    value2 = a = left.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                result = Result.err(value2);
                return result;
            }
            case 1: 
        }
        Right right = (Right)either2;
        {
            Object b;
            value = b = right.value();
        }
        result = Result.ok(value);
        return result;
    }

    @Contract(value=" -> new")
    @NotNull
    default public LeftProjection<A, B> leftProjection() {
        return new LeftProjection(this);
    }

    @Contract(value=" -> new")
    @NotNull
    default public RightProjection<A, B> rightProjection() {
        return new RightProjection(this);
    }

    default public void forEach(@NotNull Consumer<? super A> leftConsumer, @NotNull Consumer<? super B> rightConsumer) {
        Either either = this;
        Objects.requireNonNull(either);
        Either either2 = either;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Left.class, Right.class}, (Object)either2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Object a;
                Left left = (Left)either2;
                Object value = a = left.value();
                leftConsumer.accept(value);
                break;
            }
            case 1: {
                Right right = (Right)either2;
                try {
                    Object b;
                    Object value = b = right.value();
                    rightConsumer.accept(value);
                    break;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
    }

    public record Left<A, B>(A value) implements Either<A, B>
    {
        @Override
        public String toString() {
            return "Either.Left[" + String.valueOf(this.value) + "]";
        }
    }

    public record Right<A, B>(B value) implements Either<A, B>
    {
        @Override
        public String toString() {
            return "Either.Right[" + String.valueOf(this.value) + "]";
        }
    }

    public record LeftProjection<A, B>(Either<A, B> either) implements Projection<A, A, B>
    {
        @Override
        @NotNull
        public Either<A, B> getEither() {
            return this.either;
        }

        @Override
        public boolean isDefined() {
            return this.either.isLeft();
        }

        @Override
        public A get() {
            return this.either.getLeftValue();
        }

        @NotNull
        public <U> LeftProjection<U, B> map(@NotNull Function<? super A, ? extends U> mapper) {
            Objects.requireNonNull(mapper);
            if (this.isDefined()) {
                return new LeftProjection(Either.left(mapper.apply(this.either.getLeftValue())));
            }
            return this;
        }

        @Override
        @NotNull
        public String toString() {
            return String.valueOf(this.either) + ".LeftProjection";
        }
    }

    public record RightProjection<A, B>(Either<A, B> either) implements Projection<B, A, B>
    {
        @Override
        @NotNull
        public Either<A, B> getEither() {
            return this.either;
        }

        @Override
        public boolean isDefined() {
            return this.either.isRight();
        }

        @Override
        public B get() {
            return this.either.getRightValue();
        }

        @NotNull
        public <U> RightProjection<A, U> map(@NotNull Function<? super B, ? extends U> mapper) {
            Objects.requireNonNull(mapper);
            if (this.isDefined()) {
                return new RightProjection(Either.right(mapper.apply(this.either.getRightValue())));
            }
            return this;
        }

        @Override
        @NotNull
        public String toString() {
            return String.valueOf(this.either) + ".RightProjection";
        }
    }

    public static sealed interface Projection<T, A, B>
    extends OptionContainer<T>
    permits LeftProjection, RightProjection {
        @NotNull
        public Either<A, B> getEither();
    }
}

