/*
 * Decompiled with CFR 0.152.
 */
package kala.control;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kala.collection.base.Iterators;
import kala.control.AnyOption;
import kala.control.OptionContainer;
import kala.control.Result;
import kala.control.primitive.PrimitiveOption;
import kala.tuple.Tuple2;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Option<T>
implements AnyOption<T>,
OptionContainer<T>,
Serializable {
    private static final long serialVersionUID = 4055633765420871779L;
    public static final Option<?> None = new Option<Object>(null);
    private final T value;

    private Option(T value) {
        this.value = value;
    }

    @Contract(value="_ -> param1", pure=true)
    public static <T> Option<T> narrow(Option<? extends T> option) {
        return option;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> Option<T> some(T value) {
        return new Option<T>(value);
    }

    @NotNull
    public static <T> Option<T> none() {
        return None;
    }

    @NotNull
    public static <T> Option<T> ofNullable(@Nullable T value) {
        return value != null ? new Option<T>(value) : Option.none();
    }

    @NotNull
    public static <T> Option<T> fromJava(@NotNull Optional<? extends T> optional) {
        return Option.ofNullable(optional.orElse(null));
    }

    @Override
    public boolean isDefined() {
        return this != None;
    }

    @Override
    public boolean isEmpty() {
        return this == None;
    }

    @Override
    @Flow(sourceIsContainer=true)
    public T get() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Option.None");
        }
        return this.value;
    }

    @Override
    @Contract(value="-> this", pure=true)
    @NotNull
    public Option<T> getOption() {
        return this;
    }

    @Override
    @Contract(value="-> this", pure=true)
    @NotNull
    public Option<T> toOption() {
        return this;
    }

    @NotNull
    public Option<T> orElse(Option<? extends T> other) {
        return this.isDefined() ? this : Option.narrow(other);
    }

    @NotNull
    public Option<T> orElse(@NotNull @NotNull Supplier<? extends @NotNull Option<? extends T>> other) {
        return this.isDefined() ? this : Option.narrow(other.get());
    }

    @Override
    @NotNull
    public <U> Option<U> map(@NotNull Function<? super T, ? extends U> mapper) {
        return this.isDefined() ? Option.some(mapper.apply(this.value)) : Option.none();
    }

    @NotNull
    public <U> @NotNull Option<@NotNull U> mapNotNull(@NotNull Function<? super T, ? extends @Nullable U> mapper) {
        return this.isDefined() ? Option.ofNullable(mapper.apply(this.value)) : Option.none();
    }

    @NotNull
    public <U> Option<U> flatMap(@NotNull Function<? super T, ? extends Option<? extends U>> mapper) {
        return this.isDefined() ? Option.narrow(mapper.apply(this.value)) : Option.none();
    }

    @NotNull
    public Option<T> filter(@NotNull Predicate<? super T> predicate) {
        return this.isDefined() && predicate.test(this.value) ? this : Option.none();
    }

    @NotNull
    public Option<T> filterNot(@NotNull Predicate<? super T> predicate) {
        return this.isDefined() && !predicate.test(this.value) ? this : Option.none();
    }

    @NotNull
    public @NotNull Option<@NotNull T> filterNotNull() {
        return this.value == null ? Option.none() : this;
    }

    @NotNull
    public @NotNull Tuple2<@NotNull Option<T>, @NotNull Option<T>> span(@NotNull Predicate<? super T> predicate) {
        if (this.isEmpty()) {
            return new Tuple2<Option<T>, Option<T>>(Option.none(), Option.none());
        }
        if (predicate.test(this.value)) {
            return new Tuple2<Option<T>, Option<T>>(this, Option.none());
        }
        return new Tuple2<Option<T>, Option<T>>(Option.none(), this);
    }

    @NotNull
    public <U> Result<T, U> toResult(U errValue) {
        return this.isDefined() ? Result.ok(this.value) : Result.err(errValue);
    }

    @Override
    @Contract(pure=true)
    public boolean contains(Object value) {
        return this.isDefined() && Objects.equals(this.value, value);
    }

    @Override
    @NotNull
    public Option<T> find(@NotNull Predicate<? super T> predicate) {
        return this.isDefined() && predicate.test(this.value) ? this : Option.none();
    }

    @NotNull
    public Optional<T> asJava() {
        return this.isDefined() ? Optional.of(this.value) : Optional.empty();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.isDefined() ? Iterators.of(this.value) : Iterators.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Option) {
            Option other = (Option)o;
            return Objects.equals(this.value, other.value) && this != None && o != None;
        }
        if (o instanceof PrimitiveOption) {
            return o.equals(this);
        }
        return false;
    }

    public int hashCode() {
        return this.isDefined() ? Objects.hashCode(this.value) + -818206074 : 1937147281;
    }

    @Contract(pure=true)
    @NotNull
    public String toString() {
        if (this == None) {
            return "Option.None";
        }
        return "Option[" + String.valueOf(this.value) + "]";
    }

    private Object writeReplace() {
        return this == None ? NoneReplaced.INSTANCE : this;
    }

    static final class NoneReplaced
    implements Serializable {
        private static final long serialVersionUID = 0L;
        static final NoneReplaced INSTANCE = new NoneReplaced();

        private NoneReplaced() {
        }

        private Object readResolve() {
            return None;
        }
    }
}

